package biss.jde;

import biss.VectorLib;
import biss.XorSet;
import biss.awt.Awt;
import biss.awt.BarMenu;
import biss.awt.Border;
import biss.awt.Button;
import biss.awt.Checkbox;
import biss.awt.Choice;
import biss.awt.DecoBox;
import biss.awt.DecoGroup;
import biss.awt.DecoText;
import biss.awt.Label;
import biss.awt.Layouter;
import biss.awt.List;
import biss.awt.Menu;
import biss.awt.Notebook;
import biss.awt.SpinButton;
import biss.awt.TextField;
import biss.awt.TopWindow;
import java.awt.Rectangle;

/**
 * physical view of the Designer tool
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class DesignViewer
  extends TopWindow
{
	Layouter Lo = new Layouter( this);
	BarMenu Bm = new BarMenu();
	DecoText TClass = new DecoText("Class");
	DecoText TField = new DecoText("Field");
	TextField CField = new TextField();
	Choice CClass = new Choice();
	Label OffsetInfo = new Label();
	Label RatioInfo = new Label();
	DecoText TText = new DecoText("Init");
	TextField CText = new TextField();
	Checkbox CUnit = new Checkbox("DlgUnit");
	DecoGroup ClsGrp = new DecoGroup("Unit");
	DecoText TGrid = new DecoText("Grid");
	SpinButton CGrid = new SpinButton();
	DecoText TLayout = new DecoText("Layout");
	SpinButton CLayout = new SpinButton();
	DecoText TPos = new DecoText("Pos");
	SpinButton CPosX = new SpinButton();
	SpinButton CPosY = new SpinButton();
	Checkbox COrig = new Checkbox("Origin");
	Checkbox CCorn = new Checkbox("Corner");
	Checkbox CRatio = new Checkbox("Ratio");
	Checkbox COffset = new Checkbox("Offset");
	DecoGroup SelGrp = new DecoGroup("Selection");
	Button CAdd = new Button("~Add");
	Button CRem = new Button("~Remove");
	Choice CLikeDef = new Choice();
	DecoText TDef = new DecoText("Like");
	Button CNewLo = new Button("New");
	Button CClear = new Button("~Clear");
	Button CAddLike = new Button("Add~Like");
	Button CSave = new Button("Save");
	Button CPrev = new Button("Preview");
	Notebook Book = new Notebook("Layout,Order");
	DecoText TOrder = new DecoText("Components");
	List COrder = new List();
	Button CUp = new Button("Up");
	Button CDown = new Button("Down");
	Button CLeft = new Button("Left");
	Button CRight = new Button("Right");
	Button CTop = new Button("Top");
	Button CBottom = new Button("Bottom");
	Button CWidth = new Button("Width");
	Button CHeight = new Button("Height");
	DecoGroup TGOrder = new DecoGroup("TabOrder");
	DecoGroup TGAlign = new DecoGroup("Align");
	DecoGroup TGAssign = new DecoGroup("Assign");
	Checkbox CAlign = new Checkbox("Enable");
	DecoGroup TGDist = new DecoGroup("Distance");
	Button CHorz = new Button("Horz");
	Button CVert = new Button("Vert");
	SpinButton CDist = new SpinButton();
	DecoText TDist = new DecoText("pels");
	DecoText TSplit = new DecoText("Split");
	Checkbox CSLeft = new Checkbox("Left");
	Checkbox CSRight = new Checkbox("Right");
	Checkbox CSTop = new Checkbox("Top");
	Checkbox CSBottom = new Checkbox("Bottom");
	Label SizeInfo = new Label();
	DecoText TRatio = new DecoText("Ratio:");
	DecoText TOffs = new DecoText("Offset:");
	DecoText TSize = new DecoText("Size:");

public DesignViewer(){
	super( "DesignViewer");
	open();
}

public void init(){
	setBarMenu();
	setTypeChoice();

	CGrid.setRange( 1, 10, 3);
	CPosX.setRange( -10000, 10000, 0);
	CPosX.setReadOnly( false);
	CPosY.setRange( -10000, 10000, 0);
	CPosY.setReadOnly( false);

	CClass.setSelection( "");
	CLikeDef.setReadOnly( true);

	CDist.setSpinStep( 3);
	CDist.setRange( 3, 30, 3);

	XorSet group1 = new XorSet();
	COrig.setExclusive( group1);
	CCorn.setExclusive( group1);

	XorSet group2 = new XorSet();
	CRatio.setExclusive( group2);
	COffset.setExclusive( group2);

	COrig.setChecked( true, false);
	CRatio.setChecked( true, false);

}

public static void main (String[] args) {
	new DesignViewer();
}

public void open() {
	Lo.add( Bm, 0, 0, 1000, 0, true, 0, 0, 0, 130, 0);
	Lo.add( Book, 0, 0, 1000, 0, true, 0, 140, 0, 400, 0);
	Lo.add( ClsGrp, 0, 0, 1000, 0, true, 0, 420, 0, 870, 0);
	Lo.add( TGrid, 0, 0, 0, 0, true, 40, 500, 260, 640, 0);
	Lo.add( CGrid, 0, 0, 0, 0, true, 300, 500, 726, 640, 0);
	Lo.add( CUnit, 0, 0, 0, 0, true, 800, 500, 1280, 640, 0);
	Lo.add( TLayout, 0, 0, 0, 0, true, 40, 680, 260, 820, 0);
	Lo.add( CLayout, 0, 0, 0, 0, true, 300, 680, 726, 820, 0);
	Lo.add( CNewLo, 0, 0, 0, 0, true, 800, 680, 1140, 820, 0);
	Lo.add( CSave, 1000, 0, 1000, 0, true, -446, 500, -46, 660, 0);
	Lo.add( CPrev, 1000, 0, 1000, 0, true, -446, 680, -46, 840, 0);
	Lo.add( SelGrp, 0, 0, 1000, 0, true, 0, 1000, 0, 2480, 0);
	Lo.add( TClass, 0, 0, 0, 0, true, 40, 1100, 260, 1240, 0);
	Lo.add( CClass, 0, 0, 1000, 0, true, 300, 1100, -500, 1240, 0);
	Lo.add( TField, 0, 0, 0, 0, true, 40, 1280, 260, 1420, 0);
	Lo.add( CField, 0, 0, 1000, 0, true, 300, 1280, -506, 1420, 0);
	Lo.add( TText, 0, 0, 0, 0, true, 40, 1460, 260, 1600, 0);
	Lo.add( CText, 0, 0, 1000, 0, true, 300, 1460, -506, 1600, 0);
	Lo.add( TPos, 0, 0, 0, 0, true, 40, 1640, 260, 1780, 0);
	Lo.add( CPosX, 0, 0, 0, 0, true, 300, 1640, 860, 1780, 0);
	Lo.add( CPosY, 0, 0, 0, 0, true, 880, 1640, 1560, 1780, 0);
	Lo.add( TDef, 0, 0, 0, 0, true, 40, 1880, 260, 2020, 0);
	Lo.add( CLikeDef, 0, 0, 1000, 0, true, 300, 1880, -520, 2020, 0);
	Lo.add( CRatio, 1000, 0, 1000, 0, true, -466, 1100, -40, 1240, 0);
	Lo.add( COffset, 1000, 0, 1000, 0, true, -466, 1280, -40, 1420, 0);
	Lo.add( COrig, 1000, 0, 1000, 0, true, -466, 1460, -40, 1600, 0);
	Lo.add( CCorn, 1000, 0, 1000, 0, true, -466, 1640, -40, 1780, 0);
	Lo.add( TSplit, 0, 0, 0, 0, true, 40, 2060, 260, 2200, 0);
	Lo.add( CSLeft, 0, 0, 0, 0, true, 300, 2060, 680, 2200, 0);
	Lo.add( CSRight, 0, 0, 0, 0, true, 700, 2060, 1080, 2200, 0);
	Lo.add( CSTop, 0, 0, 0, 0, true, 1100, 2060, 1480, 2200, 0);
	Lo.add( CSBottom, 0, 0, 0, 0, true, 1500, 2060, 1980, 2200, 0);
	Lo.add( CClear, 25, 0, 232, 0, true, -13, 2240, -13, 2400, 0);
	Lo.add( CAdd, 261, 0, 467, 0, true, 0, 2240, 0, 2400, 0);
	Lo.add( CAddLike, 500, 0, 712, 0, true, 0, 2240, -6, 2400, 0);
	Lo.add( CRem, 745, 0, 964, 0, true, 0, 2240, -20, 2400, 0);
	Lo.add( TRatio, 0, 0, 170, 0, true, 0, 2520, 6, 2640, 0);
	Lo.add( RatioInfo, 0, 0, 361, 0, true, 0, 2640, -6, 2780, 0);
	Lo.add( TOffs, 358, 0, 535, 0, true, 0, 2520, 0, 2640, 0);
	Lo.add( OffsetInfo, 361, 0, 722, 0, true, -6, 2640, -13, 2780, 0);
	Lo.add( SizeInfo, 722, 0, 1000, 0, true, -13, 2640, -26, 2780, 0);
	Lo.add( TSize, 722, 0, 893, 0, true, -13, 2520, -6, 2640, 0);

	Lo.newLayout();
	Lo.addLikeDefault( Bm);
	Lo.addLikeDefault( Book);
	Lo.add( TOrder, 0, 0, 0, 0, true, 40, 420, 1300, 540, 0);
	Lo.add( COrder, 0, 0, 1000, 1000, true, 40, 540, -766, -33, 0);
	Lo.add( TGOrder, 1000, 0, 1000, 0, true, -726, 540, -6, 840, 0);
	Lo.add( CUp, 1000, 0, 1000, 0, true, -686, 640, -386, 800, 0);
	Lo.add( CDown, 1000, 0, 1000, 0, true, -346, 640, -46, 800, 0);
	Lo.add( TGAlign, 1000, 0, 1000, 0, true, -726, 960, -6, 1600, 0);
	Lo.add( CAlign, 1000, 0, 1000, 0, true, -686, 1040, -46, 1200, 0);
	Lo.add( CLeft, 1000, 0, 1000, 0, true, -686, 1220, -386, 1380, 0);
	Lo.add( CRight, 1000, 0, 1000, 0, true, -686, 1400, -386, 1560, 0);
	Lo.add( CTop, 1000, 0, 1000, 0, true, -346, 1220, -46, 1380, 0);
	Lo.add( CBottom, 1000, 0, 1000, 0, true, -346, 1400, -46, 1560, 0);
	Lo.add( TGDist, 1000, 0, 1000, 0, true, -726, 1680, -6, 2160, 0);
	Lo.add( CDist, 1000, 0, 1000, 0, true, -686, 1800, -306, 1940, 0);
	Lo.add( TDist, 1000, 0, 1000, 0, true, -286, 1800, -46, 1940, 0);
	Lo.add( CHorz, 1000, 0, 1000, 0, true, -686, 1960, -386, 2120, 0);
	Lo.add( CVert, 1000, 0, 1000, 0, true, -346, 1960, -46, 2120, 0);
	Lo.add( TGAssign, 1000, 0, 1000, 0, true, -726, 2260, -6, 2580, 0);
	Lo.add( CWidth, 1000, 0, 1000, 0, true, -686, 2380, -386, 2540, 0);
	Lo.add( CHeight, 1000, 0, 1000, 0, true, -346, 2380, -46, 2540, 0);

	init();
	if ( Bounds != null)
		openIn( Bounds);
	else
		openInDlgUnits( 1693, 620, 2133, 3000);
}

void setBarMenu(){
	Bm.addItem( "Frame", new Menu( "Save,Preview"));
	Bm.addItem( "Part", new Menu( "Add,Remove"));
}

void setTypeChoice(){
	String[] ta = { "BarMenu", "Button", "Checkbox", 
		"Choice", "DatePane", "DecoBox", "DecoGroup",
		"DecoImage", "DecoLine", "DecoText",
		"EditList", "GraphPane", "HScrollBar", "Label",
		"LeveledList", "List",  "Notebook",
		"SpinButton",  "TextArea", "TextField",
		"VScrollBar" };
	CClass.setContents( VectorLib.vectorFromArray( ta));
}
}
