package biss.jde;

import biss.ObserverSocket;
import biss.awt.Button;
import biss.awt.Layouter;
import biss.awt.TextArea;
import biss.awt.TopWindow;
import java.awt.Point;
import java.util.Observable;
import java.util.Observer;

/**
 * combined physical and logical view to process compiler output
 * messages (syntax errors etc.). Used by CUBrowser
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class CompileOutputDlg
  extends TopWindow
{
	String Fname;
	int Line;
	String Loc;
	TextArea TxtPane = new TextArea();
	Button NextBtn = new Button( "~Next");
	Button ExitBtn = new Button( "~Exit");
	public ObserverSocket OsNext = new ObserverSocket( this);
	Layouter GM = new Layouter( this);

public CompileOutputDlg () {
	super( "Compile Output");
	Bounds = Jde.CompOutRect;
	open();
}

public CompileOutputDlg ( Observer obs ) {
	this();

	OsClose.addObserver( obs);
	OsNext.addObserver( obs);
}

public void init () {
	NextBtn.OsAction.addObserver( this);
	ExitBtn.OsAction.addObserver( this);
}

public static void main ( String[] args ) {
	new CompileOutputDlg();
}

void nextMsg () {
	int iMax = TxtPane.getNumberOfLines();
	Point p  = TxtPane.getCursorIdx();

	for ( int i=p.y; i< iMax; i++ ) {
		TxtPane.cursorHome( false);
		char [] line = TxtPane.getLineContents();

		if ( parseLine( line) ){
			TxtPane.cursorDown ( true);
			line = TxtPane.getLineContents( i+1);
			Loc = ( line == null ) ? null : new String( line);
			OsNext.notifyObservers();
			return;
		}
		TxtPane.cursorDown( false);
	}
}

public void open () {

	GM.add( TxtPane,   0,    0, 1000, 1000,  true, 0,   0,  0, -150,  0);
	GM.add( NextBtn,   0, 1000,  500, 1000,  true, 0, -150, 0,    0,  0);
	GM.add( ExitBtn, 500, 1000, 1000, 1000,  true, 0, -150, 0,    0,  0);

	init();
	if ( Bounds != null)
		openIn( Bounds);
	else
		openIn( 380, 430, 400, 100);
}

boolean parseLine ( char[] line ) {
	for ( int j=0; j<line.length; j++ ){
		if ( line[j] == ':' ) {
			int j0 = j;
			for ( Line=0, j++; j<line.length && Character.isDigit(line[j]); j++ ) {
				Line *= 10;
				Line += (int) line[j] - (int) '0';
			}
			if ( line[j] == ':' ) {
				Fname = new String( line, 0, j0);
				return true;
			}
		}
		else if ( line[j] == ' ' || line[j] == '\t' )
			return false;
	}
	return false;
}

public void setContents ( String s ) {
	TxtPane.setContents( s);
}

public void update ( Observable slot, Object arg ) {
	if ( slot == NextBtn.OsAction ) {
		nextMsg();
	}
	else if ( slot == ExitBtn.OsAction ) {
		dispose();
	}
	super.update( slot, arg);
}
}
