package biss.awt.kernel;

import biss.PackageProperties;

/**
 * package class for package biss.awt.kernel
 * this class differs from other package classes with respect to its default init
 * values (which are usually "null"). This is due to the fact that default values
 * (which are not user specified) are either taken from environment variables (like
 * the 'Display' name), or do not have any platform independent contents (like the
 * font specs).
 *
 * Be careful not to use the Awt package class within this class because its <clinit>
 * is executed before the Toolkit ctor returns (->Awt cannot be initialized)
 * 
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class Kernel
{
	static PackageProperties Values = new PackageProperties( "biss.awt.kernel");
	public static String Courier;
	public static String Helvetica;
	public static String TimesRoman;
	public static String Dialog;
	public static String Symbol;
	public static String Display;
	public static boolean HasNativePopUps;
	public static boolean UseBackingStore;
	public static int TitleInset;
	public static int BorderInset;
	public static boolean ShrinkFrame;

static {
	Courier    = Values.getString( "Courier", null);
	Helvetica  = Values.getString( "Helvetica", null);
	TimesRoman = Values.getString( "TimesRoman", null);
	Dialog     = Values.getString( "Dialog", null);
	Symbol     = Values.getString( "Symbol", null);

	Display    = Values.getString( "Display", System.getProperty("display"));
	HasNativePopUps = Values.getBoolean( "HasNativePopUps", true);
	UseBackingStore = Values.getBoolean( "UseBackingStore", true);

	TitleInset  = Values.getInt( "TitleInset", 0);  // deferred default value setting (by Peer)
	BorderInset = Values.getInt( "BorderInset", 4);

	ShrinkFrame = Values.getBoolean( "ShrinkFrame", true);
}
}
