package biss.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Enumeration;

/**
 * vertical splitbar (moveable boundary between widgets to change the
 * layout of a Container)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class VSplitBar
  extends SplitBar
{

public VSplitBar () {
	CursorType = Frame.N_RESIZE_CURSOR;
}

public VSplitBar ( int id ) {
	Id = id;
	CursorType = Frame.N_RESIZE_CURSOR;
}

void computeSiblings () {
	Component childs[] = getParent().getComponents();
	Rectangle b = bounds();
	int i;
	Rectangle r;

	for ( i=0; i<childs.length; i++ ) {
		if ( (childs[i] != this) && (childs[i].isVisible()) ) {
			r = childs[i].bounds();
			if ( r.x < (b.x + b.width) && (r.x + r.width) > r.x ) {
				if ( (Math.abs( b.y - (r.y + r.height)) <= 1) ||
				     (Math.abs( r.y - (b.y + b.height)) <= 1) ) {
					addSibling( childs[i]);
				}
			}
		}
	}
}

public boolean mouseDrag ( Event evt, int x, int y ) {
	int y1 = YPos+Y;
	int x2 = XPos+Width - 1;

	Fr.setCursor( CursorType);

	if ( Awt.AwtToolkit == Awt.TK_WIN ) { // WIN bug workaround:
		Insets in = Parent.insets();        // inset coord. paint bug
		PGr.drawLine( XPos-in.left, y1-in.top, x2-in.left, y1-in.top );
		y1 = YPos + y;
		if ( y1 <= Max && y1 >= Min ) {
			Y = y;
			PGr.drawLine( XPos-in.left, y1-in.top, x2-in.left, y1-in.top );
		}
		return true;
	}

	PGr.drawLine( XPos, y1, x2, y1);

	y1 = YPos + y;

	if ( y1 <= Max && y1 >= Min ) {
		Y = y;
		PGr.drawLine( XPos, y1, x2, y1);
	}

	return true;
}

public void paint ( Graphics g ) {

	// infamous ScreenUpdater neutralizer
	if ( RetainPainter != null && RetainPainter.checkPaintSeries() )
		return;

	g.setColor( getBackground());
	g.fillRect( 0, 0, Width, Height);

	// draw handle (to indicate moveable boundary)
	int b = 12;
	int h = Height -1;
	g.setColor( Color.white);
	g.drawLine( 0, 0, b, 0);
	g.drawLine( 0, 0, 0, h);
	g.setColor( Color.black);
	g.drawLine( 0, h, b, h);
	g.drawLine( b, 0, b, h);
}

public Dimension preferredSize () {
	return new Dimension( Parent.size().width, 5);
}

void rearrange () {
	Component c;
	Rectangle r;
	int       yNew, hNew;
	int       y = YPos + Y;
	int       y2 = YPos + Height;
	int       d;

	for ( Enumeration e=Siblings.elements(); e.hasMoreElements(); ) {
		c = (Component) e.nextElement();
		r = c.bounds();

		if ( r.y >= y2 ) {   // below, adjust top
			d    = r.y - y2;
			yNew = y + Height + d;
			hNew = r.height + (r.y - yNew);
		}
		else {              // above, adjust bottom
			d    = YPos - (r.y + r.height);
			yNew = r.y;
			hNew = y - r.y - d;
		}
		c.reshape( r.x, yNew, r.width, hNew);

		/*** panel bug workaround ***/
		if ( c instanceof Container)
			c.layout();
	}

	move( XPos, y);
}

void updateMoveBoundaries ( Rectangle r ) {
	if ( r.y >= YPos ) {
		int y = r.y+r.height - Height;
		if ( y > Max )
			Max = y;
	}
	if ( r.y < Min )
		Min = r.y;
}
}
