package biss.awt;

import biss.Command;
import biss.CommandQueue;
import biss.ObserverSocket;
import java.awt.Component;
import java.awt.Container;
import java.awt.Decoration;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

class AppletTester
  extends SecurityManager
{

public AppletTester() {
	super();
}
}

class SingleInstCloseCmd
  implements Command
{
	TopWindow Target;
	int Count;

public SingleInstCloseCmd ( TopWindow target ) {
	Target = target;
	Count = 5;
}

public boolean execute () {
	if ( Target != TopWindow.ActiveTopWindow ) {
		if ( --Count > 0 ) {
			CommandQueue.append( this);
			return true;
		}

		Target.disposeSingleInstWnd();
	}

	return true;
}
}

/**
 * enhancement of java.awt.Frame
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class TopWindow
  extends Frame
  implements Observer, FocusInterface, KbdInterface, MouseInterface, CmdInterface, HotKeyProcessor
{
	boolean DisableDispose = false;
	static Vector Frames = new Vector();
	static int IsApplet = -1 ;
	Point Location = new Point(0,0);
/**
 * triggered by window creation ( show() )
 * parameter: this
 */
	public ObserverSocket OsOpen = new ObserverSocket( this, "Open");
/**
 * triggered by window closing ( dispose() )
 * parameter: this
 */
	public ObserverSocket OsClose = new ObserverSocket( this, "Close");
/**
 * externally triggered by the GUIHandler to notify about a
 * Menu or HotKey action
 * parameter: HotKey or MenuItem selector
 */
	public ObserverSocket OsCommand = new ObserverSocket( this, "Command");
/**
 * externally triggered by the GUIHandler to notify
 * that the window got the input focus
 * parameter: -
 */
	public ObserverSocket OsFocusGot = new ObserverSocket( this);
/**
 * externally triggered by the GUIHandler to notify
 * that the window lost the input focus
 * parameter: -
 */
	public ObserverSocket OsFocusLost = new ObserverSocket( this);
/**
 * externally triggered by the GUIHandler to notify
 * that the mouse pointer enters the window area
 * parameter: -
 */
	public ObserverSocket OsMouseEnter = new ObserverSocket( this);
/**
 * externally triggered by the GUIHandler to notify
 * that the mouse pointer exits the window area
 * parameter: -
 */
	public ObserverSocket OsMouseExit = new ObserverSocket( this);
/**
 * externally triggered by the GUIHandler to notify
 * about a MouseButton Event
 * parameter: Event
 */
	public ObserverSocket OsMouseBtn = new ObserverSocket( this);
	protected GUIHandler EventHandler = new GUIHandler( this);
	protected Rectangle Bounds;
	protected Window Overlay;
	Component DefComponent;
	PaintCmd RetainPainter = (Awt.FilterPaints > 0) ? new PaintCmd( this) : null;
	Component LastFocus;
	static TopWindow ActiveTopWindow;

public TopWindow(){
	this( "TopWindow");
}

public TopWindow( String aTitle){
	super( aTitle);
	checkApplet();
	initEventHandler();
}

public boolean addGlobalHotKey( int c, HotKeyProcessor p, Object sel){
	return EventHandler.addHotKey( c, Awt.GlobalKeyMod, p, sel);
}

public boolean addHotKey( int c, int mods, HotKeyProcessor p, Object sel){
	return EventHandler.addHotKey( c, mods, p, sel);
}

public boolean addHotKey ( int c, int mods, Object sel ) {
	return EventHandler.addHotKey( c, mods, null, sel);
}

public boolean canGetFocus () {
	return isEnabled();
}

public void centerToScreen(){
	Dimension ss = Awt.DefToolkit.getScreenSize();
	Dimension d = size();

	reshape( (ss.width - d.width) / 2, (ss.height - d.height) / 2,
	         d.width, d.height );
}

public Rectangle centeredBoundsFromDlgExtent ( int width, int height ) {
	Dimension ss = Awt.DefToolkit.getScreenSize();
	int cx = (width*Awt.DlgXUnit+50)/100;
	int cy = (height*Awt.DlgYUnit+50)/100;

	return new Rectangle( (ss.width - cx) / 2,
	                      (ss.height - cy) / 2,
	                      cx, cy );
}

public Rectangle centeredBoundsFromExtent ( int width, int height ) {
	Dimension ss = Awt.DefToolkit.getScreenSize();

	return new Rectangle( (ss.width - width) / 2,
	                      (ss.height - height) / 2,
	                      width, height );
}

public void charInput( char c, int mod){}

protected static void checkApplet(){
	if ( -1 == IsApplet) {
		try {
			SecurityManager sm = new AppletTester();
			IsApplet = 0;
		}
		catch( Exception e){
			IsApplet = 1;
		}	
	}	
}

public synchronized void disable () {
	EventHandler.IsDisabled = true;
}

public void disableComponents(){
	Component[] ca = getComponents();
	for ( int i=0; i<ca.length; i++)
		ca[i].disable();
}

public void disableDispose() {
	DisableDispose = true;
}

public void dispose () {

	DisableDispose = false;
	OsClose.notifyObservers( this);

	if ( DisableDispose )
		return;

	if ( Overlay != null )
		Overlay.dispose();

	hide();

	Frames.removeElement( this);
	super.dispose() ;

	if(( IsApplet == 0) && (Frames.size() == 0) )
		System.exit(0);
}

public boolean disposeSingleInstWnd () {
	if ( EventHandler.isSingleInstWndOwner( this) )
		return EventHandler.disposeSingleInstWnd();
	else
		return false;
}

public synchronized void enable () {
	EventHandler.IsDisabled = false;
}

public void enableComponents(){
	Component[] ca = getComponents();
	for ( int i=0; i<ca.length; i++)
		ca[i].enable();
}

public void focusNext(){
	FocusHandler.focusNext( this);
}

public void focusPrev( ){
	FocusHandler.focusPrev( this);
}

public GUIHandler getEventHandler () {
	return EventHandler;
}

public Menu getMenu(){
	Menu m = new Menu( EventHandler.MenuCont);
	m.setHandler( EventHandler);
	return m;
}

public ObserverSocket getOsCommand() {
	return OsCommand;
}

public ObserverSocket getOsFocusGot() {
	return OsFocusGot;
}

public ObserverSocket getOsFocusLost() {
	return OsFocusLost;
}

public ObserverSocket getOsMouseBtn() {
	return OsMouseBtn;
}

public ObserverSocket getOsMouseEnter() {
	return OsMouseEnter;
}

public ObserverSocket getOsMouseExit() {
	return OsMouseExit;
}

public void gotFocus () {

	ActiveTopWindow = this;

	if ( Overlay != null ){
		CommandQueue.append( new ToFrontCmd( Overlay, 10));
		Awt.DefToolkit.sync();
	}
	else {
		Component c = EventHandler.currentFocusOwner();
		if ( (c != this) && (c != null) ) {
			for ( Component p = c.getParent(); p != null; p = p.getParent() ){
				if ( p == this ) {
					LastFocus = c; // keep track of last focused child (but don't intervene)
					return;
				}
			}
		}
		else {
			restoreFocus();    // Frame itself got the focus, restore to last state
		}
	}
}

public boolean handleEvent( Event evt) {
	Frame thisInst;
	boolean br = EventHandler.handleEvent( evt);

	if ( ! (evt.target instanceof Frame) )
		return false;         // native java.awt.TextComponents need it

	thisInst = (Frame)evt.target;

	switch ( evt.id) {
	case Event.WINDOW_MOVED:
		// !!! motif workaround: sizing set zero loc !!!
		if ( Awt.AwtToolkit == Awt.TK_MOTIF ) {
			if ( (evt.x != 0) || (evt.y != 0) ){
				Location.x = evt.x;
				Location.y = evt.y;
			}
		}
		EventHandler.disposeSingleInstWnd();
		return true;
	case Event.WINDOW_DESTROY:
		dispose();
		return true;
	}

	return br;
}

public boolean hasFocus () {
	return EventHandler.HasFocus;
}

void initEventHandler( ) {
	EventHandler.Fr = (Frame)this;
	registerObserver();
}

public boolean isActive () {
	return (ActiveTopWindow == this);
}

public boolean isSingleInstWndOwner () {
	return EventHandler.isSingleInstWndOwner( this);
}

public Point location(){
	// Motif bug woraround: resizing sets location to 0,0
	if ( Awt.AwtToolkit == Awt.TK_MOTIF )
		return Location;
	else
		return super.location();
}

public void lostFocus(){
	if ( (Awt.AwtToolkit != Awt.TK_WIN) && (Awt.AwtToolkit != Awt.TK_OS2) ) {
		if ( EventHandler.isSingleInstWndOwner( this))
			CommandQueue.append( new SingleInstCloseCmd( this));
	}
}

public void mouse1Click( Event evt){}

public void mouse1DblClick( Event evt){}

public void mouse1Down( Event evt){}

public void mouse1Drag( Event evt){}

public void mouse1Up( Event evt){}

public void mouse2Click( Event evt){}

public void mouse2DblClick( Event evt){}

public void mouse2Down( Event evt){}

public void mouse2Drag( Event evt){}

public void mouse2Up( Event evt){}

public void mouseEnter( Event evt) {}

public void mouseExit( Event evt){
	// common AWT bugfix workaround: Frames don't get propper MOUSE_ENTER events,
	// the pointer is therefor not propperly reset when leaving controls
	// STRANGE: this is actually the exit event for a child (component), NOT the
	// Frame itself
	if ( Awt.AwtToolkit != Awt.TK_OTHER )
		setCursor(  Frame.DEFAULT_CURSOR);
}

public void mouseMove( Event evt){}

public void openCenteredInDlgUnits ( int width, int height ) {
	int cx = Awt.DlgXUnit;
	int cy = Awt.DlgYUnit;

	if ( ! (getLayout() instanceof Layouter) )
		pack();

	resize( (width*cx+50)/100, (height*cy+50)/100 );
	centerToScreen();
	show();
}

public void openIn ( Rectangle rect ) {
	openIn( rect.x, rect.y, rect.width, rect.height );
}

public void openIn ( int x, int y, int width, int height ) {
	if ( ! (getLayout() instanceof Layouter) )
		pack();
	reshape( x, y, width, height );
	show();
}

public void openInDlgUnits ( Rectangle rect ) {
	openInDlgUnits( rect.x, rect.y, rect.width, rect.height );
}

public void openInDlgUnits ( int x, int y, int width, int height ) {
	int cx = Awt.DlgXUnit;
	int cy = Awt.DlgYUnit;

	if ( ! (getLayout() instanceof Layouter) )
		pack();

	reshape( (x*cx+50)/100, (y*cy+50)/100, (width*cx+50)/100, (height*cy+50)/100 );
	show();
}

public void paint ( Graphics g ) {

	// infamous ScreenUpdater neutralizer
	if ( RetainPainter != null && RetainPainter.checkPaintSeries() )
		return;

	Component ca[] = getComponents();
	for ( int i=0; i<ca.length; i++){
		if ( ca[i] instanceof Decoration)
			ca[i].paint( g);
	}
}

public void processKey( Object sel){
	if ( sel.equals( "focusNext"))
		focusNext();
	else if ( sel.equals( "focusPrev"))
		focusPrev();
}

public void registerObserver( ){
	OsCommand.addObserver( this);
}

public void repaintAll() {
	Component [] childs = getComponents();

	repaint();
	for ( int i=0; i<childs.length; i++ )
		childs[i].repaint();
}

public void resetOverlay () {
	if ( Overlay != null ) {
		enableComponents();
		Overlay = null;
	}
}

public void restoreFocus () {
	if ( DefComponent != null && DefComponent.isShowing() ){
		DefComponent.requestFocus();
		return;
	}
	
	if ( LastFocus != null ) {
		if ( LastFocus.isShowing() ){
			LastFocus.requestFocus();
			return;
		}
		else
			LastFocus = null;
	}

	focusNext();
}

public void setDefaultComponent ( Component c ) {
	DefComponent = c;
}

public boolean setFocus(){
	if ( canGetFocus() ) {
		restoreFocus();
		return true;
	}
	return false;
}

public void setMenu( Menu m){
	if ( m.Handler == null){
		m.assign( EventHandler);
		m.registerKeys( HotKey.Control);
	}
}

public void setOverlay ( Window tw ) {
	if ( Overlay != null )
		Overlay.dispose();

	Overlay = tw;

	if ( tw != null)
		disableComponents();
	else
		enableComponents();
}

public void show(){
	if ( ! isShowing() ) {
		setBackground( Awt.WindowBackClr);
		super.show();
		Frames.addElement( this);
		OsOpen.notifyObservers( this);
	}

	if ( DefComponent != null ){
		// Motif JDK Frames don't get the focus, which is automatically set to
		// the first child -> we have to try harder than just to do a requestFocus()
		CommandQueue.append( new SetFocusCmd( DefComponent));
	}
}

public int tbHeight(){
	return insets().top;
}

public void unregisterObserver( ){
	OsCommand.deleteObserver( this);
}

public void update( Observable slot, Object arg){

	if ( arg instanceof Command ){
		((Command)arg).execute();
		return;
	}
}

public boolean vKeyInput( int c, int mod){
	return false;
}
}
