package biss.awt;

import biss.Biss;
import biss.FileLib;
import java.awt.FileDialog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;

/**
 * simple file editor ( to be extended). Example of a combined
 * physical and logical view class
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class FileEditor
  extends TopWindow
  implements Observer
{
	BarMenu BMenu = new BarMenu();
	TextArea FPane = new TextArea();
	String FileName;
	Layouter Lo = new Layouter( this);
	String PathName;

public FileEditor () {
	open();
}

public FileEditor ( String pathName) {
	File f = Biss.getEnvFile( pathName);
	if ( f != null)
		PathName = f.getAbsolutePath();
	open();
}

public void init () {
	setBarMenu();
	BMenu.OsCommand.addObserver( this);
	if ( PathName != null)
		openFile( PathName);
}

public static void main ( String[] args) {
	String pathName = (args.length > 0) ? args[0] : null;
	new FileEditor( pathName );
}

public void open () {
	Lo.add ( BMenu, 0, 0, 1000, 0,    true, 0, 0, 0, 150, 0);
	Lo.add ( FPane, 0, 0, 1000, 1000, true, 0, 150, 0, 0, 0);

	init();
	if ( Bounds != null)
		openIn( Bounds);
	else
		openIn( 100, 100, 400, 500);
}

void openFile () {
	FileDialog fd = new FileDialog( this, "Open file:", FileDialog.LOAD);
	fd.show();
	String d = fd.getDirectory();
	String f = fd.getFile();
	if ( (d != null) && (f != null)){
		FPane.repaint();
		openFile( d + f);
	}
}

public void openFile ( String pathName) {
	File f = new File( pathName);
	FileName = pathName;
	updateTitle();

	if ( f.exists() )
		FPane.setContents( FileLib.getFileDataAsString( f));
	else
		FPane.setContents( null);
}

void saveFileAs () {
	FileDialog fd = new FileDialog( this, "Save file:", FileDialog.SAVE);
	fd.show();
	String fn = fd.getDirectory() + fd.getFile();
	FPane.repaint();
	saveFileAs( fn);
}

boolean saveFileAs ( String pathName) {
	try {
		FileName = pathName;
		updateTitle();

		File f = new File( pathName);
		FileLib.backup( f);

		FileOutputStream fo = new FileOutputStream( pathName);
		ByteArrayOutputStream o = new ByteArrayOutputStream( 10000);
		PrintStream s = new PrintStream(o); 

		s.println( FPane.getContents() );

		o.writeTo( fo);
		fo.close();
		o.close();
		s.close();

		return true;
	}
	catch ( IOException x ) {
		System.out.println( x.toString());
	}
	return false;
}

void setBarMenu () {
	BMenu.addItem( "~Open");
	BMenu.addItem( "Save ~As");
	BMenu.addItem( "~Save.");
	BMenu.addItem( "~Close.");
}

public void update ( Observable slot, Object arg) {
	if ( slot == BMenu.OsCommand ){
		if ( "Open".equals( arg))
			openFile();
		else if ( "Close.".equals( arg))
			dispose();
		else if ( "Save.".equals( arg))
			saveFileAs( FileName);
		else if ( "Save As".equals( arg))
			saveFileAs();
	}
	else
		super.update( slot, arg);
}

void updateTitle () {
	setTitle( "Edit: " + FileName);
}
}
