package biss.calendar;

import biss.Biss;
import biss.DateLib;
import biss.FileLib;
import biss.ObserverSocket;
import biss.Scanner;
import biss.VectorLib;
import biss.VectorSorter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class DateList
{
	Vector Dates;
	String Error;
	ObserverSocket OsListChanged = new ObserverSocket( this);
	VectorSorter Sorter = new DateEntrySorter();
	String PathName = null;
	int ModifyCount = 0;
	static Hashtable FileDict = new Hashtable();

static {
	Biss.insertEnvPaths( Calendar.Values.getPaths( "EnvPaths", "~/biss/src/biss/apps/calendar"));
}

protected DateList ( String pathName ) {
	File f = Biss.getEnvFile( pathName);
	if ( f != null) {
		PathName = f.getAbsolutePath();
		Dates = loadDates( PathName);
		FileDict.put( PathName, this);
	}
	else
		System.out.println( "DateFile " + pathName + " not found");
}

void cleanUp ( Date startDate ) {
	//remove all entries before startDate

	Vector cuv = new Vector();

	for ( Enumeration e = Dates.elements(); e.hasMoreElements(); ) {
		DateEntry ed = (DateEntry)e.nextElement();
		if ( ed.EDate.before( startDate))
			cuv.addElement( ed);
	}

	if ( cuv.size() > 0) {
		VectorLib.removeAllElements( Dates, cuv);
		ModifyCount++;
		OsListChanged.notifyObservers();
	}
}

Vector getAllEntries () {
	return Dates;
}

Vector getAllEntries ( Date dMin, Date dMax) {
	Vector    list = new Vector();
	int       dy = 0;

	for ( Enumeration e=Dates.elements(); e.hasMoreElements(); ){
		DateEntry t = (DateEntry) e.nextElement();
		int c = DateLib.within( t.SDate, dMin, dMax);
		if ( c == 0 ) {
			int ndy = t.SDate.getDate();
			if ( ndy != dy){
				list.addElement( new ViewEntry( DateLib.toDMString( t.SDate)));
				dy = ndy;
			}
			list.addElement( new ViewEntry( t));
		}
		else if ( c == -1 ) break;
	}

	return list;
}

public static DateList getDateList (String pathName ) {

	if ( FileDict.containsKey( pathName))
		return (DateList)FileDict.get( pathName);

	return new DateList( pathName);  
}

Vector getDayList ( Date refDate, int startHour, int endHour, int timeSlot ) {
	Vector list = new Vector( 30);
	long mi = (long)timeSlot * DateLib.MinuteMillis;
	Date  sd = new Date( refDate.getTime() + DateLib.HourMillis*startHour );
	Date  ed = new Date( refDate.getTime() + DateLib.HourMillis*endHour );
	Date  cd;

	for ( cd = new Date( sd.getTime()); cd.before( ed); cd.setTime( cd.getTime()+mi) )
		list.addElement( new ViewEntry( cd));
	updateDayList( list);

	return list;	 
}

public static DateList getDefaultList () {
	return getDateList( Calendar.DefDateFile);
}

void insertDate ( String txt, Date sd, Date ed,
                  Date ad, String dFile, int cat ) {

	DateEntry de = new DateEntry();
	de.ItemText  = txt;
	de.Category  = cat;
	de.SDate     = sd;
	de.EDate     = ed;
	de.ADate     = ad;
	de.setDetailFile( dFile);

	VectorLib.sortIn( Dates, de, Sorter);

	ModifyCount++;
	OsListChanged.notifyObservers();  
}

public Vector loadDates( String fname){
	return loadFile( fname);
}

public Vector loadFile ( String fname ) {
	Vector list = new Vector();
	String[] field = { "StartDatum", "EndDatum", "Status", "Kategorie",
		"PaID", "Bescheibung", "AlarmDatum", "Text"};
	int pos, n = 0;
	String s;
	VectorSorter sorter = new DateEntrySorter();
	byte[] buf = FileLib.getFileData( new File(fname));
	if ( buf == null ) return null;
	Scanner scan = new Scanner( buf);
	Error = null;

	while ( (s = scan.nextNonBlankStrings( 2)) != null ) {
		try {
			if ( s.charAt(0) == '#' ) {
				scan.skipToEOL();
				continue;
			}
			n=0;
			DateEntry t = new DateEntry();

			t.SDate = DateLib.dateFromEDTF( s); n++;
			t.EDate = DateLib.dateFromEDTF( scan.nextNonBlankStrings( 2)); n++;
			t.State = Integer.parseInt( scan.nextNonBlankString()); n++;
			t.Category = Integer.parseInt( scan.nextNonBlankString()); n++;
			t.PaId = Integer.parseInt( scan.nextNonBlankString()); n++;
			t.setDetailFile( scan.nextNonBlankString()); n++;
			if ( scan.nextNonBlankString().equalsIgnoreCase( "a") ){
				t.ADate = DateLib.dateFromEDTF( scan.nextNonBlankStrings( 2)); n++;
			}

			scan.nextNonBlankToken();
			scan.skipToEOL();
			t.ItemText = scan.string();

			VectorLib.sortIn( list, t, sorter);
		}
		catch ( Exception x ) {
			Error = "parse error in line: " + scan.Line + ", field: " + field[n];
			System.out.println( "!!!!Error: " + Error);
			return null;
		}
	}

	return list;
}

public static void main (String[] args) {
	Date dt = new Date();
	DateLib.trim( dt);
	DateList dl = new DateList( args[0]);
	Vector v = dl.getDayList( dt,
	                          Integer.parseInt( args[1]),
	                          Integer.parseInt( args[2]),
	                          Integer.parseInt( args[3]) );
	for ( int i=0; i<v.size(); i++) {
		ViewEntry de = (ViewEntry) v.elementAt( i);
		System.out.println( de.EDate + " " + de.ClashCount );
	}
}

void modifyDate ( DateEntry de, String txt, Date sd, Date ed,
                  Date ad, String dFile, int cat ) {

	de.ItemText = txt;
	de.Category = cat;
	de.SDate    = sd;
	de.EDate    = ed;
	de.ADate    = ad;
	de.setDetailFile( dFile);

	VectorLib.quickSort( Dates, Sorter);

	ModifyCount++;
	OsListChanged.notifyObservers();
}

void removeDate ( DateEntry de) {
	if ( Dates.removeElement( de)){
		ModifyCount++;
		OsListChanged.notifyObservers();
	}
}

public void saveDates(){
	saveFile();
}

boolean saveFile () {

	try {
		File f = new File( PathName);
		FileLib.backup( f);

		FileOutputStream fo = new FileOutputStream( PathName);
		PrintStream s = new PrintStream(fo); 

		for ( Enumeration e = Dates.elements(); e.hasMoreElements(); ){
			DateEntry de = (DateEntry)e.nextElement();
			de.printOn( s);
		}

		s.close();
		fo.close();

		ModifyCount = 0;
		return true;
	}
	catch ( IOException x ) {
		System.out.println( x.toString());
	}
	return false;
}

void updateDayList( Vector dList) {
	Date ved = ((ViewEntry)dList.firstElement()).EDate;
	int  vIdx, vMax = dList.size();
	DateEntry de;
	ViewEntry ve;

	for ( vIdx = 0; vIdx < vMax; vIdx++)
		((ViewEntry)dList.elementAt( vIdx)).reset();
	vIdx = 0;

	for ( Enumeration e = Dates.elements(); e.hasMoreElements(); ){
		de = (DateEntry)e.nextElement();
		if ( ved.after( de.SDate) )
			continue;
		if ( vIdx == vMax)
			break;
		for ( ;vIdx < vMax ; vIdx++) {
			ve = (ViewEntry)dList.elementAt( vIdx);
			if( ve.EDate.after( de.SDate) ){
				ve = (ViewEntry)dList.elementAt( --vIdx);
				ved = ve.EDate;
				ve.addDate (de);
				for ( int vSIdx = vIdx+1; vSIdx < vMax; vSIdx++) {
					ve = (ViewEntry)dList.elementAt( vSIdx);
					if ( !de.EDate.after( ve.EDate) )
						break;
					ve.addRef ( de);
				}
				break;
			}
		}
	}

}
}
