package biss.calendar;

import biss.Biss;
import biss.DateLib;
import biss.awt.Awt;
import biss.awt.EntryDateChecker;
import biss.awt.EntryTimeChecker;
import biss.awt.FileEditor;
import biss.awt.PanePrinter;
import biss.awt.Prompter;
import biss.awt.TextField;
import java.awt.Color;
import java.util.Date;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;

public class DateBrowser
  implements Observer
{
	DateViewer View;
	final static int MOD_DAY = 1;
	final static int MOD_WEEK = 2;
	final static int MOD_MONTH = 3;
	int Mode = MOD_DAY;
	DateList Dates;
	Date CurrentDate;
	DateEntry DateSel = null;
	ViewEntry ViewSel = null;
	FileEditor DetailView = null;

static {
	Awt.insertGifPaths( Calendar.Values.getPaths( "GifPaths", "~/biss/src/biss/apps/calendar"));
}

public DateBrowser () {
	View = new DateViewer();
	Dates = DateList.getDefaultList();
	registerObserver();
	initView( null);
}

public DateBrowser ( Date dt) {
	View = new DateViewer();
	Dates = DateList.getDefaultList();
	registerObserver();
	initView( dt);
}

protected DateBrowser ( DateList list, Date dt) {
	View = new DateViewer();
	Dates = list;
	registerObserver();
	initView( dt);
}

public DateBrowser ( String pathName) {
	View = new DateViewer();
	Dates = DateList.getDateList( pathName);
	registerObserver();
	initView( null);
}

public DateBrowser ( String pathName, String dmyDate) {
	View = new DateViewer();
	Dates = DateList.getDateList( pathName);
	registerObserver();
	initView( DateLib.dateFromEDF( dmyDate));
}

void alertInfo ( String msg) {
	View.ModeInfo.setForeground( Color.red);
	View.ModeInfo.setContents( msg);
}

boolean checkModified() {
	boolean mod = false;

	if ( (DateSel == null) || (ViewSel == null) )
		return false;

	if ( View.DDet.isModified()   ){ mod = true; View.DDet.setModified( false); }
	if ( View.EIText.isModified() ){ mod = true; View.EIText.setModified( false); }
	if ( View.DADate.isModified() ){ mod = true; View.DADate.setModified( false); }
	if ( View.DATime.isModified() ){ mod = true; View.DATime.setModified( false); }
	if ( View.DDate.isModified()  ){ mod = true; View.DDate.setModified( false); }
	if ( View.DStart.isModified() ){ mod = true; View.DStart.setModified( false); }
	if ( View.DEnd.isModified()   ){ mod = true; View.DEnd.setModified( false); }

	if ( mod){
		alertInfo( StringDict.at("acceptMod") );
		return true;
	}

	return false;   
}

void closeView () {
	if ( checkModified() )
		View.disableDispose();
	else if ( Dates.ModifyCount > 0){
		View.disableDispose();
		alertInfo( StringDict.at( "storeMod") );
		Dates.ModifyCount = 0;
	}
	else
		unregisterObserver();
}

void drawItem () {
	switch ( Mode) {
	case MOD_DAY:
		DrawSupport.drawDayEntry( View.TimePane );
		break;
	case MOD_WEEK:
		DrawSupport.drawWeekEntry( View.TimePane);
		break;
	case MOD_MONTH:
		DrawSupport.drawMonthEntry( View.TimePane);
	}
}

void editDetails () {
	String pn = View.DDet.getContents();
	if ( pn.length() == 0)
		return;
	if ( DetailView != null)
		DetailView.openFile( pn);
	else {
		DetailView = new FileEditor( pn);
		DetailView.OsClose.addObserver( this);
	}
}

void info( String s) {
	View.ModeInfo.setForeground( Awt.StaticForeClr);
	View.ModeInfo.setContents( s);
	View.ModeInfo.sync();
}

void initView ( Date dt) {
	EntryTimeChecker tc = new EntryTimeChecker();
	EntryDateChecker dc = new EntryDateChecker();

	View.DStart.setChecker( tc);
	View.DEnd.setChecker(   tc);
	View.DATime.setChecker( tc);
	View.DDate.setChecker(  dc);
	View.DADate.setChecker( dc);

	int lh = Calendar.TextFontMetrics.getHeight();
	View.TimePane.setLineHeight( lh);
	View.DatePane.setLineHeight( lh);

	View.DCat.setSelection( Calendar.Categories);
	View.DayBtn.setChecked( true, false);

	if ( dt != null)
		View.MonthView.setContents( dt);
	View.MonthView.notifyChanged();

	if ( dt != null)
		selectEntry( dt, true);
}

void insertDate() {

	if ( ! validateFields() )
		return;

	String dstr = View.DDate.getContents() + " ";
	String astr = View.DADate.getContents() + " ";

	Dates.insertDate( View.EIText.getContents(),
	                  DateLib.dateFromEDTF( dstr + View.DStart.getContents() ),
	                  DateLib.dateFromEDTF( dstr + View.DEnd.getContents() ),
	                  DateLib.dateFromEDTF( astr + View.DATime.getContents() ),
	                  View.DDet.getContents(),
	                  View.DCat.getSelectionIdx() );

	info ( StringDict.at( "aptmInserted") );
}

public static void main ( String[] args) {
	switch( args.length) {
	case 1:
		new DateBrowser( DateLib.dateFromEDF( args[0]) ); //z.B.: 14.07.1996
		break;
	default:
		new DateBrowser();
	}
}

void modifyDate() {
	DateEntry de = (DateEntry)View.DatePane.getSelection();

	if ( (de == null) || ( ! validateFields()) )
		return;

	String dstr = View.DDate.getContents() + " ";
	String astr = View.DADate.getContents() + " ";

	Dates.modifyDate( de, View.EIText.getContents(),
	                  DateLib.dateFromEDTF( dstr + View.DStart.getContents() ),
	                  DateLib.dateFromEDTF( dstr + View.DEnd.getContents() ),
	                  DateLib.dateFromEDTF( astr + View.DATime.getContents() ),
	                  View.DDet.getContents(),
	                  View.DCat.getSelectionIdx() );

	info( StringDict.at( "aptmModified") );
}

void nextDateSet () {
	switch( Mode) {
	case MOD_DAY:
		CurrentDate = DateLib.nextDay( CurrentDate);
		break;
	case MOD_WEEK:
		CurrentDate = DateLib.nextWeek( CurrentDate);
		break;
	case MOD_MONTH:
		CurrentDate = DateLib.nextMonth( CurrentDate);
		break;
	}

	updateDateBar();
	updateDates( false);
}

void prevDateSet () {
	switch( Mode) {
	case MOD_DAY:
		CurrentDate = DateLib.prevDay( CurrentDate);
		break;
	case MOD_WEEK:
		CurrentDate = DateLib.prevWeek( CurrentDate);
		break;
	case MOD_MONTH:
		CurrentDate = DateLib.prevMonth( CurrentDate);
		break;
	}

	updateDateBar();
	updateDates( false);
}

void print() {
	String pn = "t";

	switch( Mode) {
	case MOD_DAY:	pn += 't';  break;
	case MOD_WEEK:  pn += 'w';  break;
	case MOD_MONTH:	pn += 'm';  break;
	}
	pn += DateLib.toEDFString( CurrentDate) ;
	pn += ".ps";

	info( StringDict.at( "printingDates") );
	new DatePrinter( View.TimePane, Mode, CurrentDate, pn);
	info( StringDict.at( "printedTo") + pn);
}

void processSelection() {
}

public void registerObserver () {

	View.OsClose.addObserver( this);

	View.DayBtn.OsAction.addObserver( this);
	View.WeekBtn.OsAction.addObserver( this);
	View.MonthBtn.OsAction.addObserver( this);
	View.PrevBtn.OsAction.addObserver( this);
	View.NextBtn.OsAction.addObserver( this);
	View.MPrevBtn.OsAction.addObserver( this);
	View.TodayBtn.OsAction.addObserver( this);
	View.MNextBtn.OsAction.addObserver( this);
	View.MonthView.OsDateChanged.addObserver( this);
	View.TimePane.OsDrawObject.addObserver( this);
	View.TimePane.OsSelection.addObserver( this);
	View.DatePane.OsDrawObject.addObserver( this);
	View.DatePane.OsSelection.addObserver( this);
	View.BEDet.OsAction.addObserver( this);
	View.DAlarm.OsAction.addObserver( this);

	View.InsertBtn.OsAction.addObserver( this);
	View.ModifyBtn.OsAction.addObserver( this);
	View.RemoveBtn.OsAction.addObserver( this);
	View.SaveBtn.OsAction.addObserver( this);
	View.ExitBtn.OsAction.addObserver( this);

	View.BMenu.OsCommand.addObserver( this);

	Dates.OsListChanged.addObserver( this);
}

void removeDate() {
	DateEntry de = (DateEntry)View.DatePane.getSelection();

	if (de != null){
		Dates.removeDate( de);
		info( StringDict.at( "aptmRemoved") );
	}
}

void save() {
	Dates.saveDates();
	info( StringDict.at( "aptmsStored") );
}

void selectEntry( Date dt, boolean fire) {
	Vector v = View.TimePane.getContents();

	for ( Enumeration e = v.elements(); e.hasMoreElements(); ) {
		ViewEntry ve = (ViewEntry)e.nextElement();
		if ( (ve.EDate != null) && (! ve.EDate.before( dt)) ){
			View.TimePane.setSelection( ve, fire);
			return;
		}
	}
}

void setCurrentDate( Date dt) {
	switch( Mode) {
	case MOD_DAY:
		CurrentDate = new Date( dt.getTime() );
		break;
	case MOD_WEEK:
		CurrentDate = DateLib.firstWeekDay( dt);
		break;
	case MOD_MONTH:
		CurrentDate = new Date( dt.getTime() );
		CurrentDate.setDate( 1);
		break;
	}

	updateDateBar();
	updateDates( false);
}

void setDate ( Date dt) {
	if ( dt != null){
		View.MonthView.setContents( dt);
		View.MonthView.notifyChanged();
		selectEntry( dt, true);
	}
}

void setSelection() {

	if ( checkModified() ){
		View.TimePane.restoreLastSelection( false);
		return;
	}

	ViewSel = (ViewEntry)View.TimePane.getSelection();

	if ( ( ViewSel == null) || ( !ViewSel.hasDates() )){
		if ( (ViewSel != null) && (Mode != MOD_DAY) )
			ViewSel = null;
		View.DatePane.setContents( null);
		showDetails();
	}
	else{
		View.DatePane.setContents( ViewSel.Dates);
		View.DatePane.setSelection( 0, true);
	}
}

void showDetails() {

	if ( checkModified() ){
		View.DatePane.restoreLastSelection( false);
		return;
	}

	DateSel = (DateEntry)View.DatePane.getSelection();

	if ( DateSel == null ){
		Date dt = (ViewSel != null) ? ViewSel.EDate : CurrentDate;
		View.DDate.setContents( DateLib.toEDFString( dt) );
		View.EIText.setContents( null);
		View.DStart.setContents( DateLib.toHMString( dt) );
		View.DEnd.setContents( DateLib.toHMString( dt) );
		View.DAlarm.setChecked( false, true);
		View.DCat.setSelection( 0);
		View.DDet.setContents( null);
	}
	else {
		View.EIText.setContents( DateSel.ItemText);
		View.DDate.setContents(  DateLib.toEDFString( DateSel.SDate));
		View.DStart.setContents( DateLib.toHMString( DateSel.SDate));
		View.DEnd.setContents(   DateLib.toHMString( DateSel.EDate));
		View.DAlarm.setChecked(  (DateSel.ADate != null), true);
		View.DCat.setSelection(  DateSel.Category);
		View.DDet.setContents(   DateSel.DetailFile);
	}

	info( "");
}

public void unregisterObserver () {
	Dates.OsListChanged.deleteObserver( this);
}

public void update ( Observable obs, Object arg) {
	if ( obs == View.TimePane.OsDrawObject)
		drawItem();
	else if ( obs == View.DatePane.OsDrawObject)
		DrawSupport.drawDateEntry( View.DatePane);
	else if ( obs == View.OsClose)
		closeView();
	else if ( (DetailView != null) && (obs == DetailView.OsClose))
		DetailView = null;
	else if ( obs == View.BEDet.OsAction)
		editDetails();
	else if ( obs == View.InsertBtn.OsAction )
		insertDate();
	else if ( obs == View.ModifyBtn.OsAction)
		modifyDate();
	else if ( obs == View.RemoveBtn.OsAction)
		removeDate();
	else if ( obs == View.SaveBtn.OsAction)
		save();
	else if ( obs == View.ExitBtn.OsAction)
		View.dispose();
	else if ( obs == View.DAlarm.OsAction)
		updateAlarm();
	else if ( obs == View.DayBtn.OsAction) {
		Mode = MOD_DAY;
		setCurrentDate( CurrentDate);
	}
	else if ( obs == View.WeekBtn.OsAction) {
		Mode = MOD_WEEK;
		setCurrentDate( CurrentDate);
	}
	else if ( obs == View.MonthBtn.OsAction) {
		Mode = MOD_MONTH;
		setCurrentDate( CurrentDate);
	}
	else if ( obs == View.PrevBtn.OsAction)
		prevDateSet();
	else if ( obs == View.NextBtn.OsAction)
		nextDateSet();
	else if ( obs == View.MPrevBtn.OsAction) {
		Date dt = View.MonthView.getCurrentDate();
		View.MonthView.setContents( DateLib.prevMonth( dt));
	}
	else if ( obs == View.TodayBtn.OsAction)
		View.MonthView.setContents( DateLib.today() );
	else if ( obs == View.MNextBtn.OsAction) {
		Date dt = View.MonthView.getCurrentDate();
		View.MonthView.setContents( DateLib.nextMonth( dt));
	}
	else if ( obs == View.MonthView.OsDateChanged)
		setCurrentDate( View.MonthView.getCurrentDate() );
	else if ( obs == View.TimePane.OsSelection)
		setSelection();
	else if ( obs == View.DatePane.OsSelection)
		showDetails();
	else if ( obs == View.BMenu.OsCommand) {
		if ( StringDict.at("print").equals( arg))			    print();
		else if ( StringDict.at("store").equals( arg))	  save();
		else if ( StringDict.at("day").equals( arg))			View.DayBtn.setChecked( true, true);
		else if ( StringDict.at("week").equals( arg))			View.WeekBtn.setChecked( true, true);
		else if ( StringDict.at("month").equals( arg))		View.MonthBtn.setChecked( true, true);
		else if ( StringDict.at("clone").equals( arg))		new DateBrowser( CurrentDate);
		else if ( StringDict.at("cleanUp").equals( arg))	Dates.cleanUp( new Date() );
		else if ( StringDict.at("insEntry").equals( arg))	insertDate();
		else if ( StringDict.at("modEntry").equals( arg))	modifyDate();
		else if ( StringDict.at("remEntry").equals( arg))	removeDate();
		else if ( StringDict.at("gotoDate").equals( arg))
			new Prompter( StringDict.at("newDate"), StringDict.at("promptDate"),
		              DateLib.toEDFString( CurrentDate), true, new EntryDateChecker(),
		              "newDate", this, View);
	}
	else if (obs instanceof Prompter){
		if ( "newDate".equals( arg))
			setDate( DateLib.dateFromEDF( ((Prompter)obs).getContents() ));
	}
	else if ( obs == Dates.OsListChanged)
		updateDates( true);
}

void updateAlarm() {
	Date dt;

	if ( ! View.DAlarm.isChecked() ) {
		View.DADate.setContents( null);
		View.DATime.setContents( null);
		return;
	}

	if ( DateSel != null)
		dt = ( DateSel.ADate != null) ? DateSel.ADate : DateSel.SDate;
	else if ( ViewSel != null)
		dt = ViewSel.EDate;
	else
		dt = CurrentDate;

	View.DADate.setContents( DateLib.toEDFString( dt));
	View.DATime.setContents( DateLib.toHMString( dt));
}

void updateDateBar () {
	String ds, ws, ms;
	switch( Mode) {
	case MOD_WEEK:
		ds = "W";
		ws = StringDict.at("weekAptms") + " " + DateLib.weekNumber( CurrentDate) +
		"." + StringDict.at("week");
		ms = DateLib.toEDFString(CurrentDate) + " " + StringDict.at("to") +         
		" " + DateLib.toEDFString(DateLib.endOfWeek( CurrentDate));
		break;
	case MOD_MONTH:
		ds = "M";
		ws = StringDict.at("monthAptms");
		ms = DateLib.toMYString( CurrentDate);
		break;
	default:
		ds = Integer.toString( CurrentDate.getDate() );
		ws = DateLib.DayNames[CurrentDate.getDay()];
		ms = DateLib.toMYString( CurrentDate);
		break;
	}

	View.DText.setContents( ds);
	View.WText.setContents( ws);
	View.MText.setContents( ms);
}

void updateDates ( boolean keepSel) {
	Vector list;
	switch( Mode) {
	case MOD_WEEK:
		list = Dates.getAllEntries( CurrentDate, DateLib.endOfWeek( CurrentDate));
		break;
	case MOD_MONTH:
		list = Dates.getAllEntries( CurrentDate, DateLib.nextMonth( CurrentDate));
		break;
	default:
		if ( keepSel){
			Dates.updateDayList( View.TimePane.getContents() );
			View.TimePane.updateContents();
			setSelection();
			return;
		}
		else
			list = Dates.getDayList( CurrentDate, Calendar.DayStartHour, Calendar.DayEndHour, Calendar.DayTimeSlot);
		break;
	}

	View.TimePane.setContents( list);
	setSelection();
}

boolean validateFields() {

	if ( ! View.DDate.validateContents() ) {
		info( StringDict.at("invDate") );
		return false;
	}
	if ( ! View.DStart.validateContents() ) {
		info( StringDict.at("invStart") );
		return false;
	}
	if ( ! View.DEnd.validateContents() ) {
		info( StringDict.at("invEnd") );
		return false;
	}
	if ( View.DAlarm.isChecked() ) {
		if ( ! View.DADate.validateContents() ) {
			info( StringDict.at("invAlarmDate") );
			return false;
		}
		if ( ! View.DATime.validateContents() ) {
			info( StringDict.at("invAlarmTime") );
			return false;
		}
	}

	if ( View.EIText.getContents().length() == 0 ){
		info( StringDict.at("noDateText") );
		return false;
	}

	return true;
}
}
