package biss;

import java.util.Observable;
import java.util.Observer;

/**
 * class to implement a Command pattern (deferred function request
 * implemented as object) without the need of an external Command
 * processor. Can be used with ObserverSockets to create arbitrary
 * objects (views, models etc.) without the existence of some kind
 * of a factory object (each time the Socket notifies its Observers,
 * the command is directly executed)
 *
 * (C) 1996 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
abstract public class AutarkCommand
  implements Observer, Command
{
	protected Object Executor;
	protected Object Arg;

abstract public boolean execute ();

public void update ( Observable observable, Object arg ) {
	Executor = observable;
	Arg = arg;

	execute();
}
}
