/*
**	SWISH++
**	file_list.c
**
**	Copyright (C) 1998  Paul J. Lucas
**
**	This program is free software; you can redistribute it and/or modify
**	it under the terms of the GNU General Public License as published by
**	the Free Software Foundation; either version 2 of the License, or
**	(at your option) any later version.
** 
**	This program is distributed in the hope that it will be useful,
**	but WITHOUT ANY WARRANTY; without even the implied warranty of
**	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**	GNU General Public License for more details.
** 
**	You should have received a copy of the GNU General Public License
**	along with this program; if not, write to the Free Software
**	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

// local
#include "file_list.h"

//*****************************************************************************
//
// SYNOPSIS
//
	file_list::size_type file_list::calc_size() const
//
// DESCRIPTION
//
//	Calculate the size of the file list (the number of files the word is
//	in) anc caches the result.
//
// RETURN VALUE
//
//	Returns the size.
//
//*****************************************************************************
{
	THIS->size_ = 0;
	for ( register char const *c = ptr; *c; ++c )
		if ( *c == ' ' )
			++THIS->size_;
	return THIS->size_ /= 2;
}

//*****************************************************************************
//
// SYNOPSIS
//
	file_list::const_iterator& file_list::const_iterator::operator++()
//
// DESCRIPTION
//
//	Advance a file_list::const_iterator.
//
// RETURN VALUE
//
//	Reference to itself as is standard practice for iterators.
//
// SEE ALSO
//
//	word_index.h
//	index.c		write_full_index() for a description of the index file
//			format.
//
//*****************************************************************************
{
	if ( !*c_ ) {
		//
		// Reached end of null-terminated list: set iterator to end.
		//
		c_ = 0;
		return *this;
	}

	v_.index = v_.rank = 0;

	while ( *c_ != ' ' ) v_.index = v_.index * 10 + *c_++ - '0';
	++c_;						// skip past ' '

	while ( *c_ != ' ' ) v_.rank  = v_.rank  * 10 + *c_++ - '0';
	++c_;						// skip past ' '

	return *this;
}
