/*----------------------------------------------------------------
 * search a file from path list
 *----------------------------------------------------------------*/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/fcntl.h>
#include "util.h"

static int file_exists(char *path, char **ext)
{
	char *lastp;
	
	if (access(path, R_OK) == 0)
		return 1;
	if (ext == NULL) return 0;
	lastp = path + strlen(path);
	for (; *ext; ext++) {
		strcpy(lastp, *ext);
		if (access(path, R_OK) == 0)
			return 1;
	}
	return 0;
}

int search_file_name(char *fresult, char *fname, char *path, char **ext)
{
	char *tok;

	/* search the current path at first */
	strcpy(fresult, fname);
	if (file_exists(fresult, ext))
		return 1;

	/* then search along path list */
	if (fname[0] != '/' && path && *path) {
		for (tok = strtok(path, ":"); tok; tok = strtok(NULL, ":")) {
			strcpy(fresult, tok);
			if (*tok && tok[strlen(tok)-1] != '/')
				strcat(fresult, "/");
			strcat(fresult, fname);
			if (file_exists(fresult, ext))
				return 1;
		}
	}
	return 0;
}

