case $CONFIG in
'')	 if test -r ../config.sh
	 then
	    . ../config.sh ;
	 else
	    spitshell=cat
	    package=IRC
	 fi
	 ;;
esac

echo "Extracting $package/ircd/version.c..."

if test -r version.c
then
   generation=`sed -n 's/^char \*generation = \"\(.*\)\";/\1/p' < version.c`
   if test ! "$generation" ; then generation=0; fi
else
   generation=0
fi

generation=`expr $generation + 1`

sum=sum
if $sum s_serv.c 1> /dev/null 2>&1; then
:
else
  sum=cksum
fi
sumsserv=`$sum s_serv.c 2> /dev/null`;
sumsuser=`$sum s_user.c 2> /dev/null`;
sumchan=`$sum channel.c 2> /dev/null`;
sumsbsd=`$sum s_bsd.c 2> /dev/null`;
sumhash=`$sum hash.c 2> /dev/null`;
sumsmisc=`$sum s_misc.c 2> /dev/null`;
sumircd=`$sum ircd.c 2> /dev/null`;

creation=`date | \
awk '{if (NF == 6) \
	 { print $1 " "	 $2 " " $3 " "	$6 " at " $4 " " $5 } \
else \
	 { print $1 " "	 $2 " " $3 " " $7 " at " $4 " " $5 " " $6 }}'`

$spitshell >version.c <<!SUB!THIS!
/*
 * IRC - Internet Relay Chat, ircd/version.c
 * Copyright (C) 1990 Chelsea Ashley Dyerman
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 1, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 * This file is generated by version.c.SH. Any changes made will go away.
 */

#ifdef __GNUC__
#pragma implementation
#endif
#include "sys.h"
#include "h.h"
#include "patchlevel.h"
#include "version.h"

char *generation = "$generation";
char *creation = "$creation";
char *version = BASE_VERSION PATCH1 PATCH2 PATCH3 PATCH4 PATCH5 PATCH6 PATCH7\
	PATCH8 PATCH9 PATCH10 PATCH11 PATCH12 PATCH13 PATCH14 PATCH15 PATCH16\
	PATCH17 PATCH18 PATCH19 PATCH20 PATCH21 PATCH22 PATCH23 PATCH24\
	PATCH25 PATCH26 PATCH27 PATCH28 PATCH29 PATCH30 PATCH31 PATCH32;

char *infotext[] = {
    "$package --",
    "Based on the original code written by Jarkko Oikarinen, version 2.6:",
    "Copyright 1988, 1989, 1990, 1991 University of Oulu, Computing Center",
    "",
    "Wiz	  Jarkko Oikarinen	   <jto@tolsun.oulu.fi>",
    "",
    "This program is free software; you can redistribute it and/or",
    "modify it under the terms of the GNU General Public License as",
    "published by the Free Software Foundation; either version 2, or",
    "(at your option) any later version.",
    "",
    "The UnderNet code is based upon version 2.8.10.",
    "The main developers of version 2.7 and 2.8 are:",
    "",
    "Avalon	  Darren Reed		   <avalon@coombs.anu.edu.au>",
    "msa	  Markku Savela		   <msa@tel4.tel.vtt.fi>",
    "Wumpus	  Greg Lindahl		   <lindahl@pbm.com>",
    "",
    "The main developer of version u2.9 and u2.10 is:",
    "",
    "Run	  Carlo Wood		   <carlo@runaway.xs4all.nl>",
    "",
    "Thanks goes to all other people who contributed to any version.",
    "A full listing of all coders can be found in doc/Authors in the",
    "source.  Contributers to version u2.10 can be found on",
    "http://www.xs4all.nl/~carlo17/ircd-dev/posters.html",
    "Thanks also to those who provided me with accounts; the kind sys",
    "admins who let me and others continue to develop IRC.",
    "",
    "[$sumsserv] [$sumchan] [$sumsbsd] [$sumsuser]",
    "[$sumhash] [$sumsmisc] [$sumircd]",
    0,
};
!SUB!THIS!
