#line 238 "pretty.nw"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <assert.h>
#include "strsave.h"
#include "getline.h"
#include "match.h"
#include "errors.h"
#include "pretty.h"

typedef struct location {       /* identify lines of source */
    char *filename;
    int lineno;
} Location;

#line 154 "pretty.nw"
void insist(char *line, char *keyword, char *msg);
#line 62 "pretty.nw"
void pretty (char *getline(void *in), void *in,
             void  putline(void *out, char *line), void *out,
             PrettyPrinter make_pp(void *cl, char *name), void *cl) 
{
    char *line = NULL;          /* buffer for input */
    PrettyPrinter pp;
    Location loc;

    while ((line = getline(in)) != NULL) {
        
#line 121 "pretty.nw"
{ if (is_keyword(line, "nl") || is_index(line, "nl")) {
      loc.lineno++;
  } else if (is_keyword(line,"file")) {
      loc.filename = strsave(line + 6);
      loc.lineno = 1;
  } else if (is_keyword(line, "line")) {
      
#line 133 "pretty.nw"
{ char *temp = line+6;
  
#line 138 "pretty.nw"
{ char *p;
  for (p = temp; *p; p++)
    if (!isdigit(*p)) 
      errormsg(Error, "non-numeric line number in `@line %s'", temp);
}
#line 135 "pretty.nw"
  loc.lineno = atoi(temp);
}
#line 128 "pretty.nw"
      loc.lineno--;
  }
}
#line 72 "pretty.nw"
        
#line 110 "pretty.nw"
if (!is_begin(line, "code")) {
    putline(out, line);
    continue;
}
#line 73 "pretty.nw"
        putline(out, line);

        for (line = getline(in); 
             line && !is_keyword(line,"defn") && !is_keyword(line,"text");
             line = getline(in)
        ) putline(out, line);
        insist(line,"defn","code chunk had no definition line");
        putline(out, line);
        pp = make_pp(cl, line+6); /* use chunk name */
        if (!pp) { 
#line 115 "pretty.nw"
while ((line = getline(in)) != NULL) {
    putline(out, line);
    if (is_end(line, "code")) break;
}
#line 82 "pretty.nw"
                                                 ; continue; }

        for (; line && !is_keyword(line, "nl") ;) { 
          line = getline(in); putline(out, line); 
        }
        insist(line,"nl","definition line not followed by newline");
        loc.lineno++;
        for (line = getline(in); 
             line != NULL && !is_end(line,"code"); 
             line = getline(in))
        {
            
#line 121 "pretty.nw"
{ if (is_keyword(line, "nl") || is_index(line, "nl")) {
      loc.lineno++;
  } else if (is_keyword(line,"file")) {
      loc.filename = strsave(line + 6);
      loc.lineno = 1;
  } else if (is_keyword(line, "line")) {
      
#line 133 "pretty.nw"
{ char *temp = line+6;
  
#line 138 "pretty.nw"
{ char *p;
  for (p = temp; *p; p++)
    if (!isdigit(*p)) 
      errormsg(Error, "non-numeric line number in `@line %s'", temp);
}
#line 135 "pretty.nw"
  loc.lineno = atoi(temp);
}
#line 128 "pretty.nw"
      loc.lineno--;
  }
}
#line 94 "pretty.nw"
            if (is_keyword(line,"nl")) {
                prettyprint(pp, NEWLINE, NULL);
            } else if (is_keyword(line,"text")) {
                prettyprint(pp, STRING, line+1+4+1);
            } else if (is_keyword(line,"use")) {
                prettyprint(pp, USE_CHUNK, line+1+3+1);
            } else {
                prettyprint(pp, WHATSIT, line);
            }
        }
        prettyprint(pp, END_OF_CHUNK, NULL);
        
#line 150 "pretty.nw"
if (line==NULL) {
    impossible("End of file occurred in mid-module");
}
#line 106 "pretty.nw"
        putline(out, line);
    }
}
#line 144 "pretty.nw"
void insist(char *line, char *keyword, char *msg) {
  
#line 150 "pretty.nw"
if (line==NULL) {
    impossible("End of file occurred in mid-module");
}
#line 146 "pretty.nw"
  if (!is_keyword(line,keyword))
    impossible(msg);
}
#line 159 "pretty.nw"
typedef struct io {
  FILE *out;
  void (*putline)(void *out, char *line);
} *IO;

static void write_pretty(void *closure, Parttype type, char *contents) {
  IO io = (IO) closure;
  switch(type) {
    case START_OF_CHUNK: break;
    case END_OF_CHUNK:   break;
    case STRING:         fprintf(io->out, "@text %s\n",       contents); break;
    case LITERAL:        fprintf(io->out, "@literal %s\n",    contents); break;
    case USE_CHUNK:      fprintf(io->out, "@use %s\n",        contents); break;
    case NEWLINE:        io->putline(io->out, "@nl");                    break;
    case DEFINITION:     fprintf(io->out, "@index defn %s\n", contents); break;
    case WHATSIT:        io->putline(io->out, contents);                 break;
    default: assert(0);
  }
}
#line 201 "pretty.nw"
static char *get_stripped(void *in) {
  FILE *fp = (FILE *)in;
  char *line = getline(fp);
  if (line) {
    int i = strlen(line) - 1;
    if (i >= 0 && line[i] == '\n') line[i] = 0;
  }
  return line;
}

static void put_stripped(void *out, char *line) {
  FILE *fp = (FILE *)out;
  fputs(line, fp);
  fputc('\n', fp);
}
#line 221 "pretty.nw"
static PrettyPrinter make_pp(void *cl, char *name) {
  if (strchr(name, ' ')) return NULL;  
  return new_prettyprinter(write_pretty, cl);
}
#line 228 "pretty.nw"
main (int argc, char *argv[]) {
  struct io io;
  io.out = stdout;
  io.putline = put_stripped;
  pretty(get_stripped, stdin, put_stripped, stdout, make_pp, &io);
  return 0;
}

