#line 18 "notangle.nw"
static char rcsid[] = "$Id: notangle.nw,v 2.9 1997/09/13 19:59:15 nr Exp nr $";
static char rcsname[] = "$Name: v2_8a $";
#define MAX_MODNAME 255
#line 23 "notangle.nw"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "strsave.h"
#include "getline.h"
#include "modules.h"
#include "modtrees.h"
#include "errors.h"
#include "match.h"
#include "notangle.h"

#line 168 "notangle.nw"
static void warn_dots(char *modname);          /* warn about names ending in ... */

#line 188 "notangle.nw"
void insist(char *line, char *keyword, char *msg);

#line 37 "notangle.nw"
void notangle (FILE* in, FILE *out, char *rootname, char *locformat) {
    Module root = NULL; /* ptr to root module */

    read_defs(in);              /* read all the definitions */

    apply_each_module(remove_final_newline);
                                /* pretty up the module texts */

    root = lookup(rootname);
    
#line 172 "notangle.nw"
if (root==NULL) {
    errormsg(Fatal, "The root module <<%s>> was not defined.", rootname);
    return;
}
#line 47 "notangle.nw"
    (void) expand(root,0,0,0,locformat,out);
    putc('\n',out);                     /* make output end with newline */
}
#line 62 "notangle.nw"
void read_defs(FILE *in) {
    char modname[MAX_MODNAME+1] = ""; /* name of module currently being read, 
                                         [[""]] if no module is being read */ 
    Module modptr = NULL;       /* ptr to current module, or NULL */
    char *line = NULL;          /* buffer for input */
    Location loc;

    while ((line = getline(in)) != NULL) {
        if (is_keyword(line, "fatal")) exit(1);
        
#line 107 "notangle.nw"
if (is_keyword(line, "nl") || is_index(line, "nl")) {
    loc.lineno++;
#line 119 "notangle.nw"
} else if (is_keyword(line,"file")) {
    
#line 132 "notangle.nw"
{ char temp[MAX_MODNAME+1];
  if (strlen(line) >= MAX_MODNAME + strlen("@file "))
    overflow("file name size");
  strcpy(temp,line+strlen("@file "));
  temp[strlen(temp)-1]='\0';
  loc.filename = strsave(temp);
}
#line 121 "notangle.nw"
    loc.lineno = 1;
} else if (is_keyword(line, "line")) {
    
#line 140 "notangle.nw"
{ char temp[MAX_MODNAME+1];
  if (strlen(line) >= MAX_MODNAME + strlen("@line "))
    overflow("file name size");
  strcpy(temp,line+strlen("@line "));
  temp[strlen(temp)-1]='\0';
  
#line 149 "notangle.nw"
{ char *p;
  for (p = temp; *p; p++)
    if (!isdigit(*p)) 
      errormsg(Error, "non-numeric line number in `@line %s'", temp);
}
#line 146 "notangle.nw"
  loc.lineno = atoi(temp);
}
#line 124 "notangle.nw"
    loc.lineno--;
#line 110 "notangle.nw"
} 
if (!is_begin(line, "code"))
    continue;
#line 72 "notangle.nw"
        
#line 103 "notangle.nw"
do { line = getline(in);
} while (line != NULL && !is_keyword(line,"defn") && !is_keyword(line,"text"));
#line 73 "notangle.nw"
        insist(line,"defn","code chunk had no definition line");
        
#line 129 "notangle.nw"
strcpy(modname,line+strlen("@defn "));
modname[strlen(modname)-1]='\0';
#line 75 "notangle.nw"
        warn_dots(modname);       /* names ending in ... aren't like web */
        modptr = insert(modname); /* find or add module in table */

        line = getline(in);
        insist(line,"nl","definition line not followed by newline");
        loc.lineno++;
        line = getline(in);
        while (line != NULL && !is_end(line,"code")) {
            if (is_keyword(line,"nl")) {
                addnewline(modptr);
                loc.lineno++;
            } else if (is_keyword(line,"text")) {
                addstring(modptr,line+1+4+1,loc);
            } else if (is_keyword(line,"use")) {
                warn_dots(line+1+3+5);
                addmodule(modptr,line+1+3+1);
            } else if (is_index(line, "nl")) {
                loc.lineno++;
            
#line 119 "notangle.nw"
} else if (is_keyword(line,"file")) {
    
#line 132 "notangle.nw"
{ char temp[MAX_MODNAME+1];
  if (strlen(line) >= MAX_MODNAME + strlen("@file "))
    overflow("file name size");
  strcpy(temp,line+strlen("@file "));
  temp[strlen(temp)-1]='\0';
  loc.filename = strsave(temp);
}
#line 121 "notangle.nw"
    loc.lineno = 1;
} else if (is_keyword(line, "line")) {
    
#line 140 "notangle.nw"
{ char temp[MAX_MODNAME+1];
  if (strlen(line) >= MAX_MODNAME + strlen("@line "))
    overflow("file name size");
  strcpy(temp,line+strlen("@line "));
  temp[strlen(temp)-1]='\0';
  
#line 149 "notangle.nw"
{ char *p;
  for (p = temp; *p; p++)
    if (!isdigit(*p)) 
      errormsg(Error, "non-numeric line number in `@line %s'", temp);
}
#line 146 "notangle.nw"
  loc.lineno = atoi(temp);
}
#line 124 "notangle.nw"
    loc.lineno--;
#line 94 "notangle.nw"
            } else if (!is_keyword(line, "index"))
                
#line 190 "notangle.nw"
errorat(loc.filename, loc.lineno, Error, "botched code chunk `%s'", line);
#line 96 "notangle.nw"
            line = getline(in);
        }
        
#line 184 "notangle.nw"
if (line==NULL) {
    impossible("End of file occurred in mid-module");
}
#line 99 "notangle.nw"
    }
}
#line 160 "notangle.nw"
static
void warn_dots(char *modname) {
  if (!strcmp(modname+strlen(modname)-3,"...")) 
    errormsg(Warning, "Module name <<%s>> isn't completed as in web", 
             modname);
}
#line 177 "notangle.nw"
void insist(char *line, char *keyword, char *msg) {
  
#line 184 "notangle.nw"
if (line==NULL) {
    impossible("End of file occurred in mid-module");
}
#line 179 "notangle.nw"
  if (!is_keyword(line,keyword))
    impossible(msg);
}
