// -*- C++ -*-
/*
 *  File:        formula.h
 *  Purpose:     Declaration of formula inset
 *  Author:      Alejandro Aguilar Sierra <asierra@servidor.unam.mx> 
 *  Created:     January 1996
 *  Description: Allows the edition of math paragraphs inside Lyx. 
 *
 *  Copyright: (c) 1996, Alejandro Aguilar Sierra
 *
 *  Version: 0.4, Lyx project.
 *
 *   You are free to use and modify this code under the terms of
 *   the GNU General Public Licence version 2 or later.
 */

#ifndef _INSET_FORMULA_H 
#define _INSET_FORMULA_H

#include "definitions.h"
#include "lyxinset.h"
//#include "math_cursor.h"

class MathParInset;

class InsetFormula: public UpdatableInset {
 public:
   InsetFormula(bool display=false);
   InsetFormula(MathParInset*);
   ~InsetFormula();  
   int Ascent(LyXFont font);
   int Descent(LyXFont font);
   int Width(LyXFont font);
   void Draw(LyXFont font, unsigned long  pm, int baseline, float &x);
   void Write(FILE *file);
   void Read(FILE *file);
   int Latex(FILE *file, char fragile);
   
   Inset* Clone(); 
   char LyxCode() { return LYX_MATH_CODE; }
   LyXFont ConvertFont(LyXFont font) {
     // We have already discussed what was here
     font.latex = LYX_NO_LATEX;
     return font;
   }
   void Edit(int x, int y); 
   char Display() { return (disp_flag) ? 1: 0; }
   void SetDisplay(bool);

   void ToggleInsetCursor(); 
   void ShowInsetCursor(); 
   void HideInsetCursor();
   void GetCursorPos(int&, int&);
   
   void InsetButtonPress(int x, int y, int button);
  void InsetButtonRelease(int x, int y, int button);
   void InsetKeyPress(XKeyEvent *ev);
//   void InsetMotionNotify(int x, int y, int state);
   void InsetUnlock();
   
   //  To allow transparent use of math editing functions
   bool LocalDispatch(int, char*);
    
  // Provisional hack to handle labels ale260796
  char* GetLabel() { return label; }
   
   void InsertSymbol(const char*);
   bool SetNumber(bool);
  
   int GetNumberOfLabels(){
     if (label) return 1; else return 0;
   }
   const char* GetLabel(int){
     return label;
   }
 protected:
   void UpdateLocal(void);
 private:
   class MathParInset* par;
//   LyxMathCursor* mathcursor;
   bool disp_flag;
   char *label;
};


// If a mathinset exist at cursor pos, just lock it.
// Otherwise create a new one, and lock it.
bool OpenMathInset();

#endif
