/*
    CTHUGHA-L								sound.h
	
    Funktions that deal with sound.
	
*/

#ifndef __SOUND_H__
#define __SOUND_H__

#include "cth_buffer.h"
#include "options.h"
#include <sys/soundcard.h>

/* 
 *  General stuff
 */
int init_sound();				/* initialze soundcard */
int init_sound_mixer();
int update_dsp();				/* update dsp-stuff */
int exit_sound();				/* clean-up */
int alloc_sound();
int free_sound();

extern int sound_stereo;			/* number of channels */
extern int sound_sample_rate;		
extern int sound_source;		
#define SNDSRC_DEFAULT	0			/* don't change mixer */
#define SNDSRC_LINE	SOUND_MASK_LINE
#define SNDSRC_MIC	SOUND_MASK_MIC
#define SNDSRC_CD	SOUND_MASK_CD
#define SNDSRC_DEBUG	-1			/* don't use soundcard */
#define SNDSRC_SOCK	-2			/* read from a socket */
extern int sound_volume_line;			/* volume from sound-source */
extern int sound_volume_mic;
extern int sound_volume_cd;
extern int sound_volume_rec;

extern char dsp_file[256];			/* sound-device */
extern char sound_data[MAX_BUFF_WIDTH][2];	/* Stereo-Data */
extern int dsp_des;				/* descriptor to dsp_file */

extern int sine[320];

/* 
 *  get-sound
 */
int get_sound();
extern int sound_minnoise;			/* quiet is below this */
extern int sound_quiet_change;			/* change after quiet-pause */
extern int sound_wait_quiet;			/* max. quiet interval */
extern int sound_peaklevel;			/* above that is loud */
extern int sound_wait;				/* time till change */
extern int sound_wait_beat;			/* peaks till change */
extern int sound_wait_random;			/* extra random time */
extern int sound_wait_min;			/* min time between change */
void sound_random();
void sound_read();
extern int sound_sync;				/* sync after reading sound */

/* 
 *  sound-processing
 */
int massage_audio();				/* audio-processing 1 */
int change_massage_style(int to);
extern int sound_massage_style;			/* massage style */
extern int massage_first;			/* massage to start with */

int FFT();					/* audio-processing 2 */
int change_FFT(int to);
extern int sound_FFT;				/* use FFT or don't */
extern int sound_use_fft;			/* allow fft-usage */

/* 
 *  sound-display (wave-functions)
 */
extern opt_data waves[];			/* possible wave-functions */
extern int nr_waves;				/* nr. of waves */
extern void (* display_wave)(void);		/* active wave-function */
int change_display_wave(int to);		/* select new wave-fkt */
int select_wave();
extern char wave_first[256];			/* Start with this wave */

int init_tables();
typedef unsigned char pal_table[256];		/* Table for display_wave */
#define MAX_TABLES	255			/* Max. nr. of tables */
extern pal_table tables[MAX_TABLES];		/* Palette-Tables */
extern int nr_tables;				/* number of tables */
extern int active_table;			/* active table */
extern int table_first;			/* table to start with */
int change_table(int to);

#endif
