/*
    CTHUGHA-L 							options.h
	
    Functions make it easy to change to new flame, wave & co. functions,
    and all the stuff needed to accept command-line-options and to
    read the ini-files.
	
*/

#ifndef __OPTIONS_H__
#define __OPTIONS_H__

#include <stdio.h>

#define MAX_NAME_LEN	24
#define MAX_DESC_LEN	30
typedef struct {
    void * data;				/* function of data */
    int use;					/* use it or not */
    char name[MAX_NAME_LEN];			/* name (short) */
    char desc[MAX_DESC_LEN];			/* description or long name */
} opt_data;

#define	CHANGE_RANDOM	-1
#define CHANGE_NEXT	-2
#define CHANGE_PREV	-3

extern int options_save;		/* save options (and buffer) at end */

opt_data * opt_change(int to, opt_data * in, int in_size, void * old);
opt_data * opt_change2(char * to, opt_data * in, int in_size, void * old);
opt_data * opt_get(void * what, opt_data * in, int in_size);
int opt_number(void * what, opt_data * in, int in_size);
int opt_number_str(const char * name, opt_data * in, int in_size);
int opt_defined(const char * name, opt_data * in, int in_size);
extern int double_load;				/* allow double loading */

int val_change(int to, int min, int max, int old);

extern char extra_lib_path[256];		/* extra path to search for
						   pcx, tab, map and ini */
int load(char * search_path[], char * extra_path, char * extension, 
	 int (* load_function)(FILE *, char *));

int get_params(int argc, char * argv[]);	/* Process programm-params */
int do_param(int c, int value, char * str);

int options_information();

int init_startup();
int exit_startup();

/*
 * Stuff about ini-files
 */
int read_ini();				/* read settings from ini-files */
int read_ini_usage();
int write_ini();			/* write selection to ini-file */
int write_ini_startup();
int open_ini_file(const char * filename, char * mode);
int close_ini_file();

/*
 * options dialog
 */
void options_dialog();

#endif

