#include "cthugha.h"
#include "information.h"

#include <stdio.h>


void title() {

    printf("--------------------------------------------------------------------------------\n");
    printf("---                         C T H U G H A - L  0.8                           ---\n");
    printf("--------------------------------------------------------------------------------\n"); 
    printf("Compiled on %s %s\n", __DATE__, __TIME__);
    printf("--------------------------------------------------------------------------------\n");
    printf(" by Harald Deischinger        k3096e5@c210.edvz.uni-linz.ac.at                  \n");
    printf("    Am Edhuegel 46\n");
    printf("    4115  Kleinzell\n");
    printf("    AUSTRIA\n");
    printf("--------------------------------------------------------------------------------\n");
    printf("Original Programm (CTHUGHA V5.1 and V5.3) by:\n");
    printf("  Coded by - Torps Productions: The Digital Aasvogel Group - 1995\n"); 
    printf("  Original Idea & Code:          Kevin Burfitt (zaph@torps.apana.org.au)\n"); 
    printf("--------------------------------------------------------------------------------\n");
    printf("Cthugha WWW-Page:            http://www.afn.org/~cthugha\n");
    printf("Cthugha newsgroup:           alt.graphics.cthugha\n");
    printf("--------------------------------------------------------------------------------\n");
#ifdef BETA
    printf("WARNING: This is a BETA-version.\n");
    printf("--------------------------------------------------------------------------------\n");
#endif
    printf("\n");
    fflush(stdout);
}


void usage() {
    printf("Cthugha command line options.\n"
	   "Sound and CD options:                                                          \n"
	   " -L, --line VOL      Use Line In as input with volume VOL      <current active>\n"
	   " -M, --mic VOL       Use Mic as input with volume VOL          <current active>\n"
	   " -C, --cd VOL        Use CD as input with volume VOL           <current active>\n"
	   " -V, --volume VOL    Set record volume to VOL                  <current active>\n"
	   " -N, --network HOST[:PORT]  Use cthugha-server running at HOST (using PORT)    \n"
	   " -x, --no-sound      Debug mode (no sound-source)                         <off>\n"
	   " -c, --track N       Use CD as input, and start playing track N             <1>\n"
	   " -v, --rate N        Set sample rate to N                               <44000>\n"
	   " -2, --stereo        Default to Stereo (2 Channels)                        <on>\n"
	   " -1, --mono          Default to Mono (1 Channel)                          <off>\n"
	   " --cd-stop           Stops CD on exit (if selected as input)              <off>\n"
	   " --cd-random         Play tracks in random order                          <off>\n"
	   " --cd-loop           Start again after all tracks are played              <off>\n"
	   " --cd-eject          Eject CD at end                                      <off>\n"
	   " --cd-autoplay       Immediately start CD                                 <off>\n"
	   " --snd-sync          Reset soundcard after reading sound                   <on>\n"
	   "Startup options:                                                               \n"
	   " -f, --flame N       Start with flame N (number or name)               <random>\n" 
	   " -w, --wave N        Start with wave N (number or name)                <random>\n" 
	   " -t, --translation N Start with translation N (number or name)         <random>\n"
	   " -p, --palette N     Start with palette N (number or name)             <random>\n" 
	   " -d, --display N     Start with display N (number or name)             <random>\n"
	   " -P, --pcx N         Start with PCX N (number or name)                 <random>\n"
	   " -a, --table N       Start with table N (number)                       <random>\n"
	   " -m, --massage N     Start with massage N (number)                     <random>\n"
	   "Change options: (times are in 1/100th of sec)                                  \n"
	   " -T, --time N        Minimum time before changing                         <500>\n"
	   " -R, --random N      Extra random time before changing                   <1000>\n" 
	   " -Q, --quiet-time N  Time before quiet message are displayes              <500>\n" 
	   " --silence-time N    Time before silence change                           <150>\n"
	   " -b, --beat-level N  Set beat peak level to N                             <240>\n" 
	   " -B, --beat-nr N     Set number of beats to N (0 to disable this)          <16>\n" 
	   " -l, --lock          Start in Locked mode                                      \n" 
	   " -q, --quiet-file FILE  Load alternate Quiet messages from FILE          <none>\n" 
	   " --little            Only change one option at a time                     <off>\n"
	   "Disable options:                                                               \n"
	   " -i, --no-ipal       Disable Inbuilt Palettes                                  \n"
	   " -e, --no-epal       Disable External Palettes                                 \n"
	   " -X, --no-use-pcx    Disable PCX image files                                   \n" 
	   " -F, --no-fft        Diable usage of FFT                                       \n"
	   " --no-trans          Disable translations                                      \n"
	   "Display and Buffer options:                                                    \n"
	   " -D, --disp-mode MODE    Set graphics mode.                                 <0>\n"
           "                     0:320x200  1:320x240  2:320x400  3:360x480  4:640x480     \n" 
	   "                     5:800x600  6:1024x768 7:1280x1024 8:1600x1200             \n"
	   "                     When using X11 you can specify a special resolution in the\n"
	   "                     from: WIDTHxHEIGHT.                                       \n"
	   " --disp-direct       Draw directly to screen (only in 320x200)             <on>\n"
	   " --mit-shm           Use MIT-SHM extension with X11 (2-3 times faster)     <on>\n"
	   " -r, --sync          Enable Video synch refresh waiting                        \n" 
	   " -S, --buff-size SIZE    Set buffer size. Perdefined sizes:                 <1>\n"
	   "                     0:160x100  1:320x200  2:320x300  3:360x480  4:640x480     \n"
	   "                     or specify a special size in the form: WIDTHxHEIGHT.      \n"
	   " --tile              Tile buffer to screen horizontally and vertically     <on>\n"
           " --tile-x            Tile buffer to screen horizontally                    <on>\n"
	   " --tile-y            Tile buffer to screen vertically                      <on>\n"
	   " --on-root, --in-window  Display on root or in window with X11         <window>\n"
	   " --private-cmap      Use a private colormap                                    \n"
	   "General options:                                                               \n"
	   " --stretch           Allow stretching of translation tables to fit         <on>\n"
	   " -E, --path LIBDIR   An extra searchpath for map, pcx and tab-files            \n"
           "                     cthugha searches in LIBDIR/map, LIBDIR/pcx and LIBDIR/tab \n"
	   " --dbl-load          Allow double loading of palettes, pcx, translations  <off>\n"
	   " --save              Save current wave, flame, .. and display at end.          \n"
	   " --prt-file FILE     File used to save screen at PrintScreen or with --save    \n"
	   " --no-esc            Disable quit on ESC                                       \n"
	   " --pause             Pause before running                                      \n"
	   " --verbose           Print a lot of information                                \n"
	   " -?, --help          This Text                                                 \n"
	   "Server options:                                                                \n"
	   " --server            Start cthugha, xcthugha in server mode               <off>\n"
	   " -W, --srv-wait      Time (in msec) cthugha-server waits after sending    <100>\n"
	   " --srv-port          Port used by the server                             <5555>\n"
	   " --clt-port          Port used by the client                             <5556>\n"
	   "\n"
	   "Long-switches can be used in a no-form to disable the feature (e.g. no-pause\n"
	   "to disable the pause) \n");
}

