#include "cthugha.h"
#include "display.h"
#include "options.h"

#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

int display_use_pcx = 1;			/* allow pcx-usage */
int nr_pcx = 0;					/* number of pcx loaded */
opt_data pcxs[MAX_PCX];				/* pcx-buffers */
int pcx_palettes[MAX_PCX];			/* index to corresp. palette */
pcx * active_pcx = NULL;
char pcx_first[256] = "";
int pcx_count = 0;				/* counter for pcx-display */

char * pcx_path[] = {
    "./",
    "./pcx/",
    "/usr/local/lib/cthugha/pcx/",
    ""
};
int read_pcx(FILE * file, char * name);

unsigned char * tempscrn = NULL; 

char display_prt_file[256] = "PrintScreen.pcx";	/* filename used by PrtScrn */

/*
 * Initialization 
 */
int init_pcx() {

    if ( !display_use_pcx) 
	return 0;

    printf("Loading PCX-files...\n");
	
    load( pcx_path, "/pcx/",  ".pcx", read_pcx);

    free(tempscrn);
    tempscrn = NULL;
	
    printfv("Number of loaded PCX-files: %d\n\n", nr_pcx);
	
    pcx_count = rand() % 5;		/* Nr. of changes for pcx to come */

    return 0;
}

/*
 * select what picture is displayed next
 */
int change_pcx(int to) {
    active_pcx = opt_change( to, pcxs, nr_pcx, active_pcx)->data;
    return 0;
}
int select_pcx() {
    int i;
    if ( nr_pcx <=0)
	return -1;

    i=display_selection(pcxs, nr_pcx, active_pcx, "Select PCX\n");
    if ( i >= 0) {
	change_pcx(i);
	show_pcx(1,1);
	display();
	sleep(1);
    }
    return i;
}

/*
 * bring the active_pcx to the screen
 */
int show_pcx(int upp_left, int correct_color) {

    if ( active_pcx == NULL)	/* no pcx loaded */
	return 0;

    if ( upp_left) {		/* copy to upper left corner of screen */
	memcpy( active_buffer, active_pcx, BUFF_SIZE);
    } else {			/* or somewhere random */
	unsigned char * src, * dst;

	int xmin = rand() % (BUFF_WIDTH - 50);
	int ymin = rand() % (BUFF_HEIGHT - 50);
	int xdest = rand() % (BUFF_WIDTH - 50);
	int ydest = rand() % (BUFF_HEIGHT - 50);
	int b = 50 + rand() % (BUFF_WIDTH - 50);
	int h = 50 + rand() % (BUFF_HEIGHT - 50);
		
	if ( (xmin + b) >= BUFF_WIDTH)	b = BUFF_WIDTH - xmin -1;
	if ( (ymin + h) >= BUFF_HEIGHT)	h = BUFF_HEIGHT - ymin -1;	
	if ( (xdest + b) >= BUFF_WIDTH)	b = BUFF_WIDTH - xdest -1;
	if ( (ydest + h) >= BUFF_HEIGHT)h = BUFF_HEIGHT - ydest -1;	
		
	if ( b % 2) b--;

#ifdef DEBUG
	printf("show_pcx:  %dx%d+%d+%d to %d:%d\n"
	       "  active_buffer: %p\n"
	       "  active_pcx   : %p (%d)\n",
	       b, h, xmin, ymin, xdest, ydest,
	       active_buffer, active_pcx, 
	       opt_number(active_pcx, pcxs, nr_pcx));
#endif
	dst = active_buffer + ydest * BUFF_WIDTH + xdest;
	src = (unsigned char *)active_pcx + ymin * BUFF_WIDTH + xmin;  
	for(;  h != 0; h--) {
	    memcpy(dst, src, b);
	    dst += BUFF_WIDTH;
	    src += BUFF_WIDTH;
	}
#ifdef DEBUG
	printf("done show_pcx\n");
#endif
    }
	
    if ( correct_color) {	/* use correct colors or keep current ones */
    	int nr = opt_number(active_pcx, pcxs, nr_pcx);
#ifdef DEBUG
    	if (nr < 0) {
    	    printfe("Could not find option number");
    	}
#endif    		
	change_palette( pcx_palettes[nr], 1);
    }
	
    return 0;
}


/*****************************************************************************/

/* load 1 pcx-file from disk

   Code for loading the pcx-file is from "showp.c" of the original Cthugha.

   Original by: Free Software by TapirSoft Gisbert W.Selke, Dec 1991   
     changed to C-Source by Volker Muehle Jul 94 
     changed for CTHUGHA by Volker Muehle Sep 94 
     changed for Cthugha-L by Deischinger Harald April/May/June 95 
     (now the source is readable :) now works for screens > 64K
     removed bug with too wide PCX-files.
     removed some of the for cthugha useless code
     rewrote, so no seek is necessary
*/
typedef unsigned char   byte; 
typedef unsigned short  word;
typedef int    boolean; 
#define MAXLINLEN 2048    		/* maximum length of screen line */
typedef struct{ 
    byte id;      			/* must be $0A  */
    byte version;      			/* 0, 2, 3, or 5  */
    byte compr;        			/* 1 if RLE-coded  */
    byte   bitsperpixel; 
    word   xmin ;        
    word   ymin ;        
    word   xmax ;        
    word   ymax ;        
    word   horidpi;      		/* horizontal res., dots per inch */
    word   vertdpi;      		/* vertical   res., dots per inch */
    byte   colormap[16][3];
    byte   reserved ;    
    byte   ncolplanes;   		/* number of colour planes; max 4 */ 
    word   bytesperline; 		/* must be even */ 
    word   greyscale;    		/* 1 if color or b/w; 
					   2 if greyscale */ 
    byte   filler[58];   
} headrec; 

static headrec header; 
static int  iread, thisbyte; 
static boolean zdecomp, zcompr; 
static byte repeatct; 

#define maxx (BUFF_WIDTH-1)
#define maxy (BUFF_HEIGHT-1)
static int  maxcolour = 255; 
static byte xscale = 255, yscale = 255;
static boolean zxcentre=0, zycentre=0, zprop=0, zmono=0; 
FILE * picf;

/* get next chunk from input file  */ 
void getnextchunk(void) { 
    if(feof(picf)) 
	iread = 0; 
    else { 
	errno=0; 
    	iread = fread(tempscrn,1,BUFF_SIZE,picf); 
    	if(errno)
	    iread = 0; 
    } 

    thisbyte = 0; 
}                                        

/* reads next byte from input file, handling compression */ 
byte getnextbyte(void){ 
    byte res;							
    if (!zdecomp) { 
	if(thisbyte >= iread)
	    getnextchunk(); 
	if(thisbyte < iread) { 
	    thisbyte++; 
	    if( zcompr && tempscrn[thisbyte-1] >= 192) { 
		repeatct = tempscrn[thisbyte-1] & 0x3F; 
		zdecomp = (repeatct>0) ? 1 : 0;
		if (thisbyte >= iread)
		    getnextchunk(); 
		thisbyte++; 
	    } 
	} 
    } 
    if( zdecomp){ 
	res= tempscrn[thisbyte-1]; 
	repeatct--; 
	zdecomp = (repeatct>0) ? 1 : 0;
    } else { 
	if(iread > 0){ 
	    res= tempscrn[thisbyte-1]; 
	}else res= 0; 
    } 
    return res; 
}                     						


int read_pcx(FILE * file, char * name) {

    int     x, y, x2, y2, j ; 
    byte    b, b2, i, horisub, vertsub, vertct ; 
    byte    bitsperplane ; 

    unsigned char * buff;			/* target-buffer */
    unsigned char * pal;			/* palette for this pcx */

    if ( opt_defined(name, pcxs, nr_pcx) && !double_load) {
	printfv("   ... already loaded\n");
	return 1;
    }

    /* allocate temprary buffer */
    if( tempscrn == NULL) 
	if( (tempscrn = malloc(BUFF_SIZE)) == NULL) {
	    printfe("Can't allocate memory for pictures.\n");
	    return 1;
	}
    
    /* make space for PCX */
    if ( (nr_pcx >= MAX_PCX) || (nr_palettes >= MAX_PALETTES) ) {
    	printfe("No more room for pcx-file.\n");
    	return 1;
    }
    if ( (pcxs[nr_pcx].data = malloc(BUFF_SIZE)) == NULL) {
	printfe("Can't allocate memory for picture.\n");
	return 1;
    }
    buff = (unsigned char *)(pcxs[nr_pcx].data);
    strncpy( pcxs[nr_pcx].name, name, MAX_NAME_LEN);
    pcxs[nr_pcx].desc[0] = '\0';
    pcxs[nr_pcx].use = 1;

    picf = file;
		
    /* read header */
    iread=fread(&header,1,sizeof(header),picf); 
    if(iread != sizeof(header)) {  
	printfe("Can't read head of file: %s\n", name); 
	return 1; 
    }

#ifdef DEBUG	
    printfv("\n"
	    "PCX-Header:\n"
	    "  id     : %d\n"
	    "  version: %d\n"
	    "  compr  : %d\n"
	    "  ncolpl.: %d\n"
	    "  greysc.: %d\n"
	    "  X      : %d - %d\n"
	    "  Y      : %d - %d\n",
	    header.id, header.version, header.compr, 
	    header.ncolplanes, header.greyscale,
	    header.xmin, header.xmax,
	    header.ymin, header.ymax);
#endif        

    /* Check header */
    if( header.id != 0x0A) { 
	printfe("Illegal PCX header (wrong ID) in file: %s\n", name);
	free( pcxs[nr_pcx].data );
	return 1;
    } 
    if( header.version!=0 && header.version!=2 && 
	header.version!=3 && header.version!=5 ) { 
	printfe("Illegal PCX header (wrong version) in file: %s\n", name);
	free( pcxs[nr_pcx].data );
	return 1;
    } 
    if( header.compr!=0 && header.compr!=1 ) {  
	printfe("Illegal PCX header (wrong compression) in file: %s\n", name);
	free( pcxs[nr_pcx].data );
	return 1;
    }
    if( header.ncolplanes>4 ) { 
	printfe("Illegal PCX header (wrong ncolplanes) in file: %s\n", name);
	free( pcxs[nr_pcx].data );
	return 1;
    }
    if( header.greyscale!=1 && header.greyscale!=2) 
	header.greyscale = 1; 
	
    if( header.ncolplanes== 0)
	header.ncolplanes = 1; 
	
    bitsperplane = header.bitsperpixel*header.ncolplanes; 
    if ( bitsperplane != 8 ) { 
	printfe("Wrong number of bits per plane (%d).\n", bitsperplane);
	free( pcxs[nr_pcx].data );
	return 1;
    }

    x = header.xmax - header.xmin + 1; 
    y = header.ymax - header.ymin + 1; 

    horisub = xscale; 
    if(xscale==255) 
	horisub = 1; 
    if(xscale== 0) { 
	horisub = 1; 
	while((header.xmax-header.xmin+horisub-1)/horisub > maxx+5) horisub++; 
    } 
    vertsub = yscale; 
    if(yscale == 255)
	vertsub = 1; 
    if( yscale == 0) { 
	vertsub = 1; 
	while( (header.ymax-header.ymin+vertsub-1)/vertsub> maxy+5) vertsub++; 
    } 
    if(zprop) { 
	if( horisub<vertsub &&xscale==0) horisub = vertsub; 
	if( vertsub<horisub &&yscale==0) vertsub = horisub; 
    } 
    if(zxcentre) { 
	x = (header.xmax-header.xmin+horisub-1)/horisub; 
	if(x < maxx) { 
	    header.xmax = header.xmax - header.xmin + (maxx - x)/2; 
	    header.xmin = (maxx - x)/2; 
	} 
    } 
    if(zycentre) { 
	y = (header.ymax-header.ymin+vertsub-1)/vertsub; 
	if(y < maxy) { 
	    header.ymax = header.ymax - header.ymin + (maxy - y)/2; 
	    header.ymin = (maxy - y)/2; 
	} 
    } 
    zcompr = (header.compr == 1) ? 1 : 0;
	
    thisbyte = iread+1; 
    zdecomp = 0; 
    y  = header.ymin; 
    y2 = header.ymin; 
    vertct = 0; 

    while( y<=header.ymax && y2<=maxy) { 
	if(vertct==0){ 
	    x = header.xmin; 
	    x2=0; 
	    j = 1; 
	    while(j<=header.bytesperline) { 
		b2 = 0;

		for(i=1 ; i<=horisub; i++) { 
		    if (j <= header.bytesperline) { 
			b = getnextbyte(); 
			if (b > b2)	b2 = b; 
			j++; 
		    } 
		} 
		if( x <= maxx) {
		    if( zmono) { 
			    buff[BUFF_WIDTH*y2+x2]=maxcolour; 
		    } else 
			buff[BUFF_WIDTH*y2+x2]=b2 %(maxcolour+1); 
		} 
		x++; 
		x2++; 
	    } 
	} else { 
	    for(j=1; j<=header.bytesperline; j++)
		b = getnextbyte(); 
	} 
	y++; 
	if(vertct== 0) y2++; 
	vertct = ++vertct % vertsub; 
    } 
    /* read rest of file */
    for(;y<=header.ymax;y++) 
	for(j=0; j < header.bytesperline; j++)
	    getnextbyte();

    if(y2<= maxy) {			/* fill buffer */
	int ix; 
	for(ix=0;ix<=maxx;ix++)
	    buff[BUFF_WIDTH*y2+ix]=0; 
    } 

    /* read palette */
    if( !zmono && (header.version==2||header.version==5) ) { 
	if ( (palettes[nr_palettes].data = malloc(sizeof(palette))) == NULL) {
	    printfe("Can not allocate memory for pcx-palette.");
	} else {
	    pal = (unsigned char *)(palettes[nr_palettes].data);

	    zcompr = 0;		/* palette is not compressed */
	    if( getnextbyte() != 12)	/* should be 12 */
		printfv("\n    Palette marker not found. Trying anyway.");

	    for(y=0;y<768;y++) 
		pal[y]= getnextbyte(); 
	    
	    printfv("\n    Loaded palette %d from PCX", nr_palettes);
	    strncpy( palettes[nr_palettes].name, name, MAX_NAME_LEN);
	    palettes[nr_palettes].desc[0] = '\0';
	    palettes[nr_palettes].use = 1;

	    pcx_palettes[nr_pcx] = nr_palettes;
	    nr_palettes ++;
	}
    }
	 
    /* everything worked fine */
    nr_pcx ++;
    return 0;
}


int save_pcx(unsigned char * buffer, int width, int height) {
    FILE * file;
    headrec header;
    palette tmp_pal;
    int i,j;
    static int counter = 0;
    char file_name[512];

    /* append a number of saving is done more than once */
    if ( counter == 0) {
	strcpy(file_name, display_prt_file);
    } else {
	sprintf(file_name, "%s.%d", display_prt_file, counter);
    }
    counter ++;
	
    /* open file */
    if( (file = fopen(file_name, "w")) == NULL) {
	printfee("Can't open file for writing.");
	return 1;
    }

    /* fill header with information */
    header.id = 0x0A;
    header.version = 5;
    header.compr = 1;
    header.bitsperpixel = 8;
    header.xmin = 0;
    header.ymin = 0;
    header.xmax = width -1;
    header.ymax = height-1;
    header.horidpi = 0;
    header.vertdpi = 0;
    header.reserved = 0;
    header.ncolplanes = 1;
    header.bytesperline = width;
    header.greyscale = 1;
    for(i=0; i < 16; i++)
	header.colormap[i][0] = 
	header.colormap[i][1] = 
	header.colormap[i][2] = 0;
    for(i=0; i < 58; i++)
	header.filler[i] = 0;

    /* write header */
    if( fwrite(&header, sizeof(header), 1, file) != 1) {
	printfee("Can not write header.");
	fclose(file);
	return 1;
    }

    /* write buffer currently on screen */
    for(i=0; i < height; i++) {
	for(j=0; j < width; j++) {
	    if( *buffer == *(buffer + 1)) {		/* repeating */
		unsigned char cnt = 0;
		while( (cnt < 62) && (*buffer == *(buffer + 1)) && 
		      (j < (width-1)))
		    j++, cnt ++, buffer ++;
		cnt += 192 + 1;
		if( fputc(cnt, file) == EOF) {		/* write count */
		    printfee("Can not write picture.");
		    fclose(file);
		    return 1;
		}
	    } else {					/* maybe repeat once */
		if( *buffer >= 192) {
		    if( fputc(193, file) == EOF) {	/* repeat once */
			printfee("Can not write picture.");
			fclose(file);
			return 1;
		    }
		}
	    }
	    if( fputc(*buffer, file) == EOF) {	/* write data */
		printfee("Can not write picture.");
		fclose(file);
		return 1;
	    }
	    buffer ++;
	}
    }
	
    /* create palette for save */
    for(i=0; i < 256; i++)
	for(j=0; j < 3; j++)
	    tmp_pal[i][j] = (*active_palette)[i][j] << 2; 


    /* write palette marker */
    if( fputc(12, file) == EOF) {
	printfee("Can not write palette.");
	fclose(file);
	return 1;
    }
    /* write palette */
    if( fwrite(tmp_pal, 3*256, 1, file) != 1) {
	printfee("Can not write palette.");
	fclose(file);
	return 1;
    }

    /* close file */
    fclose(file);

    return 0;
}
    

/*
 * save the current buffer to a file 
 */
int save_buffer() {
    return save_pcx(passive_buffer, BUFF_WIDTH, BUFF_HEIGHT-4);
}

/*
 * save the current display to a file
 */
int tile_buffer(int tile_x,int tile_y, int size_x,int size_y);
int get_tile_size(int * tile_x, int * tile_y, int * size_x, int * size_y);

#define SB_HEIGHT	( min(BUFF_HEIGHT, screen_height) )

#define SCREEN_OFFSET_X	((screen_width - BUFF_WIDTH * tile_x*size_x) / 2)
#define SCREEN_OFFSET_Y	((screen_height- SB_HEIGHT  * tile_y*size_y) / 2)
#define SCREEN_OFFSET	(screen_width * SCREEN_OFFSET_Y + SCREEN_OFFSET_X)


int save_display() {
    unsigned char * tmp_buff;
    int tile_x,tile_y,size_x,size_y;

    if( (tmp_buff = malloc( screen_width * screen_height)) == NULL) {
	printfe("Can not allocate memory for temporary image.\n");
	return 1;
    }
    memset(tmp_buff, 0, screen_width*screen_height);

    do {
	get_tile_size(&tile_x, &tile_y, &size_x, &size_y);
	display_mem = tmp_buff + SCREEN_OFFSET;
    } while( update_screen() );			/* draw the buffer */

    tile_buffer(tile_x,tile_y, size_x,size_y);	

    return save_pcx(tmp_buff, screen_width, screen_height);
}




