/* 
   mksmoke.c
	
   Changes by Harald Deischinger to compile with cthugha-L under Linux.
   Changes:
       int -> short
       Random
       short -> tint
       unsigned tint -> utint

       const buff

       removed unused variables dx, dy
*/

/*
//
// Create a smoke translation table for Cthugha.
//
// Compiled using Borland C 3.1.
//
// By Ofer Faigon, Sep 1994.
//     ofer@brm.co.il
//     (or oferf@itexjct.jct.ac.il)
//
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>

#define CONST_BUFF
#include "../src/cthugha.h"
#include "../src/cth_buffer.h"

tint Random(tint range) {
    if ( range > 0)
	return rand() % range;
    else
	return 0;
}

#define Y_CENTER  (BUFF_HEIGHT / 2)
#define X_CENTER  (BUFF_WIDTH / 2)

#define DEFAULT_SPEED 100
#define DEFAULT_RAND   70

tint main (tint argc, char **argv) {
    char   *fileName;
    FILE   *fp;
    tint    x, y, map_x, map_y;
    tint    speed, Randomness;
    utint map;

    if (argc < 2  ||  argc > 4) {
	char  *p = strrchr(argv[0], '\\');
	p = p ? p+1 : argv[0];
	printf ("Smoke table generator for CTHUGHA.\n");
	printf ("The generated table creates an effect of smoke rising from the burning\n");
	printf ("wave forms.\n");
	printf ("\n");
	printf ("Usage:  %s outfile.tab [speed [Randomness]]\n", p);
	printf ("  Speed should be 30..300 (default %d)\n", DEFAULT_SPEED);
	printf ("  Randomness should be 0..100 (default %d)\n", DEFAULT_RAND);
	return 1;
    }

    fileName = argv[1];
    speed = (argc > 2) ? atoi(argv[2]) : DEFAULT_SPEED;
    Randomness = (argc > 3) ? atoi(argv[3]) : DEFAULT_RAND;

    speed = min(max(speed,30),300);
    Randomness = min(max(Randomness,0),100);

    if ((fp = fopen(fileName, "wb")) == NULL) {
	printf ("*** Failed to create output file %s\n", fileName);
	return 2;
    }

    printf ("Generating table %s with speed=%d and Randomness=%d\n",
	    fileName, speed, Randomness);

    for (y = 0; y < BUFF_HEIGHT; y++) {
	printf ("Generating line %d of %d...\r", y + 1, BUFF_HEIGHT);

	for (x = 0; x < BUFF_WIDTH; x++) {
	    map_x = x - (5 + Random(12 * Randomness / 100)) * speed / 100;
	    map_y = y - (5 + Random(12 * Randomness / 100)) * speed / 100;

	    if (map_y >= BUFF_HEIGHT || map_y < 0  ||
		map_x >= BUFF_WIDTH  || map_x < 0 ) {
		map_x = 0;
		map_y = 0;
	    }

	    map = map_y * BUFF_WIDTH + map_x;

	    if (fwrite (&map, sizeof(tint), 1, fp) != 1) {
		printf ("\n*** Error while writing to output file (disk full?)\n");
		fclose (fp);
		return 3;
	    }
	}
    }

    printf ("Done.%26s\n", "");

    fclose (fp);

    return 0;
}
