/*
** Copyright (C) 1995, 1996  Joseph Croft <jcroft@unicomp.net>  
** xIrcDispatchEntry.h Message Dispatch Entry class used for keeping commands
** and thier responses going to the right widgets.
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 1, or (at your option)
** any later version.
** 
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
** GNU General Public License for more details.
** 
** You should have received a copy of the GNU General Public License
** along with this program; if not, write to the Free Software
** Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ircreply.h"
#include "xIrcMsgDispatchEntry.h"

extern xIrcCommands ircResponses;

static int dbg = 0;

static int *pResponseList[] = 
{
   // OPER
   { RPL_YOUREOPER, 0 },
   // MODE
   { RPL_CHANNELMODEIS, RPL_ENDOFBANLIST, 0 },
   // TOPIC
   { RPL_TOPIC, RPL_NOTOPIC, 0 },
   // NAMES
   { RPL_NAMEREPLY, RPL_ENDOFNAMES, 0 },
   // LIST
   { RPL_LIST, RPL_LISTSTART, RPL_LISTEND, 0 },
   // INVITE
   { RPL_INVITE, RPL_AWAY, 0 },
   // VERSION
   { RPL_VERSION, 0 },
   // STATS
   { RPL_STATSCLINE, RPL_STATSILINE, RPL_STATSQLINE, RPL_STATSLINKINFO,
     RPL_STATSHLINE, RPL_STATSNLINE, RPL_STATSKLINE, RPL_STATSLLINE,
     RPL_UPTIME, RPL_STATSOLINE, RPL_ENDOFSTATS, 0 },
   // LINKS
   { RPL_LINKS, RPL_ENDOFLINKS, 0 },
   // TIME
   { RPL_TIME, 0 },
   // TRACE
   { RPL_TRACECONNECTING, RPL_TRACEUNKNOWN, RPL_TRACEUSER, RPL_TRACESERVICE,
     RPL_TRACECLASS, RPL_TRACEHANDSHAKE, RPL_TRACEOPERATOR, RPL_TRACESERVER,
     RPL_TRACENEWTYPE, 0 },
   // ADMIN
   { RPL_ADMINME, RPL_ADMINLOC2, RPL_ADMINLOC1, RPL_ADMINEMAIL, 0 },
   // INFO
   { RPL_INFO, RPL_ENDOFINFO, 0 },
   // PRIVMSG
   { RPL_AWAY, 0 },
   // NOTICE
   { RPL_AWAY, 0 },
   // WHO
   { RPL_WHOREPLY, RPL_ENDOFWHO, 0 },
   // WHOIS
   { RPL_WHOISUSER, RPL_WHOISCHANNELS, RPL_AWAY, RPL_WHOISIDLE, RPL_ENOFWHOIS,
     RPL_WHOISSERVER, RPL_WHOISOPERATOR, 0 },
   // WHOWAS
   { RPL_WHOWASUSER, RPL_ENDOFWHOWAS, RPL_WHOISSERVER, 0 },
   // AWAY
   { RPL_UNAWAY, RPL_NOAWAY, 0 },
   // REHASH
   { RPL_REHASHING, 0 },
   // SUMMONING
   { RPL_SUMMONING, 0 },
   // USERS
   { RPL_USERSTART, RPL_NOUSERS, RPL_USERS, 0 },
   // ISON
   { RPL_ISON, 0 },
};

enum 
{
   OPER=0, MODE, TOPIC, NAMES, LIST, INVITE, VERSION, STATS, LINKS,
   TIME, TRACE, ADMIN, INFO, PRIVMSG, NOTICE, WHO, WHOIS, WHOWAS, AWAY, REHASH,
   SUMMONING, USERS, ISON
} IrcCommandsRef;


typedef struct
{
   IrcCommandRef  cmdRef;
   char           *cmdName;
   int            *replies;
} IrcCommands

const static IrcComands cmdList[] =
{
   { OPER, "OPER", pResponseList[OPER] },
   { MODE, "MODE", pResponseList[MODE] },
   { TOPIC, "TOPIC", pResponseList[TOPIC] },
   { NAMES, "NAMES", pResponseList[NAMES] },
   { LIST, "LIST", pResponseList[LIST] },
   { INVITE, "INVITE", pResponseList[INVITE] },
   { VERSION, "VERSION", pResponseList[VERSION] },
   { STATS, "STATS", pResponseList[STATS] },
   { LINKS, "LINKS", pResponseList[LINKS] },
   { TIME, "TIME", pResponseList[TIME] },
   { TRACE, "TRACE", pResponseList[TRACE] },
   { ADMIN, "ADMIN", pResponseList[ADMIN] },
   { INFO, "INFO", pResponseList[INFO] },
   { PRIVMSG, "PRIVMSG", pResponseList[PRIVMSG] },
   { NOTICE, "NOTICE", pResponseList[NOTICE] },
   { WHO, "WHO", pResponseList[WHO] },
   { WHOIS, "WHOIS", pResponseList[WHOIS] },
   { WHOWAS, "WHOWAS", pResponseList[WHOWAS] },
   { AWAY, "AWAY", pResponseList[AWAY] },
   { REHASH, "REHASH", pResponseList[REHASH] },
   { SUMMONING, "SUMMONING", pResponseList[SUMMONING] },
   { USERS, "USERS", pResponseList[USERS] },
   { ISON, "ISON", pResponseList[ISON] },
   { 0, NULL, NULL }
};

typedef struct
{
   int            rspCode;
   bool           terminating;
   bool           display;
   char           *parseStr;
} IrcResponseParse;

const static IrcResponseParse responseParseStrings[] =
{
   { RPL_ISON, FALSE, TRUE, "*: %n+" },
   { RPL_AWAY, FALSE, TRUE, "%n *" },
   { RPL_WHOISUSER, FALSE, TRUE, "%n *" },
   { RPL_WHOISSERVER, FALSE, TRUE, "%n *" },
   { RPL_WHOISOPERATOR, FALSE, TRUE, "%n *" },
   { RPL_WHOISIDLE, FALSE, TRUE, "%n *" },
   { RPL_WHOISCHANNELS, FALSE, TRUE, "%n *" },
   { RPL_WHOWASUSER, FALSE, TRUE, "%n *" },
   { RPL_WHOWASSERVER, FALSE, TRUE, "%n *" },
   { RPL_ENDOFWHOIS, TRUE, FALSE, "*" },
   { RPL_ENDOFWHOWAS, TRUE, FALSE, "*" },
   { RPL_LISTSTART, FALSE, TRUE, "%c *" },
   { RPL_LIST, FALSE, TRUE, "%c *" },
   { RPL_LISTEND, TRUE, FALSE, "*" },
   { RPL_NOTOPIC, TRUE, TRUE, "%c *" },
   { RPL_TOPIC, TRUE, TRUE, "%c *" },
   { RPL_INVITING, TRUE, TRUE, "%c %n" },
   { RPL_SUMMONING, TRUE, TRUE, "%u *" },
   { RPL_VERSION, FALSE, TRUE, "*" },
   { RPL_WHO, FALSE, TRUE, "%c %u %h %s %n *" },
   { RPL_ENDOFWHO, TRUE, FALSE, "*" },
   { RPL_NAMEREPLY, FALSE, TRUE, "%c *" },
   { RPL_ENDOFNAMES, TRUE, FALSE, "%c *" },
   { RPL_LINKS, FALSE, TRUE, "*" },
   { RPL_ENDOFLINKS, TRUE, FALSE, "*" },
   { RPL_BANLIST, FALES, TRUE, "%c *" },
   { RPL_ENDOFBANLIST, TRUE, FALSE, "%c *" },
   { RPL_INFO, FALSE, TRUE, "*" },
   { RPL_ENDOFINFO, TRUE, FALSE, "*" },
   { RPL_MOTDSTART, FALSE, TRUE, "*" },
   { RPL_MOTD, FALSE, TRUE, "*" },
   { RPL_ENDOFMOTD, TRUE, FALSE, "*" },
   { RPL_YOUREOPER, TRUE, TRUE, "*" },
   { RPL_REHASHING, TRUE, TRUE, "*" },
   { RPL_TIME, TRUE, TRUE, "*" },
   { RPL_USERSSTART, FALSE, TRUE, "*"
   { RPL_USERS, FALSE, TRUE, "*" },
   { RPL_ENDOFUSERS, TRUE, FALSE, "*" },
   { RPL_NOUSERS, FALSE, TRUE, "*" },
   { RPL_TRACELINK, FALSE, TRUE, "*" },
   { RPL_TRACECONNECTING, FALSE, TRUE, "*" },
   { RPL_TRACEHANDSHAKE, FALSE, TRUE, "*" },
   { RPL_TRACEUNKNOWN, FALSE, TRUE, "*" },
   { RPL_TRACEOPERATOR, FALSE, TRUE, "*" },
   { RPL_TRACEUSER, FALSE, TRUE, "*" },
   { RPL_TRACESERVER, FALSE, TRUE, "*" },
   { RPL_TRACENEWTYPE, FALSE, TRUE, "*" },
   { RPL_TRACETRACELOG, FALSE, TRUE, "*" },
   { RPL_STATSLINKINFO, FALSE, TRUE, "*" },
   { RPL_STATSSTATSCOMMANDS, FALSE, TRUE, "*" },
   { RPL_STATSCLINE, FALSE, TRUE, "*" },
   { RPL_STATSILINE, FALSE, TRUE, "*" },
   { RPL_STATSKILE, FALSE, TRUE, "*" },
   { RPL_STATSYLINE, FALSE, TRUE, "*" },
   { RPL_ENDOFSTATS, TRUE, FALSE, "*" },
   { RPL_STATSLLINE, FALSE, TRUE, "*" },
   { RPL_STATSUPTIME, FALSE, TRUE, "*" },
   { RPL_STATSOLINE, FALSE, TRUE, "*" },
   { RPL_STATSHLINE, FALSE, TRUE, "*" },
   { RPL_STATSUMODEIS, FALSE, TRUE, "*" },
   { RPL_LUSERCLIENT, FALSE, TRUE, "*" },
   { RPL_LUSEROP, FALSE, TRUE, "*" },
   { RPL_LUSERUNKNOWN, FALSE, TRUE, "*" },
   { RPL_LUSERCHANNELS, FALSE, TRUE, "*" },
   { RPL_LUSERME, FALSE, TRUE, "*" },
   { RPL_ADMINME, FALSE, TRUE, "*" },
   { RPL_ADMINLOC1, FALSE, TRUE, "*" },
   { RPL_ADMINLOC2, FALSE, TRUE, "*" },
   { RPL_ADMINEMAIL, FALSE, TRUE, "*" },
   { NULL, 0, 0, NULL };
}

xIrcMsgDispatchEntry::xIrcMsgDispatchEntry(QWidget *p_Widget, const char *pSlot, 
                                           xIrcMessage _msg, int &accepted)
{
   char *response;
   IrcCommands *pCmdList;

   pWidget = p_Widget;
   slot = pSlot;
   msg = _msg;
   pResponseList = NULL;
   respose = ircResponses.text(p_Msg->rspCode());
   for (pCmdList = cmdList; pCmdList->cmdName; pCmdList++)
   {
      if (strcmp(response, pCmdList->cmdName) == 0)
         pResponseList = pCmdList->replies;
   }
   if (pResponseList)
   {
      if (pMsg->rspCode != PRIVMSG && pMsg->rspCode != NOTICE)
      {
         accepted = 1;
         connect(this, SIGNAL(gotResponse), pWidget, pSlot);
      }
      else
         accepted = 0;
   }
   else
      accepted = -1;
}

xIrcMsgDispatchEntry::~xIrcMsgDispatchEntry()
{
}

bool xIrcMsgDispatchEntry::is(xIrcMessage *pMsg)
{
   int *ip;

   for (ip = pResponseList; *ip; ip++)
      if (pMsg->rspCode == *ip)
         break;
   return(*ip == 0 ? FALSE : TRUE);
}

bool xIrcMsgDispatchEntry::dispatchResponse(xIrcMessage *pMsg)
{
   bool rv = TRUE;

   for (IrcResponseParse *pRsp = responseParseStrings; pRsp->rspCode != 0; pRsp++)
      if (pRsp == pMsg->rspCode)
      {
         if (pRsp->display)
            emit gotResponse(pMsg);
         if (pRsp->terminating)
            rv = FALSE;
      }
   return(rv);
}
