/***************************************************************************
                          ts2rtp.cpp  -  description
                             -------------------
    begin                : Mon Feb 3 2003
    copyright            : (C) 2003-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/02/02 10:08:25 $ by $Author: juergenk $

    some code from :
		dvbstream (GPL), Copyright (C) Dave Chapman 2001,2002
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kmessagebox.h>
#include <klocale.h>

#include "ts2rtp.h"



Ts2Rtp::Ts2Rtp( bool *ok ) : Sender( ok )
{
	rtpSocket = 0;
	
	int iRet, iLoop = 1;
	//char cTtl = 2;
	//char cLoop=0;

	rtpSocket = socket( AF_INET, SOCK_DGRAM, 0 );

	if ( rtpSocket < 0) {
		KMessageBox::information( 0, "Can't open rtp socket.", i18n("Warning") );
		*ok = false;
		rtpSocket = 0;
	}

	rtpAddr.sin_family = AF_INET;
	rtpAddr.sin_port = htons(1234);
	rtpAddr.sin_addr.s_addr = inet_addr("192.168.0.255");

	/*iRet = setsockopt(iSocket, SOL_SOCKET, SO_REUSEADDR, &iLoop, sizeof(int));
	if (iRet < 0) {
		fprintf(stderr,"setsockopt SO_REUSEADDR failed\n");
		exit(1);
	}*/

	/*iRet = setsockopt(iSocket, IPPROTO_IP, IP_MULTICAST_TTL, &cTtl, sizeof(char));
	if (iRet < 0) {
		fprintf(stderr,"setsockopt IP_MULTICAST_TTL failed.  multicast in kernel?\n");
		exit(1);
	}*/
	iRet = setsockopt( rtpSocket, SOL_SOCKET, SO_BROADCAST, &iLoop, sizeof(iLoop));
	if (iRet < 0) {
		KMessageBox::information( 0, "Can't init rtp socket.", i18n("Warning") );
		*ok = false;
	}

	/*cLoop = 1;
	iRet = setsockopt(iSocket, IPPROTO_IP, IP_MULTICAST_LOOP, &cLoop, sizeof(char));
	if (iRet < 0) {
		fprintf(stderr,"setsockopt IP_MULTICAST_LOOP failed.  multicast in kernel?\n");
		exit(1);
	}*/
}



Ts2Rtp::~Ts2Rtp()
{
	if ( rtpSocket ) close( rtpSocket );
}



void Ts2Rtp::initrtp()
{
	/* fill in the MPEG-2 TS deefaults */
	/* Note: MPEG-2 TS defines a timestamping base frequency of 90000 Hz. */
	hRtp.b.v=2;
	hRtp.b.p=0;
	hRtp.b.x=0;
	hRtp.b.cc=0;
	hRtp.b.m=0;
	hRtp.b.pt=33;
	hRtp.b.sequence=rand() & 65535;
	hRtp.timestamp=rand();
	hRtp.ssrc=rand();
}


/* Send a single RTP packet, converting the RTP header to network byte order. */
int Ts2Rtp::sendrtp( char *data, int len )
{
	char *buf=(char*)alloca(len+72);
	unsigned int intP;
	char* charP = (char*) &intP;
	int headerSize;
	buf[0]  = 0x00;
	buf[0] |= ((((char) hRtp.b.v)<<6)&0xc0);
	buf[0] |= ((((char) hRtp.b.p)<<5)&0x20);
	buf[0] |= ((((char) hRtp.b.x)<<4)&0x10);
	buf[0] |= ((((char) hRtp.b.cc)<<0)&0x0f);
	buf[1]  = 0x00;
	buf[1] |= ((((char) hRtp.b.m)<<7)&0x80);
	buf[1] |= ((((char) hRtp.b.pt)<<0)&0x7f);
	intP = htonl(hRtp.b.sequence);
	memcpy(&buf[2],charP+2,2);
	intP = htonl(hRtp.timestamp);
	memcpy(&buf[4],&intP,4);
	/* SSRC: not implemented */
	buf[8]  = 0x0f;
	buf[9]  = 0x0f;
	buf[10] = 0x0f;
	buf[11] = 0x0f;
	headerSize = 12 + 4*hRtp.b.cc; /* in bytes */
	memcpy(buf+headerSize,data,len);

	hRtp.b.sequence++;
	return sendto( rtpSocket, buf, len+headerSize, 0, (struct sockaddr *)&rtpAddr, sizeof(rtpAddr) );
}
