/***************************************************************************
                          dvbsi.h  -  description
                             -------------------
    begin                : 2004
    copyright            : (C) 2003-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/02/02 10:08:25 $ by $Author: juergenk $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DVBSI_H
#define DVBSI_H

#include "dvbsection.h"
#include "dvbstream.h"



class DVBsi : public DVBsection
{
	Q_OBJECT

public: 

	DVBsi( bool *ok, int card, DvbStream *d );
	~DVBsi();
	bool getSection( int pid, int tid, int timeout=5000 );
	bool listChannels();
	bool tableSDT( unsigned char* buf );
	bool tablePAT( unsigned char *buf );
	bool tablePMT( unsigned char* buf );
	bool tableNIT( unsigned char* buf );
	void serviceDesc( unsigned char* buf, ChannelDesc *desc );
	void satelliteDesc( unsigned char* buf, Transponder *trans );
	void cableDesc( unsigned char* buf, Transponder *trans );
	void terrestrialDesc( unsigned char* buf, Transponder *trans );
	void freqListDesc( unsigned char* buf, Transponder *trans );

	QPtrList<ChannelDesc> channels;
	QPtrList<Transponder> transponders;
	DvbStream *dvb;
	int indexChannels;
	int progressTransponder;

public slots:

	void go( QPtrList<Transponder> trans, int mode=1 );
	void stop();

protected:

	virtual void run();
	virtual void timerEvent( QTimerEvent *e );

private:

	void out( bool stopscan=true );
	
	int scanMode;

signals:

	void end( bool );

};

#endif
