/***************************************************************************
                          dvbout.h  -  description
                             -------------------
    begin                : Sat Mar 6 2004
    copyright            : (C) 2004-2005 by Christophe Thommeret
    email                : hftom@free.fr
    last modified        : $Date: 2005/02/02 10:08:24 $ by $Author: juergenk $
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DVBOUT_H
#define DVBOUT_H

#include <qobject.h>
#include <qthread.h>
#include <qstring.h>
#include <qfile.h>
#include <qtimer.h>
#include <qvaluelist.h>

#include "channeldesc.h"
#include "ts2pes.h"
#include "ts2rtp.h"
#include "gdvb.h"



class DVBout : public QObject, public QThread
{
	Q_OBJECT
	
public:

	DVBout( ChannelDesc chan, int card );
	~DVBout();
	void process( unsigned char *buf, int size );
	bool goLive( QString name, int napid );
	void stopLive();
	bool goRec( int type, QString name, RecTimer *t );
	bool hasRec();
	bool hasLive();
	bool hasInstantRec();
	bool timeShiftMode();
	bool doPause( QString name );
	int currentAudioPid();
	void changeTimer( int ms );

	ChannelDesc channel;
	QValueList<int> dmx;
	RecTimer *recTimer;
	
public slots:

	void stopRec();

private slots:

	void setPatPmt();

private:

	void writePmt();
	void writePat();
	void calculateCRC( unsigned char *p_begin, unsigned char *p_end );

	int pmtpid;
	int activeApid;
	bool patpmt;
	int countpatpmt;
	int outType;
	bool timeShifting;
	QString pipeName;
	QFile outFile, liveFile;
	int fdPipe;
	Ts2Pes *tp, *tpShift;
	Ts2Rtp *rtp;
	unsigned char thBuf[188*100];
	unsigned char tspat[188];
	unsigned char tspmt[188];
	unsigned int CRC32[256];
	int thWrite;
	bool beginLive;
	bool haveRec, haveLive, instantRec;
	QTimer stopRecTimer, timerPatPmt;

signals:

	void playDvb();
	void endRecord(DVBout*, RecTimer*, bool);
	void shifting(bool);

protected:

	virtual void run();
	
};

#endif
