#--
# Ruby binding of Hyper Estraier
#                                                       Copyright (C) 2004-2005 Mikio Hirabayashi
#  This file is part of Hyper Estraier.
#  Hyper Estraier is free software; you can redistribute it and/or modify it under the terms of
#  the GNU Lesser General Public License as published by the Free Software Foundation; either
#  version 2.1 of the License or any later version.  Hyper Estraier is distributed in the hope
#  that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
#  License for more details.
#  You should have received a copy of the GNU Lesser General Public License along with Hyper
#  Estraier; if not, write to the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
#  Boston, MA 02111-1307 USA.
#++
#:include:overview



#
# Module for the namespace of Hyper Estraier
#
module Estraier
  #----------------------------------------------------------------
  #++ Abstraction of document.
  #----------------------------------------------------------------
  class Document
    #--------------------------------
    # public methods
    #--------------------------------
    public
    # Add an attribute.
    # `name' specifies the name of an attribute.
    # `value' specifies the value of the attribute.  If it is `nil', the attribute is removed.
    # The return value is always `nil'.
    def add_attr(name, value)
    end
    # Add a sentence of text.
    # `text' specifies a sentence of text.
    # The return value is always `nil'.
    def add_text(text)
    end
    # Add a hidden sentence.
    # `text' specifies a hidden sentence.
    # The return value is always `nil'.
    def add_hidden_text(text)
    end
    # Get the ID number.
    # The return value is the ID number of the document object.  If the object has never been
    # registered, -1 is returned.
    # The return value is always `nil'.
    def id()
    end
    # Get a list of attribute names of a document object.
    # The return value is a list object of attribute names.
    def attr_names()
    end
    # Get the value of an attribute.
    # `name' specifies the name of an attribute.
    # The return value is the value of the attribute or `nil' if it does not exist.
    def attr(name)
    end
    # Get a list of sentences of the text.
    # The return value is a list object of sentences of the text.
    def texts()
    end
    # Concatenate sentences of the text of a document object.
    # The return value is concatenated sentences.
    def cat_texts()
    end
    # Dump draft data of a document object.
    # The return value is draft data.
    def dump_draft()
    end
    # Make a snippet of the body text.
    # `words' specifies an array object of words to be highlight.
    # `wwidth' specifies whole width of the result.
    # `hwidth' specifies width of strings picked up from the beginning of the text.
    # `awidth' width of strings picked up around each highlighted word.
    # The return value is a snippet string of the body text.  There are tab separated values.
    # Each line is a string to be shown.  Though most lines have only one field, some lines have
    # two fields.  If the second field exists, the first field is to be shown with highlighted,
    # and the second field means its normalized form.
    def make_snippet(words, wwidth, hwidth, awidth)
    end
    #--------------------------------
    # private methods
    #--------------------------------
    private
    # Create a document object.
    # `draft' specifies a string of draft data.
    def initialize(draft = "")
    end
  end
  #----------------------------------------------------------------
  #++ Abstraction of search condition.
  #----------------------------------------------------------------
  class Condition
    #--------------------------------
    # public constants
    #--------------------------------
    public
    # option: check N-gram keys skipping by three
    SURE = 1 << 0
    # option: check N-gram keys skipping by two
    USUAL = 1 << 1
    # option: without TF-IDF tuning
    FAST = 1 << 2
    # option: with the simplified phrase
    AGITO = 1 << 3
    # option: check every N-gram key
    NOIDF = 1 << 4
    # option: check N-gram keys skipping by one
    SIMPLE = 1 << 10
    #--------------------------------
    # public methods
    #--------------------------------
    public
    # Set the search phrase.
    # `phrase' specifies a search phrase.
    # The return value is always `nil'.
    def set_phrase(phrase)
    end
    # Add an expression for an attribute.
    # `expr' specifies an expression for an attribute.
    # The return value is always `nil'.
    def add_attr(expr)
    end
    # Set the order of a condition object.
    # `expr' specifies an expression for the order.  By default, the order is by score descending.
    # The return value is always `nil'.
    def set_order(expr)
    end
    # Set the maximum number of retrieval.
    # `max' specifies the maximum number of retrieval.  By default, the number of retrieval is
    # not limited.
    # The return value is always `nil'.
    def set_max(max)
    end
    # Set options of retrieval.
    # `options' specifies options: `Condition::SURE' specifies that it checks every N-gram
    # key, `Condition::USU', which is the default, specifies that it checks N-gram keys
    # with skipping one key, `Condition::FAST' skips two keys, `Condition::AGITO'
    # skips three keys, `Condition::NOIDF' specifies not to perform TF-IDF tuning,
    # `Condition::SIMPLE' specifies to use simplified phrase.  Each option can be specified at
    # the same time by bitwise or.  If keys are skipped, though search speed is improved, the
    # relevance ratio grows less.
    # The return value is always `nil'.
    def set_options(options)
    end
    #--------------------------------
    # private methods
    #--------------------------------
    private
    # Create a search condition object.
    def initialize()
    end
  end
  #----------------------------------------------------------------
  #++ Abstraction of result set from database.
  #----------------------------------------------------------------
  class Result
    #--------------------------------
    # public methods
    #--------------------------------
    public
    # Get the number of documents.
    # The return value is the number of documents in the result.
    def doc_num()
    end
    # Get the ID number of a document.
    # `index' specifies the index of a document.
    # The return value is the ID number of the document or -1 if the index is out of bounds.
    def get_doc_id(index)
    end
    # Get a list of hint words.
    # The return value is a list of hint words.
    def hint_words()
    end
    # Get the value of a hint word.
    # `word' specifies a hint word.  An empty string means the number of whole result.
    # The return value is the number of documents corresponding the hint word.  If the word is
    # in a negative condition, the value is negative.
    def hint()
    end
    #--------------------------------
    # private methods
    #--------------------------------
    private
    # Create a result set object.
    def initialize()
    end
  end
  #----------------------------------------------------------------
  #++ Abstraction of database.
  #----------------------------------------------------------------
  class Database
    #--------------------------------
    # public constants
    #--------------------------------
    public
    # version of Hyper Estraier
    VERSION = "0.0.0"
    # error code: no error
    ERRNOERR = 0
    # error code: invalid argument
    ERRINVAL = 1
    # error code: access forbidden
    ERRACCES = 2
    # error code: lock failure
    ERRLOCK = 3
    # error code: database problem
    ERRDB = 4
    # error code: I/O problem
    ERRIO = 5
    # error code: no item
    ERRNOITEM = 6
    # error code: miscellaneous
    ERRMISC = 9999
    # open mode: open as a reader
    DBREADER = 1 << 0
    # open mode: open as a writer
    DBWRITER = 1 << 1
    # open mode: a writer creating
    DBCREAT = 1 << 2
    # open mode: a writer truncating
    DBTRUNC = 1 << 3
    # open mode: open without locking
    DBNOLCK = 1 << 4
    # open mode: lock without blocking
    DBLCKNB = 1 << 5
    # open mode: use perfect N-gram analyzer
    DBPERFNG = 1 << 6
    # optimize option: omit purging dispensable region of deleted
    OPTNOPURGE = 1 << 0
    # optimize option: omit optimization of the database files
    OPTNODBOPT = 1 << 1
    # put_doc option: clean up dispensable regions
    PDCLEAN = 1 << 0
    # out_doc option: clean up dispensable regions
    ODCLEAN = 1 << 0
    # get_doc option: no attributes
    GDNOATTR = 1 << 0
    # get_doc option: no text
    GDNOTEXT = 1 << 1
    #--------------------------------
    # public methods
    #--------------------------------
    public
    # Get the string of an error code.
    # `ecode' specifies an error code.
    # The return value is the string of the error code.
    def err_msg(ecode)
    end
    # Open a database.
    # `name' specifies the name of a database directory.
    # `omode' specifies open modes: `Database::DBWRITER' as a writer, `Database::DBREADER' as a
    # reader.  If the mode is `Database::DBWRITER', the following may be added by bitwise or:
    # `Database::DBCREAT', which means it creates a new database if not exist,
    # `Database::DBTRUNC', which means it creates a new database regardless if one exists.  Both
    # of `Database::DBREADER' and  `Database::DBWRITER' can be added to by bitwise or:
    # `Database::DBNOLCK', which means it opens a database file without file locking, or
    # `Database::DBLCKNB', which means locking is performed without blocking.  If
    # `Database::DBNOLCK' is used, the application is responsible for exclusion control.
    # `Database::DBCREAT' can be added to by bitwise or: `Database::DBPERFNG', which means N-gram
    # analysis is performed against European text also.
    # The return value is true if success, else it is false.
    def open(name, omode)
    end
    # Close the database.
    # The return value is true if success, else it is false.
    def close()
    end
    # Get the last happened error code.
    # The return value is the last happened error code.
    def error()
    end
    # Check whether the database has a fatal error.
    # The return value is true if the database has fatal erroor, else it is false.
    def fatal()
    end
    # Flush index words in the cache.
    # `max' specifies the maximum number of words to be flushed.  If it not more than zero, all
    # words are flushed.
    # The return value is true if success, else it is false.
    def flush(max)
    end
    # Synchronize updating contents.
    # The return value is true if success, else it is false.
    def sync()
    end
    # Optimize the database.
    # `options' specifies options: `Database::OPTNOPURGE' to omit purging dispensable region of
    # deleted documents, `Database::OPTNODBOPT' to omit optimization of the database files.  The
    # two can be specified at the same time by bitwise or.
    # The return value is true if success, else it is false.
    def optimize(options)
    end
    # Add a document.
    # `doc' specifies a document object.  The document object should have the URI attribute.
    # `options' specifies options: `Database.PDCLEAN' to clean up dispensable regions of the
    # overwritten document.
    # The return value is true if success, else it is false.
    def put_doc(doc, options)
    end
    # Remove a document.
    # `id' specifies the ID number of a registered document.
    # `options' specifies options: `Database.ODCLEAN' to clean up dispensable regions of the
    # deleted document.
    # The return value is true if success, else it is false.
    def out_doc(id, options)
    end
    # Edit attributes of a document.
    # `doc' specifies a document object.
    # The return value is true if success, else it is false.
    def edit_doc(doc)
    end
    # Retrieve a document.
    # `id' specifies the ID number of a registered document.
    # `options' specifies options: `Database.GDNOATTR' to ignore attributes, `Database.GDNOTEXT'
    # to ignore the body text.  The two can be specified at the same time by bitwise or.
    # The return value is a document object.  On error, `nil' is returned.
    def get_doc(id, options)
    end
    # Retrieve the value of an attribute of a document.
    # `id' specifies the ID number of a registered document.
    # `name' specifies the name of an attribute.
    # The return value is the value of the attribute or `nil' if it does not exist.
    def get_doc_attr(id, name)
    end
    # Get the ID of a document specified by URI.
    # `uri' specifies the URI of a registered document.
    # The return value is the ID of the document.  On error, -1 is returned.
    def uri_to_id(uri)
    end
    # Get the name.
    # The return value is the name of the database.
    def name()
    end
    # Get the number of documents.
    # The return value is the number of documents in the database.
    def doc_num()
    end
    # Get the number of unique words.
    # The return value is the number of unique words in the database.
    def word_num()
    end
    # Get the size.
    # The return value is the size of the database.
    def size()
    end
    # Search documents corresponding a condition.
    # `cond' specifies a condition object.
    # The return value is a result object.  On error, `nil' is returned.
    def search(cond)
    end
    # Check whether a document object matches the phrase of a search condition object definitely.
    # `doc' specifies a document object.
    # `cond' specifies a search condition object.
    # The return value is true if the document matches the phrase of the condition object
    # definitely, else it is false.
    def scan_doc(doc, cond)
    end
    # Set the maximum size of the cache memory.
    # `size' specifies the maximum size of the index cache.  By default, it is 64MB.  If it is
    # not more than 0, the current size is not changed.
    # `anum' specifies the maximum number of cached records for document attributes.  By default,
    # it is 8192.  If it is not more than 0, the current size is not changed.
    # `tnum' specifies the maximum number of cached records for document texts.  By default, it
    # is 1024.  If it is not more than 0, the current size is not changed.
    # `rnum' specifies the maximum number of cached records for occurrence results.  By default,
    # it is 256.  If it is not more than 0, the current size is not changed.
    # The return value is always `nil'.
    def set_cache_size(size, anum, tnum, rnum)
    end
    #--------------------------------
    # private methods
    #--------------------------------
    private
    # Create a database object.
    def initialize()
    end
  end
end



# END OF FILE
