% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3.R
\name{box}
\alias{box}
\alias{new_box}
\alias{is_box}
\alias{unbox}
\title{Box a value}
\usage{
new_box(.x, class = NULL, ...)

is_box(x, class = NULL)

unbox(box)
}
\arguments{
\item{class}{For \code{new_box()}, an additional class for the
boxed value (in addition to \code{rlang_box}). For \code{is_box()}, a class
or vector of classes passed to \code{\link[=inherits_all]{inherits_all()}}.}

\item{...}{Additional attributes passed to \code{\link[base:structure]{base::structure()}}.}

\item{x, .x}{An R object.}

\item{box}{A boxed value to unbox.}
}
\description{
\code{new_box()} is similar to \code{\link[base:I]{base::I()}} but it protects a value by
wrapping it in a scalar list rather than by adding an attribute.
\code{unbox()} retrieves the boxed value. \code{is_box()} tests whether an
object is boxed with optional class. \code{as_box()} ensures that a
value is wrapped in a box. \code{as_box_if()} does the same but only if
the value matches a predicate.
}
\examples{
boxed <- new_box(letters, "mybox")
is_box(boxed)
is_box(boxed, "mybox")
is_box(boxed, "otherbox")

unbox(boxed)

# as_box() avoids double-boxing:
boxed2 <- as_box(boxed, "mybox")
boxed2
unbox(boxed2)

# Compare to:
boxed_boxed <- new_box(boxed, "mybox")
boxed_boxed
unbox(unbox(boxed_boxed))

# Use `as_box_if()` with a predicate if you need to ensure a box
# only for a subset of values:
as_box_if(NULL, is_null, "null_box")
as_box_if("foo", is_null, "null_box")
}
