/* -*- c-basic-offset: 8; -*- */
/* webm.c: WebM data handler
 * $Id$
 *
 *  Copyright (C) 2002-2012 the Icecast team <team@icecast.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
 #include <config.h>
#endif

#include <stdlib.h>
#include <string.h>

#ifdef HAVE_INTTYPES_H
#include <inttypes.h>
#endif

#include <shoutidjc/shout.h>
#include "shout_private.h"

/* -- local datatypes -- */

/* no local state */

/* -- static prototypes -- */
static int send_webm(shout_t *self, const unsigned char *data, size_t len);
static void close_webm(shout_t *self);

int shout_open_webm(shout_t *self)
{
	self->format_data = NULL;
	self->send = send_webm;
	self->close = close_webm;

	return SHOUTERR_SUCCESS;
}

static int send_webm(shout_t *self, const unsigned char *data, size_t len)
{
	/* IMPORTANT TODO: we just send the raw data. We need throttling. */

	ssize_t ret = shout_send_raw(self, data, len);
	if (ret != (ssize_t)len)
		return self->error = SHOUTERR_SOCKET;

	return self->error = SHOUTERR_SUCCESS;
}

static void close_webm(shout_t *self)
{
	/* no local state */
	(void)self;
}
