/* libsession.c generated by valac 0.32.1, the Vala compiler
 * generated from libsession.vala, do not modify */

/*
 * This file is part of budgie-desktop.
 *
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define LIB_SESSION_TYPE_SESSION_MANAGER (lib_session_session_manager_get_type ())
#define LIB_SESSION_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_SESSION_TYPE_SESSION_MANAGER, LibSessionSessionManager))
#define LIB_SESSION_IS_SESSION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_SESSION_TYPE_SESSION_MANAGER))
#define LIB_SESSION_SESSION_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), LIB_SESSION_TYPE_SESSION_MANAGER, LibSessionSessionManagerIface))

typedef struct _LibSessionSessionManager LibSessionSessionManager;
typedef struct _LibSessionSessionManagerIface LibSessionSessionManagerIface;

#define LIB_SESSION_TYPE_SESSION_MANAGER_PROXY (lib_session_session_manager_proxy_get_type ())
typedef GDBusProxy LibSessionSessionManagerProxy;
typedef GDBusProxyClass LibSessionSessionManagerProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define LIB_SESSION_TYPE_SESSION_CLIENT (lib_session_session_client_get_type ())
#define LIB_SESSION_SESSION_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), LIB_SESSION_TYPE_SESSION_CLIENT, LibSessionSessionClient))
#define LIB_SESSION_IS_SESSION_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), LIB_SESSION_TYPE_SESSION_CLIENT))
#define LIB_SESSION_SESSION_CLIENT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), LIB_SESSION_TYPE_SESSION_CLIENT, LibSessionSessionClientIface))

typedef struct _LibSessionSessionClient LibSessionSessionClient;
typedef struct _LibSessionSessionClientIface LibSessionSessionClientIface;

#define LIB_SESSION_TYPE_SESSION_CLIENT_PROXY (lib_session_session_client_proxy_get_type ())
typedef GDBusProxy LibSessionSessionClientProxy;
typedef GDBusProxyClass LibSessionSessionClientProxyClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _LibSessionRegisterWithSessionData LibSessionRegisterWithSessionData;

struct _LibSessionSessionManagerIface {
	GTypeInterface parent_iface;
	void (*RegisterClient) (LibSessionSessionManager* self, const gchar* app_id, const gchar* client_start_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	char* (*RegisterClient_finish) (LibSessionSessionManager* self, GAsyncResult* _res_, GError** error);
};

struct _LibSessionSessionClientIface {
	GTypeInterface parent_iface;
	void (*EndSessionResponse) (LibSessionSessionClient* self, gboolean is_ok, const gchar* reason, GError** error);
};

struct _LibSessionRegisterWithSessionData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	gchar* app_id;
	LibSessionSessionClient* result;
	char* path;
	gchar* msg;
	gchar* start_id;
	LibSessionSessionManager* session;
	LibSessionSessionClient* sclient;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	LibSessionSessionManager* _tmp4_;
	LibSessionSessionManager* _tmp5_;
	LibSessionSessionManager* _tmp6_;
	GError* e;
	GError* _tmp7_;
	const gchar* _tmp8_;
	char* _tmp9_;
	LibSessionSessionManager* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	char* _tmp13_;
	char* _tmp14_;
	GError* _vala1_e;
	GError* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	const char* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	LibSessionSessionClient* _tmp24_;
	const char* _tmp25_;
	LibSessionSessionClient* _tmp26_;
	LibSessionSessionClient* _tmp27_;
	GError* _vala2_e;
	GError* _tmp28_;
	const gchar* _tmp29_;
	GError * _inner_error_;
};



GType lib_session_session_manager_proxy_get_type (void) G_GNUC_CONST;
guint lib_session_session_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType lib_session_session_manager_get_type (void) G_GNUC_CONST;
void lib_session_session_manager_RegisterClient (LibSessionSessionManager* self, const gchar* app_id, const gchar* client_start_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
char* lib_session_session_manager_RegisterClient_finish (LibSessionSessionManager* self, GAsyncResult* _res_, GError** error);
static void lib_session_session_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void lib_session_session_manager_proxy_RegisterClient_async (LibSessionSessionManager* self, const gchar* app_id, const gchar* client_start_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static char* lib_session_session_manager_proxy_RegisterClient_finish (LibSessionSessionManager* self, GAsyncResult* _res_, GError** error);
static void lib_session_session_manager_proxy_lib_session_session_manager_interface_init (LibSessionSessionManagerIface* iface);
static void _dbus_lib_session_session_manager_RegisterClient (LibSessionSessionManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_lib_session_session_manager_RegisterClient_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void lib_session_session_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* lib_session_session_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean lib_session_session_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _lib_session_session_manager_unregister_object (gpointer user_data);
GType lib_session_session_client_proxy_get_type (void) G_GNUC_CONST;
guint lib_session_session_client_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType lib_session_session_client_get_type (void) G_GNUC_CONST;
void lib_session_session_client_EndSessionResponse (LibSessionSessionClient* self, gboolean is_ok, const gchar* reason, GError** error);
static void lib_session_session_client_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_lib_session_session_client_stop (LibSessionSessionClient* self, GVariant* parameters);
static void _dbus_handle_lib_session_session_client_query_end_session (LibSessionSessionClient* self, GVariant* parameters);
static void _dbus_handle_lib_session_session_client_end_session (LibSessionSessionClient* self, GVariant* parameters);
static void _dbus_handle_lib_session_session_client_cancel_end_session (LibSessionSessionClient* self, GVariant* parameters);
static void lib_session_session_client_proxy_EndSessionResponse (LibSessionSessionClient* self, gboolean is_ok, const gchar* reason, GError** error);
static void lib_session_session_client_proxy_lib_session_session_client_interface_init (LibSessionSessionClientIface* iface);
static void _dbus_lib_session_session_client_EndSessionResponse (LibSessionSessionClient* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void lib_session_session_client_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* lib_session_session_client_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean lib_session_session_client_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_lib_session_session_client_stop (GObject* _sender, gpointer* _data);
static void _dbus_lib_session_session_client_query_end_session (GObject* _sender, guint flags, gpointer* _data);
static void _dbus_lib_session_session_client_end_session (GObject* _sender, guint flags, gpointer* _data);
static void _dbus_lib_session_session_client_cancel_end_session (GObject* _sender, gpointer* _data);
static void _lib_session_session_client_unregister_object (gpointer user_data);
static void lib_session_register_with_session_data_free (gpointer _data);
void lib_session_register_with_session (const gchar* app_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
LibSessionSessionClient* lib_session_register_with_session_finish (GAsyncResult* _res_);
static gboolean lib_session_register_with_session_co (LibSessionRegisterWithSessionData* _data_);
static void lib_session_register_with_session_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);

static const GDBusArgInfo _lib_session_session_manager_dbus_arg_info_RegisterClient_app_id = {-1, "app_id", "s"};
static const GDBusArgInfo _lib_session_session_manager_dbus_arg_info_RegisterClient_client_start_id = {-1, "client_start_id", "s"};
static const GDBusArgInfo _lib_session_session_manager_dbus_arg_info_RegisterClient_result = {-1, "result", "o"};
static const GDBusArgInfo * const _lib_session_session_manager_dbus_arg_info_RegisterClient_in[] = {&_lib_session_session_manager_dbus_arg_info_RegisterClient_app_id, &_lib_session_session_manager_dbus_arg_info_RegisterClient_client_start_id, NULL};
static const GDBusArgInfo * const _lib_session_session_manager_dbus_arg_info_RegisterClient_out[] = {&_lib_session_session_manager_dbus_arg_info_RegisterClient_result, NULL};
static const GDBusMethodInfo _lib_session_session_manager_dbus_method_info_RegisterClient = {-1, "RegisterClient", (GDBusArgInfo **) (&_lib_session_session_manager_dbus_arg_info_RegisterClient_in), (GDBusArgInfo **) (&_lib_session_session_manager_dbus_arg_info_RegisterClient_out)};
static const GDBusMethodInfo * const _lib_session_session_manager_dbus_method_info[] = {&_lib_session_session_manager_dbus_method_info_RegisterClient, NULL};
static const GDBusSignalInfo * const _lib_session_session_manager_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _lib_session_session_manager_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _lib_session_session_manager_dbus_interface_info = {-1, "org.gnome.SessionManager", (GDBusMethodInfo **) (&_lib_session_session_manager_dbus_method_info), (GDBusSignalInfo **) (&_lib_session_session_manager_dbus_signal_info), (GDBusPropertyInfo **) (&_lib_session_session_manager_dbus_property_info)};
static const GDBusInterfaceVTable _lib_session_session_manager_dbus_interface_vtable = {lib_session_session_manager_dbus_interface_method_call, lib_session_session_manager_dbus_interface_get_property, lib_session_session_manager_dbus_interface_set_property};
static const GDBusArgInfo _lib_session_session_client_dbus_arg_info_EndSessionResponse_is_ok = {-1, "is_ok", "b"};
static const GDBusArgInfo _lib_session_session_client_dbus_arg_info_EndSessionResponse_reason = {-1, "reason", "s"};
static const GDBusArgInfo * const _lib_session_session_client_dbus_arg_info_EndSessionResponse_in[] = {&_lib_session_session_client_dbus_arg_info_EndSessionResponse_is_ok, &_lib_session_session_client_dbus_arg_info_EndSessionResponse_reason, NULL};
static const GDBusArgInfo * const _lib_session_session_client_dbus_arg_info_EndSessionResponse_out[] = {NULL};
static const GDBusMethodInfo _lib_session_session_client_dbus_method_info_EndSessionResponse = {-1, "EndSessionResponse", (GDBusArgInfo **) (&_lib_session_session_client_dbus_arg_info_EndSessionResponse_in), (GDBusArgInfo **) (&_lib_session_session_client_dbus_arg_info_EndSessionResponse_out)};
static const GDBusMethodInfo * const _lib_session_session_client_dbus_method_info[] = {&_lib_session_session_client_dbus_method_info_EndSessionResponse, NULL};
static const GDBusArgInfo * const _lib_session_session_client_dbus_arg_info_stop[] = {NULL};
static const GDBusSignalInfo _lib_session_session_client_dbus_signal_info_stop = {-1, "Stop", (GDBusArgInfo **) (&_lib_session_session_client_dbus_arg_info_stop)};
static const GDBusArgInfo _lib_session_session_client_dbus_arg_info_query_end_session_flags = {-1, "flags", "u"};
static const GDBusArgInfo * const _lib_session_session_client_dbus_arg_info_query_end_session[] = {&_lib_session_session_client_dbus_arg_info_query_end_session_flags, NULL};
static const GDBusSignalInfo _lib_session_session_client_dbus_signal_info_query_end_session = {-1, "QueryEndSession", (GDBusArgInfo **) (&_lib_session_session_client_dbus_arg_info_query_end_session)};
static const GDBusArgInfo _lib_session_session_client_dbus_arg_info_end_session_flags = {-1, "flags", "u"};
static const GDBusArgInfo * const _lib_session_session_client_dbus_arg_info_end_session[] = {&_lib_session_session_client_dbus_arg_info_end_session_flags, NULL};
static const GDBusSignalInfo _lib_session_session_client_dbus_signal_info_end_session = {-1, "EndSession", (GDBusArgInfo **) (&_lib_session_session_client_dbus_arg_info_end_session)};
static const GDBusArgInfo * const _lib_session_session_client_dbus_arg_info_cancel_end_session[] = {NULL};
static const GDBusSignalInfo _lib_session_session_client_dbus_signal_info_cancel_end_session = {-1, "CancelEndSession", (GDBusArgInfo **) (&_lib_session_session_client_dbus_arg_info_cancel_end_session)};
static const GDBusSignalInfo * const _lib_session_session_client_dbus_signal_info[] = {&_lib_session_session_client_dbus_signal_info_stop, &_lib_session_session_client_dbus_signal_info_query_end_session, &_lib_session_session_client_dbus_signal_info_end_session, &_lib_session_session_client_dbus_signal_info_cancel_end_session, NULL};
static const GDBusPropertyInfo * const _lib_session_session_client_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _lib_session_session_client_dbus_interface_info = {-1, "org.gnome.SessionManager.ClientPrivate", (GDBusMethodInfo **) (&_lib_session_session_client_dbus_method_info), (GDBusSignalInfo **) (&_lib_session_session_client_dbus_signal_info), (GDBusPropertyInfo **) (&_lib_session_session_client_dbus_property_info)};
static const GDBusInterfaceVTable _lib_session_session_client_dbus_interface_vtable = {lib_session_session_client_dbus_interface_method_call, lib_session_session_client_dbus_interface_get_property, lib_session_session_client_dbus_interface_set_property};

void lib_session_session_manager_RegisterClient (LibSessionSessionManager* self, const gchar* app_id, const gchar* client_start_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LIB_SESSION_SESSION_MANAGER_GET_INTERFACE (self)->RegisterClient (self, app_id, client_start_id, _callback_, _user_data_);
}


char* lib_session_session_manager_RegisterClient_finish (LibSessionSessionManager* self, GAsyncResult* _res_, GError** error) {
	return LIB_SESSION_SESSION_MANAGER_GET_INTERFACE (self)->RegisterClient_finish (self, _res_, error);
}


static void lib_session_session_manager_base_init (LibSessionSessionManagerIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/**
     * Proxy for gnome-session
     */
GType lib_session_session_manager_get_type (void) {
	static volatile gsize lib_session_session_manager_type_id__volatile = 0;
	if (g_once_init_enter (&lib_session_session_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LibSessionSessionManagerIface), (GBaseInitFunc) lib_session_session_manager_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType lib_session_session_manager_type_id;
		lib_session_session_manager_type_id = g_type_register_static (G_TYPE_INTERFACE, "LibSessionSessionManager", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (lib_session_session_manager_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (lib_session_session_manager_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) lib_session_session_manager_proxy_get_type);
		g_type_set_qdata (lib_session_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager");
		g_type_set_qdata (lib_session_session_manager_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_lib_session_session_manager_dbus_interface_info));
		g_type_set_qdata (lib_session_session_manager_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) lib_session_session_manager_register_object);
		g_once_init_leave (&lib_session_session_manager_type_id__volatile, lib_session_session_manager_type_id);
	}
	return lib_session_session_manager_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (LibSessionSessionManagerProxy, lib_session_session_manager_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (LIB_SESSION_TYPE_SESSION_MANAGER, lib_session_session_manager_proxy_lib_session_session_manager_interface_init) )
static void lib_session_session_manager_proxy_class_init (LibSessionSessionManagerProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = lib_session_session_manager_proxy_g_signal;
}


static void lib_session_session_manager_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void lib_session_session_manager_proxy_init (LibSessionSessionManagerProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void lib_session_session_manager_proxy_RegisterClient_async (LibSessionSessionManager* self, const gchar* app_id, const gchar* client_start_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager", "RegisterClient");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_id));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (client_start_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static char* lib_session_session_manager_proxy_RegisterClient_finish (LibSessionSessionManager* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	char* _result;
	GVariant* _tmp0_;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp0_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp0_, NULL);
	g_variant_unref (_tmp0_);
	g_object_unref (_reply_message);
	return _result;
}


static void lib_session_session_manager_proxy_lib_session_session_manager_interface_init (LibSessionSessionManagerIface* iface) {
	iface->RegisterClient = lib_session_session_manager_proxy_RegisterClient_async;
	iface->RegisterClient_finish = lib_session_session_manager_proxy_RegisterClient_finish;
}


static void _dbus_lib_session_session_manager_RegisterClient (LibSessionSessionManager* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	gchar* app_id = NULL;
	GVariant* _tmp1_;
	gchar* client_start_id = NULL;
	GVariant* _tmp2_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	app_id = g_variant_dup_string (_tmp1_, NULL);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	client_start_id = g_variant_dup_string (_tmp2_, NULL);
	g_variant_unref (_tmp2_);
	lib_session_session_manager_RegisterClient (self, app_id, client_start_id, (GAsyncReadyCallback) _dbus_lib_session_session_manager_RegisterClient_ready, invocation);
	_g_free0 (app_id);
	_g_free0 (client_start_id);
}


static void _dbus_lib_session_session_manager_RegisterClient_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	char* result;
	invocation = _user_data_;
	result = lib_session_session_manager_RegisterClient_finish ((LibSessionSessionManager*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_object_path (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void lib_session_session_manager_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "RegisterClient") == 0) {
		_dbus_lib_session_session_manager_RegisterClient (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* lib_session_session_manager_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean lib_session_session_manager_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint lib_session_session_manager_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_lib_session_session_manager_dbus_interface_info), &_lib_session_session_manager_dbus_interface_vtable, data, _lib_session_session_manager_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _lib_session_session_manager_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void lib_session_session_client_EndSessionResponse (LibSessionSessionClient* self, gboolean is_ok, const gchar* reason, GError** error) {
	g_return_if_fail (self != NULL);
	LIB_SESSION_SESSION_CLIENT_GET_INTERFACE (self)->EndSessionResponse (self, is_ok, reason, error);
}


static void lib_session_session_client_base_init (LibSessionSessionClientIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("stop", LIB_SESSION_TYPE_SESSION_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("query_end_session", LIB_SESSION_TYPE_SESSION_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("end_session", LIB_SESSION_TYPE_SESSION_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__UINT, G_TYPE_NONE, 1, G_TYPE_UINT);
		g_signal_new ("cancel_end_session", LIB_SESSION_TYPE_SESSION_CLIENT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	}
}


GType lib_session_session_client_get_type (void) {
	static volatile gsize lib_session_session_client_type_id__volatile = 0;
	if (g_once_init_enter (&lib_session_session_client_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LibSessionSessionClientIface), (GBaseInitFunc) lib_session_session_client_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType lib_session_session_client_type_id;
		lib_session_session_client_type_id = g_type_register_static (G_TYPE_INTERFACE, "LibSessionSessionClient", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (lib_session_session_client_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (lib_session_session_client_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) lib_session_session_client_proxy_get_type);
		g_type_set_qdata (lib_session_session_client_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SessionManager.ClientPrivate");
		g_type_set_qdata (lib_session_session_client_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_lib_session_session_client_dbus_interface_info));
		g_type_set_qdata (lib_session_session_client_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) lib_session_session_client_register_object);
		g_once_init_leave (&lib_session_session_client_type_id__volatile, lib_session_session_client_type_id);
	}
	return lib_session_session_client_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (LibSessionSessionClientProxy, lib_session_session_client_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (LIB_SESSION_TYPE_SESSION_CLIENT, lib_session_session_client_proxy_lib_session_session_client_interface_init) )
static void lib_session_session_client_proxy_class_init (LibSessionSessionClientProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = lib_session_session_client_proxy_g_signal;
}


static void _dbus_handle_lib_session_session_client_stop (LibSessionSessionClient* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "stop");
}


static void _dbus_handle_lib_session_session_client_query_end_session (LibSessionSessionClient* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint flags = 0U;
	GVariant* _tmp3_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp3_);
	g_variant_unref (_tmp3_);
	g_signal_emit_by_name (self, "query-end-session", flags);
}


static void _dbus_handle_lib_session_session_client_end_session (LibSessionSessionClient* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	guint flags = 0U;
	GVariant* _tmp4_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp4_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp4_);
	g_variant_unref (_tmp4_);
	g_signal_emit_by_name (self, "end-session", flags);
}


static void _dbus_handle_lib_session_session_client_cancel_end_session (LibSessionSessionClient* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "cancel-end-session");
}


static void lib_session_session_client_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "Stop") == 0) {
		_dbus_handle_lib_session_session_client_stop ((LibSessionSessionClient*) proxy, parameters);
	} else if (strcmp (signal_name, "QueryEndSession") == 0) {
		_dbus_handle_lib_session_session_client_query_end_session ((LibSessionSessionClient*) proxy, parameters);
	} else if (strcmp (signal_name, "EndSession") == 0) {
		_dbus_handle_lib_session_session_client_end_session ((LibSessionSessionClient*) proxy, parameters);
	} else if (strcmp (signal_name, "CancelEndSession") == 0) {
		_dbus_handle_lib_session_session_client_cancel_end_session ((LibSessionSessionClient*) proxy, parameters);
	}
}


static void lib_session_session_client_proxy_init (LibSessionSessionClientProxy* self) {
}


static void lib_session_session_client_proxy_EndSessionResponse (LibSessionSessionClient* self, gboolean is_ok, const gchar* reason, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.gnome.SessionManager.ClientPrivate", "EndSessionResponse");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (is_ok));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (reason));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void lib_session_session_client_proxy_lib_session_session_client_interface_init (LibSessionSessionClientIface* iface) {
	iface->EndSessionResponse = lib_session_session_client_proxy_EndSessionResponse;
}


static void _dbus_lib_session_session_client_EndSessionResponse (LibSessionSessionClient* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gboolean is_ok = FALSE;
	GVariant* _tmp5_;
	gchar* reason = NULL;
	GVariant* _tmp6_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp5_ = g_variant_iter_next_value (&_arguments_iter);
	is_ok = g_variant_get_boolean (_tmp5_);
	g_variant_unref (_tmp5_);
	_tmp6_ = g_variant_iter_next_value (&_arguments_iter);
	reason = g_variant_dup_string (_tmp6_, NULL);
	g_variant_unref (_tmp6_);
	lib_session_session_client_EndSessionResponse (self, is_ok, reason, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (reason);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void lib_session_session_client_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "EndSessionResponse") == 0) {
		_dbus_lib_session_session_client_EndSessionResponse (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* lib_session_session_client_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean lib_session_session_client_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_lib_session_session_client_stop (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.ClientPrivate", "Stop", _arguments, NULL);
}


static void _dbus_lib_session_session_client_query_end_session (GObject* _sender, guint flags, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (flags));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.ClientPrivate", "QueryEndSession", _arguments, NULL);
}


static void _dbus_lib_session_session_client_end_session (GObject* _sender, guint flags, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (flags));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.ClientPrivate", "EndSession", _arguments, NULL);
}


static void _dbus_lib_session_session_client_cancel_end_session (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.ClientPrivate", "CancelEndSession", _arguments, NULL);
}


guint lib_session_session_client_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_lib_session_session_client_dbus_interface_info), &_lib_session_session_client_dbus_interface_vtable, data, _lib_session_session_client_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "stop", (GCallback) _dbus_lib_session_session_client_stop, data);
	g_signal_connect (object, "query-end-session", (GCallback) _dbus_lib_session_session_client_query_end_session, data);
	g_signal_connect (object, "end-session", (GCallback) _dbus_lib_session_session_client_end_session, data);
	g_signal_connect (object, "cancel-end-session", (GCallback) _dbus_lib_session_session_client_cancel_end_session, data);
	return result;
}


static void _lib_session_session_client_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_lib_session_session_client_stop, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_lib_session_session_client_query_end_session, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_lib_session_session_client_end_session, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_lib_session_session_client_cancel_end_session, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void lib_session_register_with_session_data_free (gpointer _data) {
	LibSessionRegisterWithSessionData* _data_;
	_data_ = _data;
	_g_free0 (_data_->app_id);
	_g_object_unref0 (_data_->result);
	g_slice_free (LibSessionRegisterWithSessionData, _data_);
}


void lib_session_register_with_session (const gchar* app_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	LibSessionRegisterWithSessionData* _data_;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	_data_ = g_slice_new0 (LibSessionRegisterWithSessionData);
	_data_->_async_result = g_simple_async_result_new (NULL, _callback_, _user_data_, lib_session_register_with_session);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, lib_session_register_with_session_data_free);
	_tmp0_ = app_id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (_data_->app_id);
	_data_->app_id = _tmp1_;
	lib_session_register_with_session_co (_data_);
}


LibSessionSessionClient* lib_session_register_with_session_finish (GAsyncResult* _res_) {
	LibSessionSessionClient* result;
	LibSessionRegisterWithSessionData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void lib_session_register_with_session_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	LibSessionRegisterWithSessionData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	lib_session_register_with_session_co (_data_);
}


static gboolean lib_session_register_with_session_co (LibSessionRegisterWithSessionData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->path = NULL;
	_data_->msg = NULL;
	_data_->start_id = NULL;
	_data_->session = NULL;
	_data_->sclient = NULL;
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_getenv ("DESKTOP_AUTOSTART_ID");
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_strdup (_data_->_tmp0_);
	_g_free0 (_data_->start_id);
	_data_->start_id = _data_->_tmp1_;
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = _data_->start_id;
	if (_data_->_tmp2_ != NULL) {
		g_unsetenv ("DESKTOP_AUTOSTART_ID");
	} else {
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_strdup ("");
		_g_free0 (_data_->start_id);
		_data_->start_id = _data_->_tmp3_;
		g_message ("libsession.vala:50: DESKTOP_AUTOSTART_ID not set, session registration" \
" may be broken (not running budgie-desktop?)");
	}
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (LIB_SESSION_TYPE_SESSION_MANAGER_PROXY, 0, NULL, lib_session_register_with_session_ready, _data_, "g-flags", 0, "g-name", "org.gnome.SessionManager", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SessionManager", "g-interface-name", "org.gnome.SessionManager", "g-interface-info", g_type_get_qdata (LIB_SESSION_TYPE_SESSION_MANAGER, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_1:
		_data_->_tmp5_ = NULL;
		_data_->_tmp5_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp4_ = (LibSessionSessionManager*) _data_->_tmp5_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp6_ = NULL;
		_data_->_tmp6_ = _data_->_tmp4_;
		_data_->_tmp4_ = NULL;
		_g_object_unref0 (_data_->session);
		_data_->session = _data_->_tmp6_;
		_g_object_unref0 (_data_->_tmp4_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp7_ = NULL;
		_data_->_tmp7_ = _data_->e;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = _data_->_tmp7_->message;
		g_warning ("libsession.vala:56: Unable to connect to session manager: %s", _data_->_tmp8_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->sclient);
		_g_object_unref0 (_data_->session);
		_g_free0 (_data_->start_id);
		_g_free0 (_data_->msg);
		_g_free0 (_data_->path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->sclient);
		_g_object_unref0 (_data_->session);
		_g_free0 (_data_->start_id);
		_g_free0 (_data_->msg);
		_g_free0 (_data_->path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	{
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = _data_->session;
		_data_->_tmp11_ = NULL;
		_data_->_tmp11_ = _data_->app_id;
		_data_->_tmp12_ = NULL;
		_data_->_tmp12_ = _data_->start_id;
		_data_->_state_ = 2;
		lib_session_session_manager_RegisterClient (_data_->_tmp10_, _data_->_tmp11_, _data_->_tmp12_, lib_session_register_with_session_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = lib_session_session_manager_RegisterClient_finish (_data_->_tmp10_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp9_ = _data_->_tmp13_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = _data_->_tmp9_;
		_data_->_tmp9_ = NULL;
		_g_free0 (_data_->path);
		_data_->path = _data_->_tmp14_;
		_g_free0 (_data_->_tmp9_);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->_vala1_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp15_ = NULL;
		_data_->_tmp15_ = _data_->_vala1_e;
		_data_->_tmp16_ = NULL;
		_data_->_tmp16_ = _data_->_tmp15_->message;
		_data_->_tmp17_ = NULL;
		_data_->_tmp17_ = g_strdup (_data_->_tmp16_);
		_g_free0 (_data_->msg);
		_data_->msg = _data_->_tmp17_;
		_g_free0 (_data_->path);
		_data_->path = NULL;
		_g_error_free0 (_data_->_vala1_e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->sclient);
		_g_object_unref0 (_data_->session);
		_g_free0 (_data_->start_id);
		_g_free0 (_data_->msg);
		_g_free0 (_data_->path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = _data_->path;
	if (_data_->_tmp18_ == NULL) {
		_data_->_tmp20_ = NULL;
		_data_->_tmp20_ = _data_->msg;
		if (_data_->_tmp20_ != NULL) {
			_data_->_tmp21_ = NULL;
			_data_->_tmp21_ = _data_->msg;
			_data_->_tmp22_ = NULL;
			_data_->_tmp22_ = g_strdup_printf (": %s", _data_->_tmp21_);
			_g_free0 (_data_->_tmp19_);
			_data_->_tmp19_ = _data_->_tmp22_;
		} else {
			_data_->_tmp23_ = NULL;
			_data_->_tmp23_ = g_strdup ("");
			_g_free0 (_data_->_tmp19_);
			_data_->_tmp19_ = _data_->_tmp23_;
		}
		g_warning ("libsession.vala:67: Error registering with session manager%s", _data_->_tmp19_);
		_data_->result = NULL;
		_g_free0 (_data_->_tmp19_);
		_g_object_unref0 (_data_->sclient);
		_g_object_unref0 (_data_->session);
		_g_free0 (_data_->start_id);
		_g_free0 (_data_->msg);
		_g_free0 (_data_->path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	{
		_data_->_tmp25_ = NULL;
		_data_->_tmp25_ = _data_->path;
		_data_->_state_ = 3;
		g_async_initable_new_async (LIB_SESSION_TYPE_SESSION_CLIENT_PROXY, 0, NULL, lib_session_register_with_session_ready, _data_, "g-flags", 0, "g-name", "org.gnome.SessionManager", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", (const gchar*) _data_->_tmp25_, "g-interface-name", "org.gnome.SessionManager.ClientPrivate", "g-interface-info", g_type_get_qdata (LIB_SESSION_TYPE_SESSION_CLIENT, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_3:
		_data_->_tmp26_ = NULL;
		_data_->_tmp26_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp24_ = (LibSessionSessionClient*) _data_->_tmp26_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_data_->_tmp27_ = NULL;
		_data_->_tmp27_ = _data_->_tmp24_;
		_data_->_tmp24_ = NULL;
		_g_object_unref0 (_data_->sclient);
		_data_->sclient = _data_->_tmp27_;
		_g_object_unref0 (_data_->_tmp24_);
	}
	goto __finally2;
	__catch2_g_error:
	{
		_data_->_vala2_e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp28_ = NULL;
		_data_->_tmp28_ = _data_->_vala2_e;
		_data_->_tmp29_ = NULL;
		_data_->_tmp29_ = _data_->_tmp28_->message;
		g_warning ("libsession.vala:74: Unable to get Private Client proxy: %s", _data_->_tmp29_);
		_data_->result = NULL;
		_g_error_free0 (_data_->_vala2_e);
		_g_object_unref0 (_data_->sclient);
		_g_object_unref0 (_data_->session);
		_g_free0 (_data_->start_id);
		_g_free0 (_data_->msg);
		_g_free0 (_data_->path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally2:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		_g_object_unref0 (_data_->sclient);
		_g_object_unref0 (_data_->session);
		_g_free0 (_data_->start_id);
		_g_free0 (_data_->msg);
		_g_free0 (_data_->path);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	_data_->result = _data_->sclient;
	_g_object_unref0 (_data_->session);
	_g_free0 (_data_->start_id);
	_g_free0 (_data_->msg);
	_g_free0 (_data_->path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->sclient);
	_g_object_unref0 (_data_->session);
	_g_free0 (_data_->start_id);
	_g_free0 (_data_->msg);
	_g_free0 (_data_->path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}



