/* animation.c generated by valac 0.32.1, the Vala compiler
 * generated from animation.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
/**<Target value for end of animation */
/**<Used sometimes for switching an animation*/

#include <glib.h>
#include <glib-object.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>


#define BUDGIE_TYPE_ANIMATION (budgie_animation_get_type ())
#define BUDGIE_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_ANIMATION, BudgieAnimation))
#define BUDGIE_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_ANIMATION, BudgieAnimationClass))
#define BUDGIE_IS_ANIMATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_ANIMATION))
#define BUDGIE_IS_ANIMATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_ANIMATION))
#define BUDGIE_ANIMATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_ANIMATION, BudgieAnimationClass))

typedef struct _BudgieAnimation BudgieAnimation;
typedef struct _BudgieAnimationClass BudgieAnimationClass;

#define BUDGIE_TYPE_PROP_CHANGE (budgie_prop_change_get_type ())
typedef struct _BudgiePropChange BudgiePropChange;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BudgieAnimationPrivate BudgieAnimationPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;

typedef gdouble (*BudgieTweenFunc) (gdouble factor, void* user_data);
typedef void (*BudgieAnimCompletionFunc) (BudgieAnimation* src, void* user_data);
struct _BudgiePropChange {
	gchar* property;
	GValue old;
	GValue new;
};

struct _BudgieAnimation {
	GObject parent_instance;
	BudgieAnimationPrivate * priv;
	gint64 start_time;
	gint64 length;
	BudgieTweenFunc tween;
	gpointer tween_target;
	BudgiePropChange* changes;
	gint changes_length1;
	GtkWidget* widget;
	GObject* object;
	guint id;
	gboolean can_anim;
	gint64 elapsed;
	gboolean no_reset;
};

struct _BudgieAnimationClass {
	GObjectClass parent_class;
};

struct _Block1Data {
	int _ref_count_;
	BudgieAnimation* self;
	BudgieAnimCompletionFunc compl;
	gpointer compl_target;
};


static gpointer budgie_animation_parent_class = NULL;

GType budgie_animation_get_type (void) G_GNUC_CONST;
GType budgie_prop_change_get_type (void) G_GNUC_CONST;
BudgiePropChange* budgie_prop_change_dup (const BudgiePropChange* self);
void budgie_prop_change_free (BudgiePropChange* self);
void budgie_prop_change_copy (const BudgiePropChange* self, BudgiePropChange* dest);
void budgie_prop_change_destroy (BudgiePropChange* self);
enum  {
	BUDGIE_ANIMATION_DUMMY_PROPERTY
};
static void _vala_BudgiePropChange_array_free (BudgiePropChange* array, gint array_length);
void budgie_animation_start (BudgieAnimation* self, BudgieAnimCompletionFunc compl, void* compl_target);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda4_ (Block1Data* _data1_, GtkWidget* widget, GdkFrameClock* frame);
static gboolean ___lambda4__gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
void budgie_animation_stop (BudgieAnimation* self);
BudgieAnimation* budgie_animation_new (void);
BudgieAnimation* budgie_animation_construct (GType object_type);
static void budgie_animation_finalize (GObject* obj);
gdouble budgie_sine_ease_in_out (gdouble p);
gdouble budgie_sine_ease_in (gdouble p);
gdouble budgie_sine_ease_out (gdouble p);
gdouble budgie_elastic_ease_in (gdouble p);
gdouble budgie_elastic_ease_out (gdouble p);
gdouble budgie_back_ease_in (gdouble p);
gdouble budgie_back_ease_out (gdouble p);
gdouble budgie_expo_ease_in (gdouble p);
gdouble budgie_expo_ease_out (gdouble p);
gdouble budgie_quad_ease_in (gdouble p);
gdouble budgie_quad_ease_out (gdouble p);
gdouble budgie_quad_ease_in_out (gdouble p);
gdouble budgie_circ_ease_in (gdouble p);
gdouble budgie_circ_ease_out (gdouble p);
#define BUDGIE_MSECOND ((gint64) 1000)


void budgie_prop_change_copy (const BudgiePropChange* self, BudgiePropChange* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	GValue _tmp4_ = {0};
	GValue _tmp5_ = {0};
	_tmp0_ = (*self).property;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).property);
	(*dest).property = _tmp1_;
	_tmp2_ = (*self).old;
	if (G_IS_VALUE (&_tmp2_)) {
		g_value_init (&_tmp3_, G_VALUE_TYPE (&_tmp2_));
		g_value_copy (&_tmp2_, &_tmp3_);
	} else {
		_tmp3_ = _tmp2_;
	}
	G_IS_VALUE (&(*dest).old) ? (g_value_unset (&(*dest).old), NULL) : NULL;
	(*dest).old = _tmp3_;
	_tmp4_ = (*self).new;
	if (G_IS_VALUE (&_tmp4_)) {
		g_value_init (&_tmp5_, G_VALUE_TYPE (&_tmp4_));
		g_value_copy (&_tmp4_, &_tmp5_);
	} else {
		_tmp5_ = _tmp4_;
	}
	G_IS_VALUE (&(*dest).new) ? (g_value_unset (&(*dest).new), NULL) : NULL;
	(*dest).new = _tmp5_;
}


void budgie_prop_change_destroy (BudgiePropChange* self) {
	_g_free0 ((*self).property);
	G_IS_VALUE (&(*self).old) ? (g_value_unset (&(*self).old), NULL) : NULL;
	G_IS_VALUE (&(*self).new) ? (g_value_unset (&(*self).new), NULL) : NULL;
}


BudgiePropChange* budgie_prop_change_dup (const BudgiePropChange* self) {
	BudgiePropChange* dup;
	dup = g_new0 (BudgiePropChange, 1);
	budgie_prop_change_copy (self, dup);
	return dup;
}


void budgie_prop_change_free (BudgiePropChange* self) {
	budgie_prop_change_destroy (self);
	g_free (self);
}


GType budgie_prop_change_get_type (void) {
	static volatile gsize budgie_prop_change_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_prop_change_type_id__volatile)) {
		GType budgie_prop_change_type_id;
		budgie_prop_change_type_id = g_boxed_type_register_static ("BudgiePropChange", (GBoxedCopyFunc) budgie_prop_change_dup, (GBoxedFreeFunc) budgie_prop_change_free);
		g_once_init_leave (&budgie_prop_change_type_id__volatile, budgie_prop_change_type_id);
	}
	return budgie_prop_change_type_id__volatile;
}


static void _vala_BudgiePropChange_array_free (BudgiePropChange* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			budgie_prop_change_destroy (&array[i]);
		}
	}
	g_free (array);
}


/**
     * Start this animation by attaching ourselves to the GdkFrameClock
     *
     * @param compl A completion callback to execute when this animation completes
     */
static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		BudgieAnimation* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static gboolean __lambda4_ (Block1Data* _data1_, GtkWidget* widget, GdkFrameClock* frame) {
	BudgieAnimation* self;
	gboolean result = FALSE;
	gint64 time = 0LL;
	GdkFrameClock* _tmp0_ = NULL;
	gint64 _tmp1_ = 0LL;
	gfloat factor = 0.0F;
	gint64 elapsed = 0LL;
	gint64 _tmp2_ = 0LL;
	gint64 _tmp3_ = 0LL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gint64 _tmp6_ = 0LL;
	gint64 _tmp7_ = 0LL;
	gint64 _tmp27_ = 0LL;
	gint64 _tmp28_ = 0LL;
	gfloat _tmp29_ = 0.0F;
	BudgiePropChange* _tmp30_ = NULL;
	gint _tmp30__length1 = 0;
	GtkWidget* _tmp54_ = NULL;
	gboolean _tmp55_ = FALSE;
	self = _data1_->self;
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (frame != NULL, FALSE);
	_tmp0_ = frame;
	_tmp1_ = gdk_frame_clock_get_frame_time (_tmp0_);
	time = _tmp1_;
	factor = 0.0f;
	_tmp2_ = time;
	_tmp3_ = self->start_time;
	elapsed = _tmp2_ - _tmp3_;
	_tmp6_ = elapsed;
	_tmp7_ = self->length;
	if (_tmp6_ >= _tmp7_) {
		_tmp5_ = TRUE;
	} else {
		guint _tmp8_ = 0U;
		_tmp8_ = self->id;
		_tmp5_ = _tmp8_ == ((guint) 0);
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp9_ = FALSE;
		_tmp9_ = self->can_anim;
		_tmp4_ = !_tmp9_;
	}
	if (_tmp4_) {
		guint _tmp10_ = 0U;
		BudgieAnimCompletionFunc _tmp24_ = NULL;
		void* _tmp24__target = NULL;
		GtkWidget* _tmp26_ = NULL;
		_tmp10_ = self->id;
		if (_tmp10_ > ((guint) 0)) {
			BudgiePropChange* _tmp11_ = NULL;
			gint _tmp11__length1 = 0;
			_tmp11_ = self->changes;
			_tmp11__length1 = self->changes_length1;
			{
				BudgiePropChange* p_collection = NULL;
				gint p_collection_length1 = 0;
				gint _p_collection_size_ = 0;
				gint p_it = 0;
				p_collection = _tmp11_;
				p_collection_length1 = _tmp11__length1;
				for (p_it = 0; p_it < _tmp11__length1; p_it = p_it + 1) {
					BudgiePropChange _tmp12_ = {0};
					BudgiePropChange p = {0};
					budgie_prop_change_copy (&p_collection[p_it], &_tmp12_);
					p = _tmp12_;
					{
						GObject* _tmp13_ = NULL;
						_tmp13_ = self->object;
						if (_tmp13_ == NULL) {
							GtkWidget* _tmp14_ = NULL;
							BudgiePropChange _tmp15_ = {0};
							const gchar* _tmp16_ = NULL;
							BudgiePropChange _tmp17_ = {0};
							GValue _tmp18_ = {0};
							_tmp14_ = widget;
							_tmp15_ = p;
							_tmp16_ = _tmp15_.property;
							_tmp17_ = p;
							_tmp18_ = _tmp17_.new;
							g_object_set_property ((GObject*) _tmp14_, _tmp16_, &_tmp18_);
						} else {
							GObject* _tmp19_ = NULL;
							BudgiePropChange _tmp20_ = {0};
							const gchar* _tmp21_ = NULL;
							BudgiePropChange _tmp22_ = {0};
							GValue _tmp23_ = {0};
							_tmp19_ = self->object;
							_tmp20_ = p;
							_tmp21_ = _tmp20_.property;
							_tmp22_ = p;
							_tmp23_ = _tmp22_.new;
							g_object_set_property (_tmp19_, _tmp21_, &_tmp23_);
						}
						budgie_prop_change_destroy (&p);
					}
				}
			}
		}
		self->id = (guint) 0;
		self->can_anim = FALSE;
		_tmp24_ = _data1_->compl;
		_tmp24__target = _data1_->compl_target;
		if (_tmp24_ != NULL) {
			BudgieAnimCompletionFunc _tmp25_ = NULL;
			void* _tmp25__target = NULL;
			_tmp25_ = _data1_->compl;
			_tmp25__target = _data1_->compl_target;
			_tmp25_ (self, _tmp25__target);
		}
		_tmp26_ = widget;
		gtk_widget_queue_draw (_tmp26_);
		result = FALSE;
		return result;
	}
	_tmp27_ = elapsed;
	_tmp28_ = self->length;
	_tmp29_ = CLAMP (((gfloat) _tmp27_) / _tmp28_, (gfloat) 0, 1.0f);
	factor = _tmp29_;
	_tmp30_ = self->changes;
	_tmp30__length1 = self->changes_length1;
	{
		BudgiePropChange* c_collection = NULL;
		gint c_collection_length1 = 0;
		gint _c_collection_size_ = 0;
		gint c_it = 0;
		c_collection = _tmp30_;
		c_collection_length1 = _tmp30__length1;
		for (c_it = 0; c_it < _tmp30__length1; c_it = c_it + 1) {
			BudgiePropChange _tmp31_ = {0};
			BudgiePropChange c = {0};
			budgie_prop_change_copy (&c_collection[c_it], &_tmp31_);
			c = _tmp31_;
			{
				gdouble old = 0.0;
				gdouble _tmp32_ = 0.0;
				gdouble new = 0.0;
				gdouble _tmp33_ = 0.0;
				BudgieTweenFunc _tmp34_ = NULL;
				void* _tmp34__target = NULL;
				gdouble delta = 0.0;
				gdouble _tmp38_ = 0.0;
				gdouble _tmp39_ = 0.0;
				gfloat _tmp40_ = 0.0F;
				gdouble nprop = 0.0;
				gdouble _tmp41_ = 0.0;
				gdouble _tmp42_ = 0.0;
				GObject* _tmp43_ = NULL;
				_tmp32_ = g_value_get_double (&c.old);
				old = _tmp32_;
				_tmp33_ = g_value_get_double (&c.new);
				new = _tmp33_;
				_tmp34_ = self->tween;
				_tmp34__target = self->tween_target;
				if (_tmp34_ != NULL) {
					BudgieTweenFunc _tmp35_ = NULL;
					void* _tmp35__target = NULL;
					gfloat _tmp36_ = 0.0F;
					gdouble _tmp37_ = 0.0;
					_tmp35_ = self->tween;
					_tmp35__target = self->tween_target;
					_tmp36_ = factor;
					_tmp37_ = _tmp35_ ((gdouble) _tmp36_, _tmp35__target);
					factor = (gfloat) _tmp37_;
				}
				_tmp38_ = new;
				_tmp39_ = old;
				_tmp40_ = factor;
				delta = (_tmp38_ - _tmp39_) * _tmp40_;
				_tmp41_ = old;
				_tmp42_ = delta;
				nprop = (gdouble) (_tmp41_ + _tmp42_);
				_tmp43_ = self->object;
				if (_tmp43_ == NULL) {
					GtkWidget* _tmp44_ = NULL;
					BudgiePropChange _tmp45_ = {0};
					const gchar* _tmp46_ = NULL;
					gdouble _tmp47_ = 0.0;
					GValue _tmp48_ = {0};
					_tmp44_ = widget;
					_tmp45_ = c;
					_tmp46_ = _tmp45_.property;
					_tmp47_ = nprop;
					g_value_init (&_tmp48_, G_TYPE_DOUBLE);
					g_value_set_double (&_tmp48_, _tmp47_);
					g_object_set_property ((GObject*) _tmp44_, _tmp46_, &_tmp48_);
					G_IS_VALUE (&_tmp48_) ? (g_value_unset (&_tmp48_), NULL) : NULL;
				} else {
					GObject* _tmp49_ = NULL;
					BudgiePropChange _tmp50_ = {0};
					const gchar* _tmp51_ = NULL;
					gdouble _tmp52_ = 0.0;
					GValue _tmp53_ = {0};
					_tmp49_ = self->object;
					_tmp50_ = c;
					_tmp51_ = _tmp50_.property;
					_tmp52_ = nprop;
					g_value_init (&_tmp53_, G_TYPE_DOUBLE);
					g_value_set_double (&_tmp53_, _tmp52_);
					g_object_set_property (_tmp49_, _tmp51_, &_tmp53_);
					G_IS_VALUE (&_tmp53_) ? (g_value_unset (&_tmp53_), NULL) : NULL;
				}
				budgie_prop_change_destroy (&c);
			}
		}
	}
	_tmp54_ = widget;
	gtk_widget_queue_draw (_tmp54_);
	_tmp55_ = self->can_anim;
	result = _tmp55_;
	return result;
}


static gboolean ___lambda4__gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = __lambda4_ (self, widget, frame_clock);
	return result;
}


void budgie_animation_start (BudgieAnimation* self, BudgieAnimCompletionFunc compl, void* compl_target) {
	Block1Data* _data1_;
	BudgieAnimCompletionFunc _tmp0_ = NULL;
	void* _tmp0__target = NULL;
	gboolean _tmp1_ = FALSE;
	GtkWidget* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	g_return_if_fail (self != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = compl;
	_tmp0__target = compl_target;
	_data1_->compl = _tmp0_;
	_data1_->compl_target = _tmp0__target;
	_tmp1_ = self->no_reset;
	if (!_tmp1_) {
		gint64 _tmp2_ = 0LL;
		_tmp2_ = g_get_monotonic_time ();
		self->start_time = _tmp2_;
	}
	self->can_anim = TRUE;
	_tmp3_ = self->widget;
	_tmp4_ = gtk_widget_add_tick_callback (_tmp3_, ___lambda4__gtk_tick_callback, block1_data_ref (_data1_), block1_data_unref);
	self->id = _tmp4_;
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


/**
     * Stop a running animation
     */
void budgie_animation_stop (BudgieAnimation* self) {
	guint _tmp0_ = 0U;
	GtkWidget* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->id;
	if (_tmp0_ == ((guint) 0)) {
		return;
	}
	_tmp1_ = self->widget;
	_tmp2_ = self->id;
	gtk_widget_remove_tick_callback (_tmp1_, _tmp2_);
	self->can_anim = FALSE;
	self->id = (guint) 0;
}


BudgieAnimation* budgie_animation_construct (GType object_type) {
	BudgieAnimation * self = NULL;
	self = (BudgieAnimation*) g_object_new (object_type, NULL);
	return self;
}


BudgieAnimation* budgie_animation_new (void) {
	return budgie_animation_construct (BUDGIE_TYPE_ANIMATION);
}


static void budgie_animation_class_init (BudgieAnimationClass * klass) {
	budgie_animation_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = budgie_animation_finalize;
}


static void budgie_animation_instance_init (BudgieAnimation * self) {
}


static void budgie_animation_finalize (GObject* obj) {
	BudgieAnimation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_ANIMATION, BudgieAnimation);
	self->changes = (_vala_BudgiePropChange_array_free (self->changes, self->changes_length1), NULL);
	_g_object_unref0 (self->object);
	G_OBJECT_CLASS (budgie_animation_parent_class)->finalize (obj);
}


/**
 * Utility to struct to enable easier animations
 * Inspired by Clutter. 
 */
GType budgie_animation_get_type (void) {
	static volatile gsize budgie_animation_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_animation_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieAnimationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_animation_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieAnimation), 0, (GInstanceInitFunc) budgie_animation_instance_init, NULL };
		GType budgie_animation_type_id;
		budgie_animation_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieAnimation", &g_define_type_info, 0);
		g_once_init_leave (&budgie_animation_type_id__volatile, budgie_animation_type_id);
	}
	return budgie_animation_type_id__volatile;
}


gdouble budgie_sine_ease_in_out (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	_tmp0_ = p;
	_tmp1_ = cos (_tmp0_ * G_PI);
	result = 0.5 * (1 - _tmp1_);
	return result;
}


gdouble budgie_sine_ease_in (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	_tmp0_ = p;
	_tmp1_ = sin ((_tmp0_ - 1) * G_PI_2);
	result = _tmp1_ + 1;
	return result;
}


gdouble budgie_sine_ease_out (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	_tmp0_ = p;
	_tmp1_ = sin (_tmp0_ * G_PI_2);
	result = _tmp1_;
	return result;
}


gdouble budgie_elastic_ease_in (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	_tmp0_ = p;
	_tmp1_ = sin ((13 * G_PI_2) * _tmp0_);
	_tmp2_ = p;
	_tmp3_ = pow ((gdouble) 2, 10 * (_tmp2_ - 1));
	result = _tmp1_ * _tmp3_;
	return result;
}


gdouble budgie_elastic_ease_out (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	_tmp0_ = p;
	_tmp1_ = sin ((-13 * G_PI_2) * (_tmp0_ + 1));
	_tmp2_ = p;
	_tmp3_ = pow ((gdouble) 2, -10 * _tmp2_);
	result = (_tmp1_ * _tmp3_) + 1;
	return result;
}


gdouble budgie_back_ease_in (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	_tmp0_ = p;
	_tmp1_ = p;
	_tmp2_ = p;
	_tmp3_ = p;
	_tmp4_ = p;
	_tmp5_ = sin (_tmp4_ * G_PI);
	result = ((_tmp0_ * _tmp1_) * _tmp2_) - (_tmp3_ * _tmp5_);
	return result;
}


gdouble budgie_back_ease_out (gdouble p) {
	gdouble result = 0.0;
	gdouble f = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	_tmp0_ = p;
	f = 1 - _tmp0_;
	_tmp1_ = sin (f * G_PI);
	result = 1 - (((f * f) * f) - (f * _tmp1_));
	return result;
}


gdouble budgie_expo_ease_in (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	_tmp1_ = p;
	if (_tmp1_ == 0.0) {
		gdouble _tmp2_ = 0.0;
		_tmp2_ = p;
		_tmp0_ = _tmp2_;
	} else {
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		_tmp3_ = p;
		_tmp4_ = pow ((gdouble) 2, 10 * (_tmp3_ - 1));
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


gdouble budgie_expo_ease_out (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	_tmp1_ = p;
	if (_tmp1_ == 1.0) {
		gdouble _tmp2_ = 0.0;
		_tmp2_ = p;
		_tmp0_ = _tmp2_;
	} else {
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		_tmp3_ = p;
		_tmp4_ = pow ((gdouble) 2, -10 * _tmp3_);
		_tmp0_ = 1 - _tmp4_;
	}
	result = _tmp0_;
	return result;
}


gdouble budgie_quad_ease_in (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	_tmp0_ = p;
	_tmp1_ = p;
	result = _tmp0_ * _tmp1_;
	return result;
}


gdouble budgie_quad_ease_out (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	_tmp0_ = p;
	_tmp1_ = p;
	result = -(_tmp0_ * (_tmp1_ - 2));
	return result;
}


gdouble budgie_quad_ease_in_out (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	_tmp1_ = p;
	if (_tmp1_ < 0.5) {
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		_tmp2_ = p;
		_tmp3_ = p;
		_tmp0_ = (2 * _tmp2_) * _tmp3_;
	} else {
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		gdouble _tmp6_ = 0.0;
		_tmp4_ = p;
		_tmp5_ = p;
		_tmp6_ = p;
		_tmp0_ = (((-2 * _tmp4_) * _tmp5_) + (4 * _tmp6_)) - 1;
	}
	result = _tmp0_;
	return result;
}


gdouble budgie_circ_ease_in (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	_tmp0_ = p;
	_tmp1_ = p;
	_tmp2_ = sqrt (1 - (_tmp0_ * _tmp1_));
	result = 1 - _tmp2_;
	return result;
}


gdouble budgie_circ_ease_out (gdouble p) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	_tmp0_ = p;
	_tmp1_ = p;
	_tmp2_ = sqrt ((2 - _tmp0_) * _tmp1_);
	result = _tmp2_;
	return result;
}



