" Reply-helper for mutt with schleuder (>= v2.0.0)
function! SchleuderInsert(string)
  let fromline = search('> From:', 'n')
  let addr = matchstr(getline(fromline), '[^ <]*@[^ >]*')
  let insline = search('^$', 'n')
  " append after the first blank line
  let foo = append(insline, a:string . addr)
  " can't figure out how to append() a newline, so we simply add another
  " empty line
  return append(insline+1, '')
endfunction

function! SchleuderInsertResendEncrypted()
  return SchleuderInsert('X-RESEND-ENCRYPTED-ONLY: ')
endfunction

function! SchleuderInsertResend()
  return SchleuderInsert('X-RESEND: ')
endfunction

nmap ;sr :call SchleuderInsertResend()<CR>
nmap ;sc :call SchleuderInsertResendEncrypted()<CR>
