#ifndef PERFORMOUS_VIDEO_HH
#define PERFORMOUS_VIDEO_HH

#include "surface.hh"
#include "ffmpeg.hh"
#include <string>
       
class Video {
  public:
	Video(std::string const& videoFile);
	void render(double time);
	Dimensions& dimensions() { return m_surface.dimensions; }
	Dimensions const& dimensions() const { return m_surface.dimensions; }
  private:
	CFfmpeg m_mpeg;
	VideoFrame m_videoFrame;
	Surface m_surface;
	double m_surfaceTime;
	double m_lastTime;
	float m_alpha;
};

#endif

