/*******************************************************\
* irmp3-ncurses - An ncurses frontend for irmp3 using   *
* the Network Control Module                            *
* (C) 2005 Ross Axe                                     *
*                                                       *
* poll-select.c - I/O polling using select()            *
\*******************************************************/

#if HAVE_CONFIG_H
#  include "config.h"
#endif

#include "autosocket.h"

#include "irmp3-ncurses.h"

vcid("$Id: poll-select.c,v 1.5 2005/03/26 21:03:48 ross Exp $");


int main_poll_loop(int sock)
{
    for(;;) {
	fd_set fds;

	FD_ZERO(&fds);
	FD_SET(STDIN_FILENO, &fds);
	FD_SET(sock, &fds);
	if(-1 == select(max(STDIN_FILENO, sock) + 1, &fds,
			NULL, NULL, NULL)) {
	    if(errno == EINTR)
		continue;
	    sbar_printf(_("select() failed with error %s (%d)"),
			strerror(errno), errno);
	    error_sleep();
	    break;
	}
	if(FD_ISSET(sock, &fds) && !handle_net(sock))
	    break;
	if(FD_ISSET(fileno(stdin), &fds) && !key_callback(sock, getch()))
	    break;
    }

    return 0;
}
