#include "libcompat.h"

#include <stdio.h>
#include <string.h>

#include "autosocket.h"

const char *hstrerror(int err)
{
    switch(err) {
    case HOST_NOT_FOUND:
	return "The specified host is unknown";
    case NO_ADDRESS:
#if NO_DATA != NO_ADDRESS
    case NO_DATA:
#endif
	return "The requested name is valid but does not have an IP address";
    case NO_RECOVERY:
	return "A non-recoverable name server error occurred";
    case TRY_AGAIN:
	return "A temporary error occurred on an authoritative name server. "
	    "Try again later";
    default:
#if HAVE_STRERROR
	return strerror(err);
#else
	{
	    static char msg[1024];

	    sprintf(msg, "Unknown hostent error %d", err);
	    return msg;
	}
#endif
    }
}
