/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _PUSHBUTTON_H
#define _PUSHBUTTON_H

#include <wftk/button.h>

namespace wftk {

/** PushButton Class.
    In contrast to Button, this widgets changes its appereance
    when being pressed.
*/
class PushButton : public Button
{
 //OBJECT

 public:
  ///
  PushButton();
  /**
   * Constructor for a normal button.
   *\param text text that is written on the button, defaults to an empty string
   *\param font font to use for the text, defaults to "button_font"
   */
  explicit PushButton(const std::string& text,
		      const Font &font=Font::registry.find("button_font"));
  /**
   * destructor
   */
  virtual ~PushButton();
  /**
   * set the picture for the button in up position
   *\overload
   *\param bm a Surface::Resource containing the picture
   */
  void setUpPic(Surface::Resource* bm);
  /**
   * set the picture for the button in up position
   *\overload
   *\param surf the picture, as a surface reference now
   */
  void setUpPic(const Surface& surf);
  /**
   * set the picture for the button in up position
   *\param name a std::string containing the name of the registered resource
   */
  void setUpPic(const std::string& name);
  /**
   * set the picture for the button in down position
   *\overload
   *\param bm a Surface::Resource containing the picture
   */
  void setDownPic(Surface::Resource* bm);
  /**
   * set the picture for the button in down position
   *\overload
   *\param surf the picture, as a surface reference 
   */
  void setDownPic(const Surface& surf);
  /**
   * set the picture for the button in down position
   *\param name a std::string containing the name of the registered resource
   */
  void setDownPic(const std::string& name);

 protected:
  ///
  virtual void draw(Surface&, const Point&, const Region&);
 private:
  ///
  Surface::Resource* upPic_;
  ///
  Surface::Resource* downPic_;
  ///
  Color light_, dark_;
  ///
  void handlePressed() {if(upPic_ || downPic_) setBackground(downPic_, false);}
  ///
  void handleReleased() {if(upPic_ || downPic_) setBackground(upPic_, false);}
  ///
  bool noBackground() const {return !(isPressed() ? upPic_ : downPic_);}
  ///
  bool anyBackground() const {return upPic_ || downPic_;}

};

} // namespace wftk

#endif // _PUSHBUTTON_H
