/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "fixeddialog.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

void wftk::FixedDialog::handleResize(Uint16 w, Uint16 h)
{
  Widget::handleResize(w, h);

  if(child()) {
    Rect child_size(child_area_);
    const PackingInfo& child_info = child()->getPackingInfo();

    // things can break badly if we don't do this
    if(child_size.w < child_info.x.min)
      child_size.w = child_info.x.min;
    if(child_size.h < child_info.y.min)
      child_size.h = child_info.y.min;

    child()->resize(child_size);
  }
}
