/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#ifndef _BORDERED_DIALOG_H
#define _BORDERED_DIALOG_H

#include <wftk/dialog.h>
#include <wftk/font.h>

namespace wftk {

  /**
   * A dialog with decorative borders
   *
   * Subclass this class if you want to create your own dialog class.
   */
class BorderedDialog : public Dialog
{

 public:
  /**
   * Constructor
   *
   * Create a Dialog window.
   *\param title std::string containing the window title, defaults to ""
   *\param border_res_name std::string containing the name of the ressource
   *                       to use for the frame. The ressources are 
   *                       \li &lt;name&gt;_v for the vertical frames
   *                       \li &lt;name&gt;_h for the horizontal frames
   *                       \li &lt;name&gt;_edge for the corners
   *
   *                       If any of those ressources aren't found, it is left 
   *                       out.
   *\param font which font to use, defaults to Font::textFont()
   */
  explicit BorderedDialog(const std::string& title = "",
		  const std::string& border_res_name = "", 
		  const Font& font=Font::textFont());
  /**
   * Destructor
   */
  virtual ~BorderedDialog();

 protected:
  virtual void draw(Surface& target, const Point& dest, const Region& mask);

 private:
  unsigned vPad() const {return vPad_ > 5 ? 2 * vPad_ : 10;}
  unsigned hPad() const {return hPad_ > 5 ? 2 * hPad_ : 10;}

  Surface::Resource *hRes_, *vRes_, *cornerRes_;
  Surface* title_;
  unsigned hPad_, vPad_;
};


} // namespace wftk

#endif // !_DIALOG
