#!/usr/local/bin/perl
# edit_configs.cgi
# Display the configs for a usermin module

require './usermin-lib.pl';
require '../config-lib.pl';
$access{'configs'} || &error($text{'acl_ecannot'});
&ReadParse();
&can_use_module($in{'mod'}) || &error($text{'configs_ecannot'});
&ui_print_header(undef, $text{'configs_title2'}, "");
&get_usermin_miniserv_config(\%miniserv);

&read_file("$config{'usermin_dir'}/$in{'mod'}/config", \%mconfig);
if (-r "$miniserv{'root'}/$in{'mod'}/config.info") {
	# Display config form for the module
	%minfo = &get_usermin_module_info($in{'mod'});
	print "<form action=\"save_configs.cgi\" method=post>\n";
	print "<input type=hidden name=mod value=\"$in{'mod'}\">\n";
	print "<table border>\n";
	print "<tr $tb> <td><b>",&text('config_header', $minfo{'desc'}),
	      "</b></td> </tr>\n";
	print "<tr $cb> <td><table width=100%>\n";

	# Use config.info to create config inputs
	&generate_config(\%mconfig, "$miniserv{'root'}/$in{'mod'}/config.info");
	print "</table></td></tr></table>\n";
	print "<input type=submit value=\"$text{'save'}\"></form>\n";
	}

if (-r "$miniserv{'root'}/$in{'mod'}/config.info" &&
    -r "$miniserv{'root'}/$in{'mod'}/uconfig.info") {
	print "<hr>\n";
	}

if (-r "$miniserv{'root'}/$in{'mod'}/uconfig.info") {
	# Display default user config form for the module
	%minfo = &get_usermin_module_info($in{'mod'});
	print "<form action=\"save_uconfigs.cgi\" method=post>\n";
	print "<input type=hidden name=mod value=\"$in{'mod'}\">\n";
	print "<table border>\n";
	print "<tr $tb> <td><b>",&text('configs_uheader', $minfo{'desc'}),
	      "</b></td> </tr>\n";
	print "<tr $cb> <td><table width=100%>\n";
	&read_file("$miniserv{'root'}/$in{'mod'}/defaultuconfig", \%uconfig);
	&read_file("$config{'usermin_dir'}/$in{'mod'}/uconfig", \%uconfig);

	print "<tr> <td valign=top><b>$text{'configs_prefs'}</b></td> <td>\n";
	printf "<input type=radio name=noprefs value=0 %s> %s\n",
		$mconfig{'noprefs'} ? "" : "checked", $text{'yes'};
	printf "<input type=radio name=noprefs value=1 %s> %s</td> </tr>\n",
		$mconfig{'noprefs'} ? "checked" : "", $text{'no'};
	print "<tr> <td colspan=2><hr></td> </tr>\n";

	# Use uconfig.info to create config inputs
	&generate_config(\%uconfig,"$miniserv{'root'}/$in{'mod'}/uconfig.info");
	print "</table></td></tr></table>\n";
	print "<input type=submit value=\"$text{'save'}\"></form>\n";
	}

&ui_print_footer("list_configs.cgi", $text{'configs_return'});

