#!/usr/local/bin/perl
# restart_slave.cgi
# Restart named on a remote server

require './bind8-lib.pl';
&ReadParse();
%access = &get_module_acl();
$access{'ro'} && &error($text{'restart_ecannot'});
$access{'apply'} || &error($text{'restart_ecannot'});
$access{'remote'} || &error($text{'restart_ecannot'});

# Find the PID file
&remote_foreign_require($in{'slave'}, "bind8", "bind8-lib.pl");
$sver = &remote_foreign_call($in{'slave'}, "bind8", "get_webmin_version");
if ($sver >= 1.140) {
	# Call new function to get PID file from slave
	$pidfile = &remote_foreign_call($in{'slave'}, "bind8", "get_pid_file");
	$pidfile = &remote_foreign_call($in{'slave'}, "bind8",
					"make_chroot", $pidfile, 1);
	}
else {
	# Argh .. fall back to using old method
	$sconfig = &remote_foreign_config($in{'slave'}, "bind8");
	$sconf = &remote_foreign_call($in{'slave'}, "bind8", "get_config");
	if (($opts = &find("options", $sconf)) &&
	    ($pidopt = &find("pid-file", $opts->{'members'}))) {
		# read from PID file
		$pidfile = $pidopt->{'value'};
		if ($pidfile !~ /^\//) {
			local $dir = &find("directory", $opts->{'members'});
			$pidfile = $dir->{'value'}."/".$pidfile;
			}
		}
	else {
		# use default file
		$pidfile = $sconfig->{'pid_file'} ? $sconfig->{'pid_file'}
						  : "/var/run/named.pid";
		}
	}

# Read the PID and restart
$pid = &remote_eval($in{'slave'}, "bind8", <<EOF
open(PID, '$pidfile');
chop(\$pid = <PID>);
close(PID);
return \$pid;
EOF
);
$pid || &error($text{'restart_erunning'});
$err = &remote_eval($in{'slave'}, "bind8", "kill('HUP', $pid) ? undef : \$!");
$err && &error(&text('restart_esig', $pid, $err));
&redirect("");

