/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#include "xmms-info.h"
#include "utils.h"
#include "main.h"

#include <glib.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

static gpointer func(gpointer data);


static gboolean enabled = FALSE;
static GThread *thr;

void xmms_info_enable(gboolean enable, guint32 s)
{
  GError *err = NULL;

  if(enable)
  {
    if(enabled)
      return;
    thr = g_thread_create(func, NULL, FALSE, &err);
  }
  else
  {
    enabled = FALSE;
  }
}

gchar *xmms_info_playing()
{
  int fd;
  GIOChannel *ch;
  GError *err = NULL;
  char *s, *ret = NULL;
  gsize l, pos;
  gboolean playing = FALSE;


  fd = open(XMMS_PIPE, O_RDONLY);
  if(fd == -1)
  {
//    g_warning("cannot open file '%s' for reading\n", XMMS_PIPE);
    return NULL;
  }
  ch = g_io_channel_unix_new(fd);
  if(!ch)
  {
//    g_warning("cannot create io channel\n");
    close(fd);
    return NULL;
  }
  err = NULL;
  while(g_io_channel_read_line(ch, &s, &l, &pos, &err)
        == G_IO_STATUS_NORMAL)
  {
    if(!s)
      break;
    if(!g_ascii_strcasecmp(s, "Status: Playing\n"))
      playing = TRUE;
    else if(!g_ascii_strncasecmp(s, "Title: ", 7))
      if(playing)
      {
//        g_message("playing: %s\n", s+7);
        gchar c = s[pos];

        if(c == '\n')
          s[pos] = '\0';
        ret = g_strdup(s+7);
        if(c == '\n')
          s[pos] = '\n';
      }
    g_free(s);
  }
  err = NULL;
  g_io_channel_shutdown(ch, FALSE, &err);
  return ret;
}

void xmms_info_check()
{
  func(NULL);
}

static gpointer func(gpointer data)
{
  gchar *s, *u;

  enabled = TRUE;
  while(1)
  {
    if(!enabled)
    {
      g_free(desc_xmms);
      desc_xmms = NULL;
      return NULL;
    }
    u = xmms_info_playing();
    if(!u)
    {
      g_free(desc_xmms);
      desc_xmms = NULL;
    }
    else
    {
      s = fromutf(u);
      g_free(u);
      if(!desc_xmms || g_ascii_strcasecmp(desc_xmms, s))
      {
        g_free(desc_xmms);
        desc_xmms = s;
      }
    }
    sleep(4);
  }
  return NULL;;
}

