/*
** TleenX2 (Tlen.pl Client)
** Copyright (c) 2002-2003 Hubert Sokoowski <who_ami@tlen.pl>
**                         Pawe Biliski <rael@fr.pl>
**
** This code is free software; you can redistribute it and/or
** modify it under the terms of the GNU General Public License.
**
*/


#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "gg.h"

static char gg_base64_charset[] =
  "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";


static char *base64_decode(const char *buf)
{
  char *res, *save, *foo, val;
  const char *end;
  int index = 0;

  if (!buf)
    return NULL;

  save = res = calloc(1, (strlen(buf) / 4 + 1) * 3 + 2);

  if (!save)
    return NULL;

  end = buf + strlen(buf);

  while (*buf && buf < end) {
    if (*buf == '\r' || *buf == '\n') {
      buf++;
      continue;
    }
    if (!(foo = strchr(gg_base64_charset, *buf)))
      foo = gg_base64_charset;
    val = (int)(foo - gg_base64_charset);
    buf++;
    switch (index) {
      case 0:
        *res |= val << 2;
        break;
      case 1:
        *res++ |= val >> 4;
        *res |= val << 4;
        break;
      case 2:
        *res++ |= val >> 2;
        *res |= val << 6;
        break;
      case 3:
        *res++ |= val;
        break;
    }
    index++;
    index %= 4;
  }
  *res = 0;

  return save;
}



gchar *gg_read_conf(gint var)
{
  FILE *f;
  gchar *fname, *s=NULL;
  gchar val[40], v[40];

  fname = g_strdup_printf("%s/.gg/config", getenv("HOME"));
  f = fopen(fname, "r");
  g_free(fname);
  if(!f)
    return NULL;
  fscanf(f, "%s %s\n", val, v);
  switch(var)
  {
    case GG_CONF_NUMBER:
      s = g_strdup(v);
      break;
    case GG_CONF_PASSWORD:
      fscanf(f, "%s %s\n", val, v);
      s = base64_decode(v+1);
      break;
  }
  fclose(f);
  return s;
}
