// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIR_SliceName.hh"
#include "IIR_ConcurrentGenerateForStatement.hh"
#include "IIR_ConstantDeclaration.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_Label.hh"
#include "IIR_RangeAttribute.hh"
#include "set.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_SliceName::~IIRScram_SliceName() {}


void 
IIRScram_SliceName::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  ASSERT(get_prefix()->_is_resolved() == TRUE);
  ASSERT(get_suffix() != NULL);
  ASSERT(get_suffix()->_is_resolved() == TRUE);

  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << " ( ";
  get_suffix()->_publish_vhdl_range(_vhdl_out);
  _vhdl_out << " ) ";
}


// We handle slice names as aliases.  An implicit alias of the prefix with
// the corresponding range is created and used as the slice.
void
IIRScram_SliceName::_publish_cc_lvalue( published_file &_cc_out ) {
  ASSERT(_is_resolved() == TRUE);

  get_prefix()->_publish_cc_lvalue( _cc_out );
  _cc_out << ".getSlice(ArrayInfo(";
  get_suffix()->_publish_cc_range( _cc_out );
  _cc_out << "))";
}


void
IIRScram_SliceName::_publish_cc_object_name( published_file &_cc_out ) {
  get_prefix()->_publish_cc_lvalue( _cc_out );
}


void
IIRScram_SliceName::_publish_cc_slice_name_as_for_loop( published_file &_cc_out ) {
  IIR_ScalarTypeDefinition *range;
  IIR_ScalarTypeDefinition *generate_range;
  IIR_ConcurrentGenerateForStatement *generate_for;

  // Work around for bad aire tree. Once the parser is fixed to give the
  // right iir node .ie. index name, this work around can be removed.
  // The necessary code is already in indexed name.

  if (get_suffix()->_is_iir_scalar_type_definition() == FALSE) {
    if ((get_suffix()->get_kind() == IIR_RANGE_ATTRIBUTE) ||
	(get_suffix()->get_kind() == IIR_REVERSE_RANGE_ATTRIBUTE)) {
      IIR_Attribute* attr = (IIR_Attribute *) get_suffix();
      attr->_publish_cc_as_for_loop( _cc_out, "generateConstant" );
    }
    else {
      _cc_out << "for(int generateConstant = ";
      get_suffix()->_publish_cc_value( _cc_out );
      _cc_out << "; (generateConstant == ";
      get_suffix()->_publish_cc_value( _cc_out );
      _cc_out << "); generateConstant++)\n";
    }
    return;
  }
    
  ASSERT ( get_prefix()->_is_concurrent_generate_statement() == TRUE );
  ASSERT ( get_prefix()->get_kind() == IIR_LABEL );
  ASSERT ( ((IIR_Label *) get_prefix())->get_statement()->get_kind() == IIR_CONCURRENT_GENERATE_FOR_STATEMENT );
  ASSERT ( get_suffix()->_is_iir_scalar_type_definition() == TRUE );
  
  range          = (IIR_ScalarTypeDefinition *) get_suffix();
  generate_for   = (IIR_ConcurrentGenerateForStatement *) ((IIR_Label *) get_prefix())->get_statement();
  generate_range = (IIR_ScalarTypeDefinition *) generate_for->get_generate_parameter_specification()->get_subtype();
  
  _cc_out << "for(int generateConstant = ";
  
  if (range->_is_ascending_range()) {
    _cc_out << "(";
    range->get_left()->_publish_cc_value( _cc_out );
    _cc_out << " - ";
    generate_range->get_left()->_publish_cc_value( _cc_out );
    _cc_out << ");";

    _cc_out << "(generateConstant <=";
  }
  else {
    _cc_out << "(";
    generate_range->get_left()->_publish_cc_value( _cc_out );
    _cc_out << " - ";
    range->get_left()->_publish_cc_value( _cc_out );
    _cc_out << ");";
    
    _cc_out << "(generateConstant >";
  }
  
  if (range->_is_ascending_range()) {
    _cc_out << "(";
    
    range->get_right()->_publish_cc_value( _cc_out );
    _cc_out << " - ";
    generate_range->get_left()->_publish_cc_value( _cc_out );
    _cc_out << ")";
  }
  else {
    _cc_out << "(";

    generate_range->get_left()->_publish_cc_value( _cc_out );
    _cc_out << " - ";
    range->get_right()->_publish_cc_value( _cc_out );
    _cc_out << ")";
  }

  _cc_out << "); generateConstant++)\n";
}


void
IIRScram_SliceName::_publish_cc_declarator( published_file &_cc_out ) {
  get_prefix()->_publish_cc_declarator( _cc_out );
}

void
IIRScram_SliceName::_publish_cc_name_elaborate( published_file &_cc_out ) {
  get_prefix()->_publish_cc_elaborate( _cc_out );
}


void
IIRScram_SliceName::_publish_cc_range( published_file &_cc_out ) {
  ASSERT(_is_resolved() == TRUE);
  get_suffix()->_publish_cc_range( _cc_out );
}


void
IIRScram_SliceName::_publish_cc_bounds( published_file &_cc_out ) {
  _cc_out << "ArrayInfo(";
  _publish_cc_range( _cc_out );
  _cc_out << ")";
}


void
IIRScram_SliceName::_publish_cc_elaborate( published_file &_cc_out ){
  get_prefix()->_publish_cc_elaborate( _cc_out );
  _cc_out << ".getSlice(ArrayInfo(";
  get_suffix()->_publish_cc_range( _cc_out );
  _cc_out << "))";
}


void
IIRScram_SliceName::_add_decl_into_cgen_symbol_table() {
  get_prefix()->_add_decl_into_cgen_symbol_table();
  get_suffix()->_add_decl_into_cgen_symbol_table();
}


IIR_Declaration*
IIRScram_SliceName::_get_prefix_declaration() {
  return get_prefix()->_get_prefix_declaration();
}

IIR_Mode
IIRScram_SliceName::_get_mode() {
  return get_prefix()->_get_mode();
}

set<IIR_TypeDefinition> *
IIRScram_SliceName::_get_rval_set(IIR_Boolean (IIR::*constraint_function)()){
  if( get_subtype() == NULL ){
    return get_prefix()->_get_rval_set( constraint_function );
  }
  else{
    return new set<IIR_TypeDefinition>( get_subtype() );
  }
}

void 
IIRScram_SliceName::_type_check( set<IIR_TypeDefinition> * ){
  ASSERT( _is_resolved() == TRUE );
}


IIR_Boolean 
IIRScram_SliceName::_is_readable(){
  return get_prefix()->_is_readable();
}


IIR_Boolean 
IIRScram_SliceName::_is_writable(){
  return get_prefix()->_is_writable();
}


IIR_Boolean 
IIRScram_SliceName::_is_variable(){
  return get_prefix()->_is_variable();
}


IIR_Boolean
IIRScram_SliceName::_is_concurrent_generate_statement() {
  return get_prefix()->_is_concurrent_generate_statement();
}


IIR_Boolean 
IIRScram_SliceName::_is_resolved(){
  IIR_Boolean retval = TRUE;
  if( get_prefix()->_is_resolved() == FALSE || get_suffix()->_is_resolved() == FALSE ){
    retval = FALSE;
  }

  return retval;
}


IIR_TypeDefinition*
IIRScram_SliceName::_get_name_type() {
  return get_prefix()->get_subtype();
}


void 
IIRScram_SliceName::_make_interface_visible( symbol_table *sym_tab ){
  ASSERT( get_prefix()->_is_iir_label() == TRUE );
  get_prefix()->_make_interface_visible( sym_tab );
}


IIR_List *
IIRScram_SliceName::_get_statement_list(){
  ASSERT( get_prefix()->_is_iir_label() == TRUE );
  return get_prefix()->_get_statement_list();
}


ostream &
IIRScram_SliceName::_print( ostream &os ){
  os << *get_prefix();
  os << "(";
  os << *get_suffix();
  os << ")";

  return os;
}

void 
IIRScram_SliceName::_set_subtype( IIR_TypeDefinition *new_subtype ){
  my_subtype = new_subtype;
}


IIR_TypeDefinition *
IIRScram_SliceName::get_subtype(){
  return my_subtype;
}


IIR *
IIRScram_SliceName::_clone(){
  IIR_SliceName *retval = new IIR_SliceName();
  IIR_Name::_clone( retval );
  retval->set_prefix( get_prefix()->_clone() );
  retval->set_suffix( get_suffix()->_clone() );

  retval->my_subtype = my_subtype;
  retval->_implicit_decls = _implicit_decls;
  
  return retval;
}


IIR *
IIRScram_SliceName::_get_suffix(){
  ASSERT(get_suffix() != NULL);
  return get_suffix();
}


IIR_Declaration *
IIRScram_SliceName::_find_formal_declaration(){
  ASSERT( _is_resolved() == TRUE );
  ASSERT( get_suffix() != NULL );
  ASSERT( get_suffix()->get_kind() != IIR_ASSOCIATION_LIST || 
	  ((IIR_AssociationList *)get_suffix())->num_elements() == 1 );
  return get_prefix()->_find_formal_declaration();
}

IIR_Boolean 
IIRScram_SliceName::_is_globally_static_primary(){
  ASSERT( get_prefix() != NULL );
  ASSERT( get_suffix() != NULL );
  ASSERT( _is_resolved() == TRUE );

  if( get_prefix()->_is_globally_static() == TRUE && get_suffix()->_is_globally_static() ){
    return TRUE;
  }
  else{
    return FALSE;
  }
}

visitor_return_type *
IIRScram_SliceName::_accept_visitor( node_visitor *visitor, 
				     visitor_argument_type *arg ){
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_SliceName(this, arg);
}
