
#ifndef IIRSCRAM_SIMULTANEOUS_ELSIF_HH
#define IIRSCRAM_SIMULTANEOUS_ELSIF_HH

// Copyright (c) 2002-2003 The University of Cincinnati.
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Harish Venkataramani venkath@ececs.uc.edu

#include "IIRBase_SimultaneousElsif.hh"
#include "IIR_ArchitectureStatement.hh"
#include "IIR_Declaration.hh"
#include "set.hh"

class IIR_TypeDefinition;

/** This class selects for evaluation one of the enclosed simultaneous
    statement parts depending on the value of one or more conditions. */
class IIRScram_SimultaneousElsif : public IIRBase_SimultaneousElsif {
public:

  /** @name Method for publishing VHDL code. */
  void _publish_vhdl(ostream &);

  /** @name C++ publishing methods.
      These methods relate to the publishing of C++.*/
  void _publish_cc(published_file &);

  /** Function that publishes the characteristic expression
      corresponding to the condition specified in the Elsif Statement.
      @see IIRScram_SimpleSimultaneousStatement#_publish_cc_characteristic_expressions */
  void _publish_cc_characteristic_expressions(IIRScram_ArchitectureStatement::
                                              SimultaneousIfPublishingPart,published_file &);

  /** Function that calls the Simultaneous Statement's
      _publish_cc_ams_function_prototype for each of the
      statements in the If part and the else part.*/
  void _publish_cc_ams_function_prototype(published_file &);

  /** Function that calls the Simultaneous Statement's
      _publish_cc_ams_function_body for each of the
      statements in the If part and the else part.*/
  void _publish_cc_ams_function_body(published_file &);
  void _type_check(set<IIR_TypeDefinition> *);

  IIR_Int32 _stmt_qty_index;
  IIR_Int32 _stmt_signal_index;

  set<IIR_Declaration> _unique_qtys;
  set<IIR_Declaration> _unique_signals;
  set<IIR_Declaration> _unique_generic_constants;
  
protected:
  IIRScram_SimultaneousElsif() {};
  virtual ~IIRScram_SimultaneousElsif() = 0;

private:

};
#endif

