
#ifndef IIRSCRAM_SIGNAL_DECLARATION_HH
#define IIRSCRAM_SIGNAL_DECLARATION_HH

// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Malolan Chetlur     
//          Timothy J. McBrayer 
//          Krishnan Subramani  
//          Umesh Kumar V. Rajasekaran
//          Radharamanan Radhakrishnan
//          Narayanan Thondugulam

#include "IIRBase_SignalDeclaration.hh"

class IIR_List;
template <class type> class set;
class IIR_TypeDefinition;
class IIR_DesigantorList;
class IIR_SignalDeclaration;
class IIR_AboveAttribute;

class IIRScram_SignalDeclaration : public IIRBase_SignalDeclaration {

public:
  /// Accept visitations \Ref{_accept_visitor}.
  visitor_return_type* _accept_visitor(node_visitor *, visitor_argument_type *);

  void _publish_vhdl_decl(ostream &);
  IIR_SignalKind _get_signal_kind();
  
  void _publish_cc_lvalue( published_file &_cc_out );
  void _publish_cc_value ( published_file &_cc_out );
  void _publish_cc_decl( published_file &_cc_out );
  void _publish_cc_sigdest( published_file &_cc_out );
  void _publish_cc_init( published_file &_cc_out );
  void _publish_cc_data( published_file &_cc_out );
  void _publish_cc_elaborate( published_file &_cc_out );
  void _publish_cc_wait_data( published_file &_cc_out );
  void _publish_cc_state_object_init( published_file &_cc_out );
  const string _get_cc_object_type();
  void _publish_cc_initialization_value( published_file &_cc_out ) { _publish_cc_lvalue( _cc_out ); }
  void _publish_cc_include(published_file &_cc_out);

  IIR_Boolean _is_guard_signal();
  
  //This function publishes the implicit signal attributes
  //that are in scope for "this" declaration
  //  void _publish_cc_implicit_signal_attributes( published_file &_cc_out );
  IIR_Boolean _is_iir_signal_declaration(){ return TRUE; }
  IIR_Boolean _is_signal(){ return TRUE; }
  IIR_Boolean _is_readable(){ return TRUE; }
  IIR_Boolean _is_writable(){ return TRUE; }


  IIR_Boolean _have_added_driver() {
    return _driver_addition_flag;
  }

  void _set_driver_addition_flag(IIR_Boolean val) {
    _driver_addition_flag = val;
  }

  IIR_Boolean _is_passed_through_out_port() {
    return _passed_through_out_port;
  }

  void _set_passed_through_out_port(IIR_Boolean val) {
    _passed_through_out_port = val;
  }
  
  virtual void _publish_cc_necessary_copying( published_file &_cc_out );
  virtual void _publish_cc_read_or_write( published_file &_cc_out,
					  const string &, 
					  const string & );
  
  declaration_type _get_type();
  IIR_Declaration* _get_signal_decl();
  
  IIR *_clone();

  IIR_Boolean _is_above_attribute_found();
  void _publish_cc_ams_function(published_file &);
  void _build_above_attribute_set(set<IIR_AboveAttribute> *);
  void _publish_cc_init_for_ams(published_file &);
  void _publish_cc_init_signal_for_ams(published_file &);

  /** For some reason, sometimes the code generate wants a fresh clone
     generated.  */
  void _clear_clone(){ _my_clone = 0; }
  
  void _set_stmt_signal_index(IIR_Int32 *, set<IIR_Declaration> *);
  IIR_Int32 _get_stmt_signal_index() {return _stmt_signal_index;}
  void _flush_stmt_index();

protected:
  IIRScram_SignalDeclaration();
  virtual ~IIRScram_SignalDeclaration() = 0;
  
private:
  IIR_Boolean _driver_addition_flag;
  IIR_Boolean _passed_through_out_port;
  IIR_SignalDeclaration *_my_clone;
  IIR_Int32 _stmt_signal_index;
};
#endif





