// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIR_SRAOperator.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_SRAOperator::~IIRScram_SRAOperator() {}

void 
IIRScram_SRAOperator::_publish_vhdl_operator(ostream &_vhdl_out) {
  _vhdl_out << " sra ";
}

const string &
IIRScram_SRAOperator::_get_cc_operator_name() const {
  static const string operator_name = "vhdlSra";
  return operator_name;
}

IIR*
IIRScram_SRAOperator::_clone() {
  IIR_SRAOperator *clone = new IIR_SRAOperator();
  IIRScram_DyadicOperator::_clone(clone);
  return clone;
}

IIRScram::OperatorPrecedenceLevel
IIRScram_SRAOperator::_get_operator_precedence(){
  return IIRScram::SHIFT_OPERATOR;
}

visitor_return_type *
IIRScram_SRAOperator::_accept_visitor( node_visitor *visitor, 
				       visitor_argument_type *arg ){
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_SRAOperator(this, arg);
}
