// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIRScram_ReverseRangeAttribute.hh"
#include "IIR_AscendingAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_LeftAttribute.hh"
#include "IIR_RightAttribute.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_TypeDeclaration.hh"
#include "error_func.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "savant.hh"
#include "published_file.hh"

IIRScram_ReverseRangeAttribute::~IIRScram_ReverseRangeAttribute() {}

void 
IIRScram_ReverseRangeAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'REVERSE_RANGE ";

  if (get_suffix() != NULL) {
    _vhdl_out << "(";
    get_suffix()->_publish_vhdl(_vhdl_out);
    _vhdl_out << ") ";
  }
}

void
IIRScram_ReverseRangeAttribute::_publish_vhdl_range(ostream& _vhdl_out) {
  _publish_vhdl(_vhdl_out);
}

void 
IIRScram_ReverseRangeAttribute::_publish_cc_range( published_file &_cc_out ) {
  ASSERT(get_prefix() != NULL);

  IIR_LeftAttribute *left_attr = new IIR_LeftAttribute();
  copy_location( this, left_attr );
  left_attr->set_prefix(get_prefix());
  left_attr->set_suffix(get_suffix());
  
  IIR_AscendingAttribute *ascending_attr = new IIR_AscendingAttribute();
  copy_location( this, ascending_attr );
  ascending_attr->set_prefix(get_prefix());
  ascending_attr->set_suffix(get_suffix());

  IIR_RightAttribute *right_attr = new IIR_RightAttribute();
  copy_location( this, right_attr );
  right_attr->set_prefix(get_prefix());
  right_attr->set_suffix(get_suffix());

  right_attr->_publish_cc_value( _cc_out );
  _cc_out << ", ((";
  ascending_attr->_publish_cc_lvalue( _cc_out ) ;
  _cc_out << " == SAVANT_BOOLEAN_TRUE)? ArrayInfo::downto : ArrayInfo::to), ";
  left_attr->_publish_cc_value( _cc_out );

  delete left_attr;
  delete ascending_attr;
  delete right_attr;
  ASSERT(get_prefix() != NULL);	// Debug
}


IIR_TextLiteral *
IIRScram_ReverseRangeAttribute::_build_attribute_name() {
  char *name = "reverserange";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_TypeDefinition *
IIRScram_ReverseRangeAttribute::get_subtype(){
  return _get_subtype_range_attribute();
}


IIR_Declaration *
IIRScram_ReverseRangeAttribute::_get_implicit_declaration( const string &decl_name,
							   IIR_TypeDefinition * ){
  // This is copied (and modified) from IIR_RangeAttribute...
  IIR_TypeDefinition *prefix_rval = _get_prefix_subtype( &IIR::_is_array_type );
  return _build_type_declaration( decl_name, prefix_rval );
}


IIR_TypeDefinition *
IIRScram_ReverseRangeAttribute::_get_prefix_rval(){
  return _get_prefix_rval_range_attributes();
}


IIR *
IIRScram_ReverseRangeAttribute::_get_suffix(){
  return get_suffix();
}

void 
IIRScram_ReverseRangeAttribute::_resolve_suffix_special(){
  _resolve_suffix_local_static_int();
}

visitor_return_type *
IIRScram_ReverseRangeAttribute::_accept_visitor( node_visitor *visitor, 
						 visitor_argument_type *arg ){
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ReverseRangeAttribute(this, arg);
}
