// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIR_RecordTypeDefinition.hh"
#include "IIR_ElementDeclaration.hh"
#include "IIR_ScalarTypeDefinition.hh"
#include "IIR_FunctionDeclaration.hh"
#include "symbol_table.hh"
#include "resolution_func.hh"
#include "error_func.hh"
#include "savant.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


IIRScram_RecordTypeDefinition::IIRScram_RecordTypeDefinition(){
}

IIRScram_RecordTypeDefinition::~IIRScram_RecordTypeDefinition(){
}


void 
IIRScram_RecordTypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  _vhdl_out << "\nrecord\n ";
  element_declarations._publish_vhdl(_vhdl_out);
  _vhdl_out << "\nend record";
}

void 
IIRScram_RecordTypeDefinition::_publish_vhdl_subtype_decl(ostream &_vhdl_out) {
  if(_get_resolution_function() != NULL) {
    _get_resolution_function()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " ";
  }
  
  // The base type can be NULL if I have:
  // type foo is record
  //               first_element : string;
  //             end record;
  //

  // subtype bar is foo;

  // (if you don't believe the base type is NULL in this case, read page 53,
  // the paragraph at the top of the page.

  if( get_base_type() != NULL ){
    get_base_type()->_publish_vhdl(_vhdl_out);
  }
  else{
    ASSERT( _get_declaration() != NULL );
    _get_declaration()->_publish_vhdl(_vhdl_out);
  }
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_decl_type_attributes( published_file & ){}

IIR_TypeDefinition * 
IIRScram_RecordTypeDefinition::_get_element_subtype( int index ){
  IIR_TypeDefinition *retval = NULL;

  ASSERT( index <= element_declarations.num_elements() );

  IIR_ElementDeclaration *element_decl;
  
  element_decl = element_declarations.get_nth_element( index );
  retval = element_decl->get_subtype();

  return retval;
}

IIR_Boolean 
IIRScram_RecordTypeDefinition::_is_subtype(){
  // This is to make up for no IIR_RecordSubtypeDefinition
  if( get_base_type() == NULL ){
    return false;
  }
  else{
    return true;
  }
}

set<IIR_Declaration> *
IIRScram_RecordTypeDefinition::_find_declarations( IIR_Name *to_find ){
  return element_declarations._find_declarations( to_find );
}

void
IIRScram_RecordTypeDefinition::_publish_cc_necessary_decl_in_state( published_file &_cc_out ) {
  // The value of _current_publish_name should be set to the variable's
  // name that is being published. The control drops here usually from
  // IIRScram_EventAttribute
  
  _cc_out << _get_cc_type_name();
  _cc_out << "_event ";
  _cc_out << _get_current_publish_name();
  _cc_out << "_event;" << NL();

  _cc_out << _get_cc_type_name();
  _cc_out << "_last_event ";
  _cc_out << _get_current_publish_name();
  _cc_out << "_last_event;" << NL();
}

void
IIRScram_RecordTypeDefinition::_publish_cc_init_fields_for_signals( published_file & ){}

const string
IIRScram_RecordTypeDefinition::_get_cc_kernel_type(){
  return "RecordType";
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_constructor_args( published_file & ){}

void 
IIRScram_RecordTypeDefinition::_publish_cc_element_objtypes( published_file &_cc_out ){
  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    fields->_get_declarator()->_publish_cc_lvalue( _cc_out );
    _cc_out << "(objType";
    if (fields->get_subtype()->_is_kernel_type() == FALSE &&
	fields->get_subtype()->_is_anonymous() == FALSE &&
	fields->get_subtype()->_is_scalar_type() == TRUE){
      fields->get_subtype()->_publish_cc_object_type_info( _cc_out );
    }
    if (fields->get_subtype()->_is_array_type() == TRUE)  {
      // Argh!...but, only for now...
      _cc_out << ", TypeInfo::getNullTypeInfo()";
      
      if (fields->get_subtype()->_is_anonymous() == TRUE) {
	_cc_out << ", ";
	fields->get_subtype()->_publish_cc_range( _cc_out );
      }
    }
    
    _cc_out << ")";
    
    fields = element_declarations.successor(fields);
    if(fields != NULL) {
      _cc_out << ",\n";
    }
  }
  _cc_out <<" {\n";
  _cc_out << " numberOfFields = ";
  _cc_out << element_declarations.num_elements() << ";\n";
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_element_objtypes_event( published_file &_cc_out ){
  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    fields->_get_declarator()->_publish_cc_lvalue( _cc_out );
    _cc_out << "(object";
    
    if (fields->get_subtype()->_is_array_type() == TRUE) {
      // Argh!!, but only for now...
      _cc_out << ", ";
      fields->get_subtype()->_publish_cc_object_type_info( _cc_out, FALSE );
      _cc_out << ", -1";
      
      if (fields->get_subtype()->_is_anonymous() == TRUE) {
	_cc_out << ", ";
	fields->get_subtype()->_publish_cc_range( _cc_out );
      }
    }
    
    _cc_out << ")";
    
    fields = element_declarations.successor(fields);
    if(fields != NULL) {
      _cc_out << ",\n";
    }
  }
}

void
IIRScram_RecordTypeDefinition::_publish_cc_extern_type_info( published_file &_cc_out ) {
  char *externFlag = "";
  
  if ((_get_currently_publishing_unit() == PACKAGE_PUB) ||
      (_get_currently_publishing_unit() == PACKAGE_BODY)) {
    externFlag = "  extern";
  }

  _cc_out << externFlag << "  RecordTypeInfo ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "_info;\n";

  _cc_out << externFlag << "  RecordTypeInfo ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "_event_info;\n";

  _cc_out << externFlag << "  RecordTypeInfo ";
  _publish_cc_lvalue( _cc_out );
  _cc_out << "_lastevent_info;\n";
  
}

void
IIRScram_RecordTypeDefinition::_publish_cc_type_info( published_file &_cc_out ) {
  _publish_cc_type_info( _cc_out, NULL, NULL );
  
  if( _get_currently_publishing_unit() == PROCEDURE ||
      _get_currently_publishing_unit() == FUNCTION  ||
      _get_currently_publishing_unit() == PACKAGE_BODY ||
      _get_currently_publishing_unit() == PACKAGE_PUB ){
    _cc_out << ";\n";
  }
  else {
    _cc_out << ",\n";
  }
  
  _publish_cc_type_info( _cc_out, "_event", "SavantbooleanType_info" );

  if( _get_currently_publishing_unit() == PROCEDURE ||
      _get_currently_publishing_unit() == FUNCTION  ||
      _get_currently_publishing_unit() == PACKAGE_BODY ||
      _get_currently_publishing_unit() == PACKAGE_PUB ){
    _cc_out << ";\n";
  }
  else {
    _cc_out << ",\n";
  }
  
  _publish_cc_type_info( _cc_out, "_lastevent", "SavanttimeType_info" );  
}

void
IIRScram_RecordTypeDefinition::_publish_cc_type_info( published_file &_cc_out,
						      char *suffix, 
						      char  *elementTypeInfo) {
  SCRAM_CC_REF( _cc_out, "IIRScram_RecordTypeDefinition::_publish_cc_type_info" );
   
  if( _get_currently_publishing_unit() == PROCEDURE ||
      _get_currently_publishing_unit() == FUNCTION  ||
      _get_currently_publishing_unit() == PACKAGE_BODY ||
      _get_currently_publishing_unit() == PACKAGE_PUB ){
    _cc_out << "  RecordTypeInfo ";
  }
  else {
    _cc_out << "  ";
  }
  
  _publish_cc_lvalue( _cc_out );
  if (suffix != NULL) {
    _cc_out << suffix;
  }
  
  _cc_out << "_info(" << element_declarations.num_elements() << ", ";

  _cc_out << ((_is_resolved_type() == TRUE) ? "true" : "false")
	  << ", ";
  _publish_cc_resolution_function_id( _cc_out );

  IIR_ElementDeclaration *fields = element_declarations.first();
  while (fields != NULL) {
    _cc_out << ", ";
    
    if (fields->_is_scalar_type() == TRUE && elementTypeInfo != NULL ) {
      SCRAM_CC_REF( _cc_out, "IIRScram_RecordTypeDefinition::_publish_cc_type_info" );
      _cc_out << "&";
      _cc_out << elementTypeInfo;
    }
    else {
      SCRAM_CC_REF( _cc_out, "IIRScram_RecordTypeDefinition::_publish_cc_type_info" );

      if (fields->get_subtype()->_is_iir_access_type_definition() == FALSE) {
	if ((fields->get_subtype()->_is_array_type() == TRUE) &&
	    (fields->get_subtype()->_is_anonymous() == TRUE)) {
	  _cc_out << "new ";
	}
	else {
	  _cc_out << "&";
	}
	
	fields->get_subtype()->_publish_cc_object_type_info( _cc_out,
							     FALSE, 
							     suffix, 
							     TRUE);
      }
      else {
	_cc_out << "SavantaccessType_info";
      }
    }
    fields = element_declarations.successor(fields);
  }

  _cc_out << ")";
  
  if ((_get_currently_publishing_unit() == PACKAGE_BODY) ||
      (_get_currently_publishing_unit() == PACKAGE_PUB)) {
    _cc_out << ";\n";
  }	
}

int
IIRScram_RecordTypeDefinition::_get_field_number(IIR *searchField) {
  // Obtain the declarator for the field. 

  IIR_TextLiteral* decl = searchField->_get_declarator();
  ASSERT ( decl != NULL );
  
  int fieldNumber = 1;
  IIR_ElementDeclaration *field = element_declarations.first();
  
  while (field != NULL) {
    if (IIR_TextLiteral::_cmp(decl, field->_get_declarator()) == 0) {
      return fieldNumber;
    }
    fieldNumber++;
    field = element_declarations.successor(field);
  }

  return -1;
}

IIR_Boolean
IIRScram_RecordTypeDefinition::_has_access_type() {
  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    if(fields->get_subtype()->_has_access_type() == TRUE) {
      return TRUE;;
    }
    fields = element_declarations.successor(fields);
  }
  return FALSE;
}

void
IIRScram_RecordTypeDefinition::_publish_cc_headers( published_file &_cc_out ) {

  IIR_ElementDeclaration* fields;
  fields = element_declarations.first();
  while(fields != NULL) {
    fields->_publish_cc_include( _cc_out );
    fields = element_declarations.successor(fields);
  }
  _publish_cc_include( _cc_out, "tyvis/RecordType.hh" );
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_init_signal( published_file &_cc_out ) {
  ostringstream tmpname;
  ostringstream tmpanothername;
  ostringstream tmpsuffixname;
  
  const string tmpPtr1 = _get_current_publish_name();
  const string tmpPtr2 = _get_current_another_name();
  const string tmpPtr3 = _get_current_suffix_name();
  IIR_ElementDeclaration* element_decls;
  
  _cc_out << OS("{");//begin dummy block for scoping
  element_decls = element_declarations.first();

  int field_index = 1;
  while(element_decls != NULL) {
    _set_current_another_name( tmpPtr2 );
    _set_current_publish_name( tmpPtr1 );
    _set_current_suffix_name( tmpPtr3 );
    
    _cc_out << OS("{"); // begin dummy block for scoping
    
    tmpanothername << _get_current_another_name() << "."
		   << *element_decls->_get_declarator();
    tmpname << _get_current_publish_name() << "."
	    << *element_decls->_get_declarator();
    
    _set_current_publish_name( tmpname.str() );
    _set_current_another_name( tmpanothername.str() );
    
    if (element_decls->get_subtype()->_is_record_type())  {
      const string temp_current_publish_name = _get_current_publish_name();
      const string temp_current_another_name = _get_current_another_name();
      const string temp_current_suffix_name  = _get_current_suffix_name();
      
      ostringstream tmpname;
      ostringstream tmpanothername;
      ostringstream tmpsuffixname;
      
      tmpname << _get_current_publish_name();
      tmpanothername << _get_current_another_name();
      if( _get_current_suffix_name() != "" ){
	tmpsuffixname << _get_current_suffix_name() << "."
		      << *element_decls->_get_declarator();
      }
      else {
	tmpsuffixname << "." << *(element_decls->_get_declarator());
      }
      
      _set_current_publish_name( tmpname.str() );
      _set_current_another_name( tmpanothername.str() );
      _set_current_suffix_name( tmpsuffixname.str() );
      
      element_decls->get_subtype()->_publish_cc_init_signal( _cc_out );

      _set_current_publish_name( temp_current_publish_name );
      _set_current_another_name( temp_current_another_name );
      _set_current_suffix_name ( temp_current_suffix_name );
    }
    else {
      if ( _get_current_suffix_name() != "" ){
	tmpsuffixname << _get_current_suffix_name()
		      << "." << *element_decls->_get_declarator();
      }
      else {
	tmpsuffixname << "." << *element_decls->_get_declarator();
      }

      _set_current_suffix_name( tmpsuffixname.str() );
	  
      element_decls->get_subtype()->_publish_cc_init_signal( _cc_out );
    }
    
    _cc_out << CS("}"); // code block for dummy scoping
    
    field_index++;
    element_decls = element_declarations.successor(element_decls);
  }

  _cc_out << CS("}");//end scoping block
  _set_current_publish_name( tmpPtr1 );
  _set_current_another_name( tmpPtr2 );
  _set_current_suffix_name( tmpPtr3 );
}

void 
IIRScram_RecordTypeDefinition::_publish_cc_composite_init( published_file &_cc_out ) {
  ostringstream tmpname;

  const string tmpPtr1 = _get_current_publish_name();

  IIR_ElementDeclaration* element_decls;
  _cc_out << "{\n";//begin dummy block for scoping
  element_decls = element_declarations.first();

  int field_index = 1;
  while(element_decls != NULL) {

    tmpname << tmpPtr1 << ".get_field(" << field_index << ")";
    _set_current_publish_name( tmpname.str() );

    // Need this check to adjust _current_publish_name when
    // recursively publishing fields

    if (element_decls->get_subtype()->get_kind() == IIR_RECORD_TYPE_DEFINITION) {
      ostringstream tempname;
      
      tempname << "(*((";
      if (element_decls->get_subtype()->_is_scalar_type() == FALSE) {
	tempname << element_decls->get_subtype()->_get_cc_type_name();
      }
      else {
	tempname << "ScalarType";
      }
      
      tempname << " *) &" << _get_current_publish_name() << "))";
      
      _set_current_publish_name( tempname.str() );
      
      element_decls->get_subtype()->_publish_cc_composite_init( _cc_out );
      
      _set_current_publish_name( tmpname.str() );
    }
    else {
      element_decls->get_subtype()->_publish_cc_composite_init( _cc_out );
    }
    
    tmpname.seekp(0);

    field_index++;
    element_decls = element_declarations.successor(element_decls);
  }

  _cc_out << "};\n";//end dummy block
  _set_current_publish_name( tmpPtr1 );
}

void
IIRScram_RecordTypeDefinition::_publish_cc_universal_type( published_file &_cc_out ){
  _cc_out << _get_cc_type_name();
}

void
IIRScram_RecordTypeDefinition::_publish_cc_constructor_args_type_info( published_file &_cc_out,
								       IIR *initializer ){
  _publish_cc_constructor_args_type_info_composite_type( _cc_out,
							 initializer );
}

const string
IIRScram_RecordTypeDefinition::_get_cc_type_name(){
  return "RecordType";
}

IIR_ScalarTypeDefinition*
IIRScram_RecordTypeDefinition::_get_index_subtype(){
  return NULL;
}

ostream &
IIRScram_RecordTypeDefinition::_print( ostream &os ){
  os << "record ";

  IIR_ElementDeclaration *current_decl = element_declarations.first();

  if( current_decl != NULL ){
    os << *current_decl << " : " << *current_decl->get_subtype()->_get_declarator();
    
    current_decl = element_declarations.successor( current_decl );
    while( current_decl != NULL ){
      os << ", " << *current_decl << " : " << *current_decl->get_subtype()->_get_declarator();
      current_decl = element_declarations.successor( current_decl );
    }
  }

  os << " end record";

  return os;
}

IIR_TypeDefinition *
IIRScram_RecordTypeDefinition::_construct_new_subtype( IIR_Name *resolution_function,
						       IIR_ScalarTypeDefinition *new_constraint ){

  IIR_TypeDefinition *retval;

  retval = _construct_new_subtype_resolution_function_only( resolution_function );
  if( new_constraint != 0 ){
    ostringstream err;
    err << "Constraints may not be applied to record types.";
    report_error( this, err.str() );
  }

  return retval;
}

IIR_TypeDefinition *
IIRScram_RecordTypeDefinition::_get_new_subtype(){
  IIR_TypeDefinition *retval = new IIR_RecordTypeDefinition();
  copy_location( this, retval );
  return retval;
}

void 
IIRScram_RecordTypeDefinition::_type_check(){
  if( get_resolution_function() != NULL ){
    get_resolution_function()->_type_check_resolution_function( this );
  }
  IIR_TypeDefinition::_type_check();
}

void 
IIRScram_RecordTypeDefinition::_clone( IIR *copy_into ){
  ASSERT( copy_into->_is_iir_record_type_definition() == TRUE );
  IIR_RecordTypeDefinition *as_record_type = (IIR_RecordTypeDefinition *)copy_into;

  as_record_type->_set_declaration( _get_declaration() );
  as_record_type->_set_type_mark( _get_type_mark() );
  as_record_type->set_resolution_function( get_resolution_function() );
  // This copies the elements over.
  as_record_type->element_declarations = element_declarations;
  // This should take care of anything else:
  IIR_TypeDefinition::_clone( copy_into );
}

IIR *
IIRScram_RecordTypeDefinition::_clone(){
  IIR_RecordTypeDefinition *retval;
  IIR_TypeDefinition *temp = _get_new_subtype();

  ASSERT( temp->_is_iir_record_type_definition() == TRUE );
  retval = (IIR_RecordTypeDefinition *)temp;

  _clone( retval );

  ASSERT( retval->element_declarations.num_elements() == element_declarations.num_elements() );
  ASSERT( retval->get_kind() == get_kind() );

  return retval;
}

void 
IIRScram_RecordTypeDefinition::_make_interface_visible( symbol_table *sym_tab ){
  sym_tab->make_visible( &element_declarations );
}

IIR_Boolean 
IIRScram_RecordTypeDefinition::_is_locally_static(){
  IIR_Boolean retval = TRUE;

  IIR_ElementDeclaration *current_decl = element_declarations.first();
  while( current_decl != NULL ){
    ASSERT( current_decl->get_subtype() != NULL );
    if( current_decl->get_subtype()->_is_locally_static() == FALSE ){
      retval = FALSE;
      break;
    }
    current_decl = element_declarations.successor( current_decl );
  }

  return retval;
}

IIR_Boolean 
IIRScram_RecordTypeDefinition::_is_globally_static(){
  IIR_Boolean retval = TRUE;

  IIR_ElementDeclaration *current_decl = element_declarations.first();
  while( current_decl != NULL ){
    ASSERT( current_decl->get_subtype() != NULL );
    if( current_decl->get_subtype()->_is_globally_static() == FALSE ){
      retval = FALSE;
      break;
    }
    current_decl = element_declarations.successor( current_decl );
  }

  return retval;
}


void 
IIRScram_RecordTypeDefinition::_come_into_scope( symbol_table *sym_tab, 
						 IIR_TypeDeclaration *td ){
  sym_tab->get_in_scope_record_types()->add( (IIR_RecordTypeDefinition *)this );
  IIR_TypeDefinition::_come_into_scope( sym_tab, td );
}

void 
IIRScram_RecordTypeDefinition::_come_out_of_scope( symbol_table *sym_tab ){
  sym_tab->get_in_scope_record_types()->remove( (IIR_RecordTypeDefinition *)this );
}

visitor_return_type *IIRScram_RecordTypeDefinition::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_RecordTypeDefinition(this, arg);
};
