// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcbraye@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu

//---------------------------------------------------------------------------

#include "IIRScram_RangeTypeDefinition.hh"
#include "IIR_Declaration.hh"
#include "IIR_EnumerationLiteral.hh"
#include "IIR_Identifier.hh"
#include "error_func.hh"
#include "savant.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


IIRScram_RangeTypeDefinition::~IIRScram_RangeTypeDefinition() {}

void 
IIRScram_RangeTypeDefinition::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_left() != NULL && get_right() != NULL);

  _publish_vhdl_constraint(_vhdl_out);
}

void 
IIRScram_RangeTypeDefinition::_publish_vhdl_decl(ostream &_vhdl_out) {
  if (get_left() == NULL && get_right() == NULL) {
    // unconstrained array...
    get_base_type()->_get_declaration()->get_declarator()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " range <>";
  }
  else {
    _vhdl_out << "range ";
    _publish_vhdl_constraint(_vhdl_out);
  }
}


void
IIRScram_RangeTypeDefinition::_publish_vhdl_constraint(ostream &_vhdl_out) {
  if (get_left() == NULL && get_right() == NULL) {
    // unconstrained array...
    get_base_type()->_get_declaration()->get_declarator()->_publish_vhdl(_vhdl_out);
    _vhdl_out << " range <>";
  }
  else {
    ASSERT(get_left() != NULL && get_right() != NULL);
    ASSERT(get_direction()->get_kind() == IIR_ENUMERATION_LITERAL);
    
    get_left()->_publish_vhdl(_vhdl_out);
    if( _is_ascending_range() == TRUE ){
      _vhdl_out << " to ";
    }
    else {
      _vhdl_out << " downto ";
    }
    get_right()->_publish_vhdl(_vhdl_out);
  }
}

void 
IIRScram_RangeTypeDefinition::_publish_cc_range( published_file &_cc_out ) {
  ASSERT(get_left() != NULL && get_right() != NULL);
  get_left()->_publish_cc_universal_value( _cc_out );
  _cc_out << "," << NL();
  ASSERT(get_direction()->get_kind() == IIR_ENUMERATION_LITERAL);
  if( _is_ascending_range() == TRUE ){
    _cc_out << "ArrayInfo::to," << NL();
  }
  else {
    _cc_out << "ArrayInfo::downto," << NL();
  }
  get_right()->_publish_cc_universal_value( _cc_out );
}

void 
IIRScram_RangeTypeDefinition::_publish_cc_array_info( published_file &_cc_out ){
  ASSERT(get_left() != NULL && get_right() != NULL);
  _cc_out << "ArrayInfo" << OS("(");
  _publish_cc_range( _cc_out );
  _cc_out << CS(")");
}

void 
IIRScram_RangeTypeDefinition::_publish_cc_bounds( published_file &_cc_out ) {
  _publish_cc_array_info( _cc_out );
}

void 
IIRScram_RangeTypeDefinition::_publish_cc_universal_type( published_file &_cc_out ) {
  _cc_out << "UniversalInteger";
}

const string
IIRScram_RangeTypeDefinition::_get_cc_kernel_type(){
  return "IntegerType";
}

IIR_TypeDefinition *
IIRScram_RangeTypeDefinition::_get_new_subtype(){
  ostringstream err;

  err << "Internal error - IIRScram_RangeTypeDefinition::_get_new_subtype() called.";
  err << "This shouldn't happen...";

  report_error( this, err.str() );
  abort();

  return NULL;
}

void 
IIRScram_RangeTypeDefinition::_set_resolution_function( IIR_FunctionDeclaration * ){
  ostringstream err;
  err << "Internal error - IIRScram_RangeTypeDefinition::_set_resolution_function was "
      << "called.  Resolution functions can't be associated with an access type and this "
      << "should have been caught earlier.";
  report_error( this, err.str() );
}


visitor_return_type *
IIRScram_RangeTypeDefinition::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_RangeTypeDefinition(this, arg);
};
