// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Timothy J. McBrayer tmcrbaye@ece.uc.edu
//          Radharamanan Radhakrishnan  ramanan@ece.uc.edu
//          Krishnan Subramani  skrish@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu

//---------------------------------------------------------------------------
#include "IIR_LastValueAttribute.hh"
#include "IIR_Identifier.hh"
#include "IIR_SignalDeclaration.hh"
#include "IIR_TypeDefinition.hh"
#include "IIR_FunctionDeclaration.hh"
#include "symbol_table.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "published_file.hh"

extern symbol_table *cgen_sym_tab_ptr;

IIRScram_LastValueAttribute::~IIRScram_LastValueAttribute() {}

void 
IIRScram_LastValueAttribute::_publish_vhdl(ostream &_vhdl_out) {
  ASSERT(get_prefix() != NULL);
  ASSERT(get_prefix()->_is_resolved() == TRUE);
  ASSERT(get_prefix()->_is_signal() == TRUE);

  get_prefix()->_publish_vhdl(_vhdl_out);
  _vhdl_out << "'LAST_VALUE ";
}

IIR_Boolean 
IIRScram_LastValueAttribute::_is_readable(){
  return get_prefix()->_is_readable();
}

IIR_TypeDefinition *
IIRScram_LastValueAttribute::get_subtype(){
  return _get_prefix_subtype( &IIR::_is_signal );
}

set<IIR_TypeDefinition> *
IIRScram_LastValueAttribute::_get_rval_set(IIR_Boolean (IIR::*constraint_function)()){
  set<IIR_TypeDefinition> *retval;

  retval = get_prefix()->_get_rval_set(constraint_function);

  return retval;
}

IIR_TextLiteral *
IIRScram_LastValueAttribute::_build_attribute_name() {
  char *name = "last_value";
  return IIR_Identifier::get( name, strlen(name) );
}

IIR_Declaration *
IIRScram_LastValueAttribute::_get_implicit_declaration( const string &decl_name,
							IIR_TypeDefinition *decl_type ){ 

  return _build_function_declaration( decl_name, decl_type );
}

void 
IIRScram_LastValueAttribute::_publish_cc_lvalue( published_file &_cc_out ) {
  _cc_out << "(";
  _cc_out << get_subtype()->_get_cc_type_name();
  _cc_out << " &)";
  
  _cc_out << "*(";
  _publish_cc_signal_attribute( _cc_out, "LastValue" );
  _cc_out << ")";
}

void
IIRScram_LastValueAttribute::_publish_cc_necessary_decl_in_state( published_file &_cc_out ) {
  _publish_cc_necessary_signal_decl_in_state( _cc_out, LAST_VALUE, "_last_value" );
}

// Initialization value of the signal, in UserState::initstate()
void
IIRScram_LastValueAttribute::_publish_cc_init_val( published_file &_cc_out ) { 
  _cc_out << "UniversalInteger(0)";
}

void
IIRScram_LastValueAttribute::_publish_cc_name_in_caps( published_file &_cc_out ) {
  _cc_out << "LAST_VALUE";
}

// Used in State::initialize for attribute[#].value.time
void
IIRScram_LastValueAttribute::_publish_cc_attrib_type( published_file &_cc_out ) {
  _cc_out << "function";
}

void
IIRScram_LastValueAttribute::_publish_cc_elaborate( published_file &_cc_out ){
  ASSERT( get_prefix() != NULL );
  ASSERT(get_prefix()->_is_resolved() == TRUE );
  ASSERT(get_prefix()->_is_signal() == TRUE );

  get_prefix()->_publish_cc_elaborate( _cc_out );
  _cc_out << "_last_value";
}

void
IIRScram_LastValueAttribute::_publish_cc_sigtype( published_file &_cc_out ) {
  _cc_out << "I_LAST_VALUE";
}

void
IIRScram_LastValueAttribute::_publish_cc_state_object_init( published_file &_cc_out ) {
  _publish_cc_necessary_signal_state_object_init( _cc_out, LAST_VALUE, "_last_value" );
}

void
IIRScram_LastValueAttribute::_publish_cc_neccessary_decl_init( published_file &_cc_out ) {
  _publish_cc_necessary_signal_init( _cc_out, LAST_VALUE, "_last_value" );
}

void
IIRScram_LastValueAttribute::_publish_cc_necessary_copying( published_file &_cc_out ) {
  _publish_cc_necessary_attribute_copying( _cc_out, LAST_VALUE, "_last_value");
}

void
IIRScram_LastValueAttribute::_publish_cc_read_or_write( published_file &_cc_out, 
							const string &fName, 
							const string &sName) {
  _publish_cc_attribute_read_or_write( _cc_out, LAST_VALUE, "_last_value", fName, sName );
}


IIR *
IIRScram_LastValueAttribute::_clone() {
  IIR_LastValueAttribute *clone = new IIR_LastValueAttribute;
  IIR_Attribute::_clone( clone );
  return clone;
}

visitor_return_type *IIRScram_LastValueAttribute::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_LastValueAttribute(this, arg);
};
