// Copyright (c) 1996-2000 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.


// You may modify, distribute, and use the software contained in this package
// under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE" version 2,
// June 1991. A copy of this license agreement can be found in the file
// "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	phil.wilsey@uc.edu
//          Dale E. Martin	dmartin@ece.uc.edu
//          Malolan Chetlur     mal@ece.uc.edu
//          Umesh Kumar V. Rajasekaran urajasek@ece.uc.edu
//          Narayanan Thondugulam nthondug@ece.uc.edu
//          Magnus Danielson    cfmd@swipnet.se

//---------------------------------------------------------------------------
#include "IIR_FloatingSubtypeDefinition.hh"
#include "IIR_IntegerSubtypeDefinition.hh"
#include "IIR_FloatingPointLiteral.hh"
#include "StandardPackage.hh"
#include "error_func.hh"
#include "published_file.hh"
#include "sstream-wrap.hh"


IIRScram_FloatingTypeDefinition::~IIRScram_FloatingTypeDefinition() {}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_decl_cc( published_file &_cc_out ) {
  _publish_cc_define_type_attributes( _cc_out );
}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_left( published_file &_cc_out ) {
  ASSERT(get_left() != NULL);
  
  get_left()->_publish_cc_lvalue( _cc_out );
}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_right( published_file &_cc_out ) {
  ASSERT(get_right() != NULL);

  get_right()->_publish_cc_lvalue( _cc_out );
}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_universal_type( published_file &_cc_out ) {
  _cc_out << "UniversalReal";
}

const string
IIRScram_FloatingTypeDefinition::_get_cc_kernel_type(){
  return "RealType";
}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_data_members( published_file &_cc_out ) {
  //I have nothing to do here.
  //But I stop system from crying undefined function blah, blah, blah...
}

IIR_TypeDefinition *
IIRScram_FloatingTypeDefinition::_check_special_compatible( IIR_TypeDefinition *to_check ){
  if( ((IIR_FloatingTypeDefinition *)this == StandardPackage::get_savant_universal_real() &&
       to_check->_is_floating_type() == TRUE )
      ||
      (IIR_FloatingTypeDefinition *)to_check == StandardPackage::get_savant_universal_real() ){
    return StandardPackage::get_savant_universal_real();
  }
  else{
    return NULL;
  }
}

void 
IIRScram_FloatingTypeDefinition::_publish_cc_type_info( published_file &_cc_out ) {
  SCRAM_CC_REF( _cc_out, "IIRScram_FloatingTypeDefinition::_publish_cc_type_info" );
  
  ASSERT (_is_scalar_type() == TRUE);

  if( _get_currently_publishing_unit() == PROCEDURE ||
      _get_currently_publishing_unit() == FUNCTION  ||
      _get_currently_publishing_unit() == PACKAGE_BODY ||
      _get_currently_publishing_unit() == PACKAGE_PUB ){
    _cc_out << "  RealTypeInfo ";
  }
  else {
    _cc_out << "  ";
  }
  
  _publish_cc_lvalue( _cc_out );
  _cc_out << "_info(";
  get_left()->_publish_cc_value( _cc_out );
  _cc_out << ", ";
  if(get_direction()->_is_ascending_range() == TRUE) {
    _cc_out << "ArrayInfo::to, ";
  }
  else {
    _cc_out << "ArrayInfo::downto, ";
  }
  get_right()->_publish_cc_value( _cc_out );
  _cc_out << ")";

  if ((_get_currently_publishing_unit() == PACKAGE_BODY) ||
      (_get_currently_publishing_unit() == PACKAGE_PUB)) {
    _cc_out << ";\n  TypeInfo& get";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "Info()";
    _cc_out << " {\n"
	    << "    return ";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "_info;\n"
	    << "  }\n\n";
  }
}

void
IIRScram_FloatingTypeDefinition::_publish_cc_extern_type_info( published_file &_cc_out ){
  SCRAM_CC_REF( _cc_out, "IIRScram_FloatingTypeDefinition::_publish_cc_extern_type_info" );
  ASSERT ( _is_scalar_type() == TRUE );
  
  if (_is_anonymous() == FALSE) {
    if ((_get_currently_publishing_unit() == PACKAGE_PUB) ||
	(_get_currently_publishing_unit() == PACKAGE_BODY)) {
      _cc_out << "  extern RealTypeInfo ";
      
    }
    else {
      _cc_out << "  RealTypeInfo ";
    }
    
    _publish_cc_lvalue( _cc_out );
    _cc_out << "_info;\n";
    
    
    _cc_out << "  TypeInfo& get";
    _publish_cc_lvalue( _cc_out );
    _cc_out << "Info()";
    
    if ((_get_currently_publishing_unit() != PACKAGE_PUB) &&
	(_get_currently_publishing_unit() != PACKAGE_BODY)) {
      _cc_out << " const {\n"
	      << "    return (TypeInfo &) ";
      _publish_cc_lvalue( _cc_out );
      _cc_out << "_info;\n"
	      << "  }\n\n";
    }
    else {
      _cc_out << ";\n";
    }
  }
  else {
    ASSERT (_get_base_type() != NULL);
    if (_get_base_type()->_is_anonymous() == FALSE) {
      _get_base_type()->_publish_cc_extern_type_info( _cc_out );
    }
  }
} 

void 
IIRScram_FloatingTypeDefinition::_publish_cc_type_string( published_file &_cc_out ){
  _cc_out << "RealType";
}

IIR_TypeDefinition *
IIRScram_FloatingTypeDefinition::_get_new_subtype(){
  IIR_TypeDefinition *retval = new IIR_FloatingSubtypeDefinition();
  copy_location( this, retval );
  return retval;
}

IIR *
IIRScram_FloatingTypeDefinition::_clone(){
  IIR_FloatingTypeDefinition *retval;
  IIR_TypeDefinition *temp = _get_new_subtype();

  ASSERT( temp->_is_iir_floating_type_definition() == TRUE );
  retval = (IIR_FloatingTypeDefinition *)temp;
  IIR_ScalarTypeDefinition::_clone( retval );

  return retval;
}

void 
IIRScram_FloatingTypeDefinition::_build_implicit_operators( set<IIR_Declaration> *add_to ){
  char *multiplying_operators[] = {"\"*\"", "\"/\"", NULL };
  IIR_ScalarTypeDefinition::_build_implicit_operators( add_to );
  IIR_TypeDefinition::_build_implicit_operators( multiplying_operators,
						 add_to,
						 this,
						 this,
						 this );

  IIR_TypeDefinition *integer_type = StandardPackage::get_integer_type();
  IIR_TypeDefinition::_build_implicit_operator( "\"**\"", add_to, this, this, integer_type );  
}

void 
IIRScram_FloatingTypeDefinition::_set_resolution_function( IIR_FunctionDeclaration * ){
  ostringstream err;
  err << "Internal error - IIRScram_FloatingTypeDefinition::_set_resolution_function was "
      << "called.  Resolution functions can't be associated with a floating type and this "
      << "should have been caught earlier.";
  report_error( this, err.str() );
}

IIR_FloatingSubtypeDefinition *
IIRScram_FloatingTypeDefinition::_construct_new_type( IIR_RangeTypeDefinition *init_info,
						      IIR_TypeDeclaration *type_decl ){
  IIR_FloatingSubtypeDefinition *retval = new IIR_FloatingSubtypeDefinition();
  IIR_FloatingTypeDefinition *base_type = new IIR_FloatingTypeDefinition();

  _init_scalar_type( init_info, base_type, retval, type_decl );

  return retval;
}


visitor_return_type *
IIRScram_FloatingTypeDefinition::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_FloatingTypeDefinition(this, arg);
};
