
// Copyright (c) 1996-2003 The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF THE
// SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
// IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE,
// OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY
// LICENSEE AS A RESULT OF USING, RESULT OF USING, MODIFYING OR
// DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the U.S.,
// and the terms of this license.

// You may modify, distribute, and use the software contained in this
// package under the terms of the "GNU LIBRARY GENERAL PUBLIC LICENSE"
// version 2, June 1991. A copy of this license agreement can be found in
// the file "LGPL", distributed with this archive.

// Authors: Philip A. Wilsey	philip.wilsey@ieee.org
//          Dale E. Martin	dmartin@cliftonlabs.com
//          Timothy J. McBrayer 
//          Umesh Kumar V. Rajasekaran
//          Krishnan Subramani  
//          Malolan Chetlur     
//          Narayanan Thondugulam

#include "IIRScram_ExitStatement.hh"
#include "IIR_Identifier.hh"
#include "IIR_Label.hh"
#include "IIR_List.hh"
#include "IIR_AboveAttribute.hh"
#include "resolution_func.hh"
#include "set.hh"
#include "published_file.hh"

IIRScram_ExitStatement::~IIRScram_ExitStatement() {}

void 
IIRScram_ExitStatement::_publish_vhdl(ostream &_vhdl_out) {

  _publish_vhdl_stmt_label(_vhdl_out);
    
  _vhdl_out << "exit ";
    
  if (get_enclosing_loop() != NULL) {
    get_enclosing_loop()->get_label()->_publish_vhdl(_vhdl_out);
  }
    
  if (get_condition() != NULL) {
    _vhdl_out << "\nwhen ";
    get_condition()->_publish_vhdl(_vhdl_out);
  }
}

void 
IIRScram_ExitStatement::_publish_cc( published_file &_cc_out ) {

  if (get_label() != NULL) {
    get_label()->_publish_cc_lvalue( _cc_out );
    _cc_out << ": ";
  }

  if (get_condition() != NULL) {
    ASSERT(get_condition()->_is_resolved() == TRUE);
    _cc_out << "if (SAVANT_BOOLEAN_TRUE == ";
    get_condition()->_publish_cc_lvalue( _cc_out );
    _cc_out << ") {\n";
  }
  if (get_enclosing_loop() != NULL) {
    //ASSERT(get_enclosing_loop()->_is_resolved() == TRUE);
    _cc_out << "goto ";
    get_enclosing_loop()->_publish_cc_exit_label( _cc_out );
    _cc_out << ";\n";
  }
  else {
    _cc_out << "break;\n";
  }
  if (get_condition() != NULL) {
    _cc_out << "}\n";
  }
}

void
IIRScram_ExitStatement::_type_check() {
  if( get_condition() != NULL ){
    set_condition( _type_check_and_resolve_boolean_condition( get_condition() ) );
  }
}

void
IIRScram_ExitStatement::_get_list_of_input_signals( set<IIR> *list ){
  if(get_condition() != NULL) {
    get_condition()->_get_list_of_input_signals(list);
  }
}

IIR_Boolean
IIRScram_ExitStatement::_is_above_attribute_found() {
  IIR_Boolean retval = FALSE;
  if(get_condition() != NULL) {
    retval = retval ||  get_condition()->_is_above_attribute_found();
  }
  return retval;
}

void
IIRScram_ExitStatement::
_build_above_attribute_set(set<IIR_AboveAttribute> *to_build) {
  if(get_condition() != NULL) {
    get_condition()->_build_above_attribute_set(to_build);
  }
}

visitor_return_type *IIRScram_ExitStatement::_accept_visitor(node_visitor *visitor, visitor_argument_type *arg) {
  ASSERT(visitor != NULL);
  return visitor->visit_IIR_ExitStatement(this, arg);
};
